<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Investment Analysis and Advisory";
$query = "SELECT * FROM investment_analysis_advisory WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Investment Analysis and Advisory',
        'meta_description' => 'Expertise in financial analysis and investment advisory. Optimize your portfolios with our personalized strategies.',
        'meta_keywords' => 'financial analysis, investment advisory, portfolio management, investment strategy, GIFAM',
        'hero_title' => 'Investment Analysis and Advisory',
        'hero_subtitle' => 'Optimize your investments with our expertise in financial analysis and personalized investment strategies.',
        'hero_button_text' => 'Consult our experts',
        'hero_button_link' => '#contact',
        'analysis_1_title' => 'Portfolio Analysis',
        'analysis_1_description' => 'Complete evaluation of your current portfolio with personalized optimization recommendations.',
        'analysis_1_icon' => 'icofont-chart-pie',
        'analysis_2_title' => 'Investment Strategy',
        'analysis_2_description' => 'Development of investment strategies adapted to your objectives and risk profile.',
        'analysis_2_icon' => 'icofont-target',
        'analysis_3_title' => 'Risk Management',
        'analysis_3_description' => 'Identification and mitigation of risks to protect and optimize your investments.',
        'analysis_3_icon' => 'icofont-shield',
        'metrics_title' => 'Our Performance',
        'metric_1_number' => '15+',
        'metric_1_label' => 'Years of experience',
        'metric_2_number' => '500+',
        'metric_2_label' => 'Managed portfolios',
        'metric_3_number' => '25%',
        'metric_3_label' => 'Average return',
        'metric_4_number' => '98%',
        'metric_4_label' => 'Satisfied clients',
        'strategy_title' => 'Our Strategic Approach',
        'step_1_title' => 'Initial Analysis',
        'step_1_description' => 'Evaluation of your financial situation, objectives and risk tolerance.',
        'step_2_title' => 'Strategy Development',
        'step_2_description' => 'Creation of a personalized and diversified investment strategy.',
        'step_3_title' => 'Implementation',
        'step_3_description' => 'Implementation of the strategy with continuous monitoring and adjustments.',
        'step_4_title' => 'Continuous Optimization',
        'step_4_description' => 'Regular monitoring and optimization of the portfolio.',
        'expertise_title' => 'Our Areas of Expertise',
        'expertise_1_title' => 'International Markets',
        'expertise_1_description' => 'Access to international financial markets with expertise in geographical diversification.',
        'expertise_1_icon' => 'icofont-globe',
        'expertise_2_title' => 'Real Estate Investment',
        'expertise_2_description' => 'Real estate investment strategies with in-depth market analysis.',
        'expertise_2_icon' => 'icofont-building',
        'expertise_3_title' => 'Structured Products',
        'expertise_3_description' => 'Innovative investment solutions adapted to complex markets.',
        'expertise_3_icon' => 'icofont-coins',
        'cta_title' => 'Ready to optimize your investments?',
        'cta_subtitle' => 'Our experts are here to guide you towards financial success.',
        'cta_button_text' => 'Start now',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
<!-- Inject:css -->
<link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        :root {
            --primary-color: #dc3545;
            --secondary-color: #212529;
            --accent-color:rgb(0, 0, 0);
            --success-color:rgb(0, 0, 0);
            --info-color:rgb(0, 0, 0);
            --warning-color:rgb(0, 0, 0);
        }
        
        .investment-hero {
            background: linear-gradient(45deg, var(--secondary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 100px 0;
            position: relative;
        }
        
        .investment-hero::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .analysis-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            padding: 80px 0;
        }
        
        .analysis-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .analysis-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
        }
        
        .analysis-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
        }
        
        .analysis-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 25px;
        }
        
        .analysis-icon i {
            color: white;
            font-size: 32px;
        }
        
        .metrics-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 80px 0;
        }
        
        .metric-item {
            text-align: center;
            padding: 30px;
        }
        
        .metric-number {
            font-size: 3rem;
            font-weight: bold;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .metric-label {
            color: var(--secondary-color);
            font-weight: 600;
        }
        
        .strategy-section {
            padding: 80px 0;
            background: white;
        }
        
        .strategy-timeline {
            position: relative;
            padding-left: 50px;
        }
        
        .strategy-timeline::before {
            content: '';
            position: absolute;
            left: 20px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: var(--primary-color);
        }
        
        .timeline-item {
            position: relative;
            margin-bottom: 40px;
            padding-left: 30px;
        }
        
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -25px;
            top: 10px;
            width: 12px;
            height: 12px;
            background: var(--primary-color);
            border-radius: 50%;
            border: 3px solid white;
            box-shadow: 0 0 0 3px var(--primary-color);
        }
        
        .expertise-section {
            background: var(--secondary-color);
            color: white;
            padding: 80px 0;
        }
        
        .expertise-card {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .btn-investment {
            background: linear-gradient(45deg, var(--primary-color), var(--primary-color));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        
        .btn-investment:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(220, 53, 69, 0.3);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="investment-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn-investment btn btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="text-center">
                        <i class="icofont-chart-line" style="font-size: 150px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Analysis Grid -->
    <section class="analysis-grid">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="analysis-card">
                        <div class="analysis-icon">
                            <i class="<?php echo htmlspecialchars($page_data['analysis_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['analysis_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['analysis_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="analysis-card">
                        <div class="analysis-icon">
                            <i class="<?php echo htmlspecialchars($page_data['analysis_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['analysis_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['analysis_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="analysis-card">
                        <div class="analysis-icon">
                            <i class="<?php echo htmlspecialchars($page_data['analysis_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['analysis_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['analysis_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Metrics Section -->
    <section class="metrics-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['metrics_title']); ?></h2>
            <div class="row">
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_1_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_1_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_2_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_2_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_3_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_3_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_4_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_4_label']); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Strategy Section -->
    <section class="strategy-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['strategy_title']); ?></h2>
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="strategy-timeline">
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                        </div>
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                        </div>
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                        </div>
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Expertise Section -->
    <section class="expertise-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['expertise_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="expertise-card">
                        <h5><i class="<?php echo htmlspecialchars($page_data['expertise_1_icon']); ?>"></i> <?php echo htmlspecialchars($page_data['expertise_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['expertise_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="expertise-card">
                        <h5><i class="<?php echo htmlspecialchars($page_data['expertise_2_icon']); ?>"></i> <?php echo htmlspecialchars($page_data['expertise_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['expertise_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="expertise-card">
                        <h5><i class="<?php echo htmlspecialchars($page_data['expertise_3_icon']); ?>"></i> <?php echo htmlspecialchars($page_data['expertise_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['expertise_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" style="background: linear-gradient(45deg, var(--accent-color), var(--accent-color)); color: white; padding: 80px 0; text-align: center;">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-investment btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 
