<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Investment in Bonds";
$query = "SELECT * FROM investment_in_bonds WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Investment in Bonds',
        'meta_description' => "Investissez dans les obligations pour sécuriser et diversifier votre portefeuille. Analyse, sélection et gestion sur-mesure.",
        'meta_keywords' => 'obligations, investissement, rendement, sécurité, diversification, GIFAM',
        'hero_title' => 'Investment in Bonds',
        'hero_subtitle' => 'Des solutions obligataires adaptées à vos objectifs de rendement et de sécurité.',
        'hero_button_text' => 'Demander une analyse',
        'hero_button_link' => '#contact',
        'services_title' => 'Nos services obligataires',
        'service_1_title' => 'Analyse de marché',
        'service_1_description' => 'Étude approfondie des tendances et opportunités sur le marché obligataire.',
        'service_1_icon' => 'icofont-chart-line',
        'service_2_title' => "Sélection d'obligations",
        'service_2_description' => 'Choix rigoureux des titres selon votre profil et vos objectifs.',
        'service_2_icon' => 'icofont-tasks-alt',
        'service_3_title' => 'Gestion & suivi',
        'service_3_description' => 'Accompagnement dans la gestion, le suivi et l’arbitrage de vos obligations.',
        'service_3_icon' => 'icofont-ui-check',
        'process_title' => 'Notre démarche',
        'step_1_title' => 'Définition des objectifs',
        'step_1_description' => 'Analyse de votre situation et de vos attentes en matière d’investissement.',
        'step_2_title' => 'Étude des opportunités',
        'step_2_description' => 'Sélection des meilleures obligations selon le contexte de marché.',
        'step_3_title' => 'Mise en place',
        'step_3_description' => 'Constitution et allocation du portefeuille obligataire.',
        'step_4_title' => 'Suivi & reporting',
        'step_4_description' => 'Contrôle régulier, reporting et ajustements stratégiques.',
        'metrics_title' => 'Nos chiffres clés',
        'metric_1_number' => '200+',
        'metric_1_label' => 'Portefeuilles gérés',
        'metric_2_number' => '3,2M€',
        'metric_2_label' => 'Valeur moyenne investie',
        'metric_3_number' => '99%',
        'metric_3_label' => 'Taux de satisfaction',
        'metric_4_number' => '48h',
        'metric_4_label' => 'Délai moyen de souscription',
        'cta_title' => 'Prêt à investir dans les obligations ?',
        'cta_subtitle' => 'Nos experts vous accompagnent pour sécuriser et dynamiser votre patrimoine.',
        'cta_button_text' => 'Contactez-nous',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $url; ?>investment-in-bonds/">
    <meta property="og:title" content="<?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM">
    <meta property="og:description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta property="og:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo $url; ?>investment-in-bonds/">
    <meta property="twitter:title" content="<?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM">
    <meta property="twitter:description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta property="twitter:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $url; ?>images/logos/fav.png">
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    <style>
        .bonds-hero {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        .bonds-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('<?php echo $url; ?>images/primary-blur-bg.png') center/cover;
            opacity: 0.1;
        }
        .bonds-hero .container { position: relative; z-index: 2; }
        .bonds-section { padding: 80px 0; }
        .bonds-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #f0f0f0;
        }
        .bonds-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
        }
        .bonds-icon {
            width: 80px; height: 80px;
            background: #DB2913;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            margin-bottom: 25px; color: white; font-size: 2rem;
        }
        .bonds-list li {
            padding-left: 25px; position: relative; margin-bottom: 10px;
        }
        .bonds-list li::before {
            content: '✓'; position: absolute; left: 0; color: #ff6b35; font-weight: bold;
        }
        .cta-section {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white; padding: 80px 0; text-align: center;
        }
        .cta-button {
            background: #DB2913;
            color: white; padding: 15px 40px; border-radius: 50px;
            text-decoration: none; font-weight: 600; display: inline-block;
            margin-top: 30px; transition: all 0.3s ease; border: none;
        }
        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(219,41,19,0.4);
            color: white; text-decoration: none;
        }
        .btn-primary {
            background: #DB2913 !important;
            border-color: #DB2913 !important;
        }
        .btn-primary:hover, .btn-primary:focus {
            background: #a81f0f !important;
            border-color: #a81f0f !important;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>
<!-- Hero Section -->
<section class="bonds-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                <div class="hero-buttons">
                    <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-primary btn-lg me-3"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    <a href="#bonds-types" class="btn btn-outline-light btn-lg">Types d'Obligations</a>
                </div>
            </div>
            <div class="col-lg-6">
                <img src="<?php echo $url; ?>images/case-study/case-study-2.jpg" alt="Obligations" class="img-fluid rounded-3">
            </div>
        </div>
    </div>
</section>
<!-- Pourquoi investir en obligations -->
<section class="bonds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['services_title']); ?></h2>
                <p class="lead">Les obligations offrent sécurité, prévisibilité et diversification à votre portefeuille. Elles conviennent aux investisseurs recherchant un revenu régulier et une protection du capital.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                    <ul class="bonds-list">
                        <li><?php echo htmlspecialchars($page_data['service_1_description']); ?></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                    <ul class="bonds-list">
                        <li><?php echo htmlspecialchars($page_data['service_2_description']); ?></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                    <ul class="bonds-list">
                        <li><?php echo htmlspecialchars($page_data['service_3_description']); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Types d'obligations -->
<section id="bonds-types" class="bonds-section">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Types d'Obligations Proposées</h2>
                <p class="lead">GIFAM vous accompagne dans la sélection des meilleures obligations selon vos objectifs et votre profil d'investisseur.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-bank"></i></div>
                    <h4>Obligations d'État</h4>
                    <ul class="bonds-list">
                        <li>Sécurité maximale</li>
                        <li>Émissions souveraines</li>
                        <li>Idéal pour les profils prudents</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-building"></i></div>
                    <h4>Obligations d'Entreprise</h4>
                    <ul class="bonds-list">
                        <li>Rendement supérieur</li>
                        <li>Large choix de secteurs</li>
                        <li>Différents niveaux de risque</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-globe"></i></div>
                    <h4>Obligations Internationales</h4>
                    <ul class="bonds-list">
                        <li>Diversification géographique</li>
                        <li>Accès à de nouveaux marchés</li>
                        <li>Opportunités de rendement</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Processus d'investissement -->
<section class="bonds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
                <p class="lead">Notre accompagnement se déroule en plusieurs étapes pour garantir la réussite de votre investissement obligataire.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <h5 class="mb-3"><span class="badge bg-primary">1</span> <?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <h5 class="mb-3"><span class="badge bg-primary">2</span> <?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <h5 class="mb-3"><span class="badge bg-primary">3</span> <?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <h5 class="mb-3"><span class="badge bg-primary">4</span> <?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Chiffres clés -->
<section class="bonds-section">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['metrics_title']); ?></h2>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="display-4 fw-bold text-primary mb-2"><?php echo htmlspecialchars($page_data['metric_1_number']); ?></div>
                    <div><?php echo htmlspecialchars($page_data['metric_1_label']); ?></div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="display-4 fw-bold text-primary mb-2"><?php echo htmlspecialchars($page_data['metric_2_number']); ?></div>
                    <div><?php echo htmlspecialchars($page_data['metric_2_label']); ?></div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="display-4 fw-bold text-primary mb-2"><?php echo htmlspecialchars($page_data['metric_3_number']); ?></div>
                    <div><?php echo htmlspecialchars($page_data['metric_3_label']); ?></div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="display-4 fw-bold text-primary mb-2"><?php echo htmlspecialchars($page_data['metric_4_number']); ?></div>
                    <div><?php echo htmlspecialchars($page_data['metric_4_label']); ?></div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- CTA -->
<section class="cta-section">
    <div class="container">
        <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
        <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="cta-button btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
    </div>
</section>
<?php include '../footer.php'; ?>
<!-- JS Files -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/slick.min.js"></script>
<script src="<?php echo $url; ?>js/jquery.nice-select.min.js"></script>
<script src="<?php echo $url; ?>js/jquery.magnific-popup.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>
</body>
</html> 
