<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Investment Management";
$query = "SELECT * FROM investment_management WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Investment Management',
        'meta_description' => "Gestion professionnelle de vos investissements : stratégie, allocation, suivi et optimisation de portefeuille.",
        'meta_keywords' => 'gestion de portefeuille, investissement, allocation, optimisation, GIFAM, performance',
        'hero_title' => 'Investment Management',
        'hero_subtitle' => 'Confiez la gestion de vos actifs à des experts pour maximiser la performance et maîtriser les risques.',
        'hero_button_text' => 'Demander un rendez-vous',
        'hero_button_link' => '#contact',
        'services_title' => 'Nos services de gestion',
        'service_1_title' => 'Stratégie personnalisée',
        'service_1_description' => 'Élaboration d’une stratégie d’investissement adaptée à vos objectifs.',
        'service_1_icon' => 'icofont-light-bulb',
        'service_2_title' => "Allocation d’actifs",
        'service_2_description' => 'Répartition optimale entre classes d’actifs selon votre profil.',
        'service_2_icon' => 'icofont-pie-chart',
        'service_3_title' => 'Suivi & reporting',
        'service_3_description' => 'Contrôle régulier, reporting détaillé et ajustements stratégiques.',
        'service_3_icon' => 'icofont-chart-bar-graph',
        'process_title' => 'Notre démarche',
        'step_1_title' => 'Analyse du profil',
        'step_1_description' => 'Étude de votre situation, de vos objectifs et de votre tolérance au risque.',
        'step_2_title' => 'Construction du portefeuille',
        'step_2_description' => 'Sélection et allocation des actifs selon la stratégie définie.',
        'step_3_title' => 'Mise en œuvre',
        'step_3_description' => 'Investissement progressif et gestion active.',
        'step_4_title' => 'Suivi & optimisation',
        'step_4_description' => 'Reporting, rééquilibrage et optimisation continue.',
        'metrics_title' => 'Nos chiffres clés',
        'metric_1_number' => '300+',
        'metric_1_label' => 'Portefeuilles gérés',
        'metric_2_number' => '5M€',
        'metric_2_label' => 'Encours moyen par client',
        'metric_3_number' => '97%',
        'metric_3_label' => 'Clients satisfaits',
        'metric_4_number' => '72h',
        'metric_4_label' => 'Délai moyen de mise en gestion',
        'cta_title' => 'Prêt à optimiser la gestion de vos investissements ?',
        'cta_subtitle' => 'Nos experts vous accompagnent pour une gestion performante et sécurisée.',
        'cta_button_text' => 'Contactez-nous',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM | Services de Gestion de Portefeuille Professionnelle</title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $url; ?>investment-management/">
    <meta property="og:title" content="<?php echo htmlspecialchars($page_data['page_title']); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta property="og:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo $url; ?>investment-management/">
    <meta property="twitter:title" content="<?php echo htmlspecialchars($page_data['page_title']); ?>">
    <meta property="twitter:description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta property="twitter:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $url; ?>images/logos/fav.png">
    
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    
    <!-- Custom CSS for Investment Management -->
    <style>
        .investment-hero {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .investment-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('<?php echo $url; ?>images/primary-blur-bg.png') center/cover;
            opacity: 0.1;
        }
        
        .investment-hero .container {
            position: relative;
            z-index: 2;
        }
        
        .hero-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            margin-top: 60px;
        }
        
        .stat-item {
            text-align: center;
            padding: 30px 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            color: #ff6b35;
            margin-bottom: 10px;
        }
        
        .stat-label {
            font-size: 1.1rem;
            color: #e0e0e0;
        }
        
        .management-section {
            padding: 80px 0;
        }
        
        .service-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #f0f0f0;
        }
        
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        }
        
        .service-icon {
            width: 80px;
            height: 80px;
            background: #DB2913;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 25px;
            color: white;
            font-size: 2rem;
        }
        
        .process-step {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            position: relative;
            margin-bottom: 30px;
        }
        
        .step-number {
            position: absolute;
            top: -15px;
            left: 30px;
            width: 40px;
            height: 40px;
            background: #ff6b35;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.2rem;
        }
        
        .strategy-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 50px;
        }
        
        .strategy-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            border-left: 5px solid #ff6b35;
        }
        
        .strategy-card h4 {
            color: #333;
            margin-bottom: 15px;
            font-weight: 600;
        }
        
        .strategy-card ul {
            list-style: none;
            padding: 0;
        }
        
        .strategy-card li {
            padding: 8px 0;
            position: relative;
            padding-left: 25px;
        }
        
        .strategy-card li::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: #ff6b35;
            font-weight: bold;
        }
        
        .cta-section {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .cta-button {
            background: #DB2913;
            color: white;
            padding: 15px 40px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            display: inline-block;
            margin-top: 30px;
            transition: all 0.3s ease;
            border: none;
        }
        
        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(219,41,19,0.4);
            color: white;
            text-decoration: none;
        }
        .btn-primary {
            background: #DB2913 !important;
            border-color: #DB2913 !important;
        }
        .btn-primary:hover, .btn-primary:focus {
            background: #a81f0f !important;
            border-color: #a81f0f !important;
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="investment-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                    <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                    <div class="hero-buttons">
                        <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Consultation Gratuite</a>
                        <a href="#services" class="btn btn-outline-light btn-lg">Nos Services</a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <img src="<?php echo $url; ?>images/case-study/project-result.png" alt="Gestion d'Investissement" class="img-fluid rounded-3">
                </div>
            </div>
            
            <div class="hero-stats">
                <div class="stat-item">
                    <div class="stat-number"><?php echo htmlspecialchars($page_data['metric_1_number']); ?></div>
                    <div class="stat-label"><?php echo htmlspecialchars($page_data['metric_1_label']); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-number"><?php echo htmlspecialchars($page_data['metric_2_number']); ?></div>
                    <div class="stat-label"><?php echo htmlspecialchars($page_data['metric_2_label']); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-number"><?php echo htmlspecialchars($page_data['metric_3_number']); ?></div>
                    <div class="stat-label"><?php echo htmlspecialchars($page_data['metric_3_label']); ?></div>
                </div>
                <div class="stat-item">
                    <div class="stat-number"><?php echo htmlspecialchars($page_data['metric_4_number']); ?></div>
                    <div class="stat-label"><?php echo htmlspecialchars($page_data['metric_4_label']); ?></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services" class="management-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['services_title']); ?></h2>
                    <p class="lead">Nous offrons une gamme complète de services de gestion d'investissement adaptés à vos besoins spécifiques.</p>
                </div>
            </div>
            
            <div class="row g-4">
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-briefcase"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                        <ul class="list-unstyled">
                            <li>✓ Allocation d'actifs dynamique</li>
                            <li>✓ Rééquilibrage automatique</li>
                            <li>✓ Suivi de performance</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-chart-bar-graph"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                        <ul class="list-unstyled">
                            <li>✓ Analyse fondamentale</li>
                            <li>✓ Recherche sectorielle</li>
                            <li>✓ Veille économique</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-shield"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                        <ul class="list-unstyled">
                            <li>✓ Diversification intelligente</li>
                            <li>✓ Hedging stratégique</li>
                            <li>✓ Monitoring continu</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-certificate"></i></div>
                        <h4>Optimisation Fiscale</h4>
                        <p>Stratégies d'investissement optimisées pour minimiser votre charge fiscale et maximiser vos gains nets.</p>
                        <ul class="list-unstyled">
                            <li>✓ Planification fiscale</li>
                            <li>✓ Produits fiscalement avantageux</li>
                            <li>✓ Reporting fiscal</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-ui-calendar"></i></div>
                        <h4>Planification de Retraite</h4>
                        <p>Stratégies d'épargne et d'investissement pour sécuriser votre avenir et maintenir votre niveau de vie.</p>
                        <ul class="list-unstyled">
                            <li>✓ Épargne retraite</li>
                            <li>✓ Produits de retraite</li>
                            <li>✓ Projections financières</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-bank"></i></div>
                        <h4>Gestion de Patrimoine</h4>
                        <p>Approche globale de la gestion de votre patrimoine incluant investissements, immobilier et succession.</p>
                        <ul class="list-unstyled">
                            <li>✓ Conseil patrimonial</li>
                            <li>✓ Transmission de patrimoine</li>
                            <li>✓ Optimisation successorale</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="management-section bg-light">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
                    <p class="lead">Une approche méthodique et transparente pour optimiser vos investissements.</p>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-users-alt-3"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['step_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                        <ul>
                            <li>Analyse de votre situation actuelle</li>
                            <li>Définition de vos objectifs</li>
                            <li>Évaluation de votre profil de risque</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-handshake-deal"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['step_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                        <ul>
                            <li>Allocation d'actifs optimisée</li>
                            <li>Sélection d'instruments financiers</li>
                            <li>Plan de diversification</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-chart-growth"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['step_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                        <ul>
                            <li>Exécution des ordres</li>
                            <li>Monitoring quotidien</li>
                            <li>Ajustements stratégiques</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-pie-chart"></i></div>
                        <h4><?php echo htmlspecialchars($page_data['step_4_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                        <ul>
                            <li>Rapports de performance</li>
                            <li>Analyse comparative</li>
                            <li>Optimisation continue</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Strategies Section -->
    <section class="management-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="display-5 fw-bold mb-4">Nos Stratégies d'Investissement</h2>
                    <p class="lead">Des approches éprouvées pour différents profils d'investisseurs et objectifs financiers.</p>
                </div>
            </div>
            
            <div class="strategy-grid">
                <div class="strategy-card">
                    <h4>Stratégie Conservatrice</h4>
                    <p>Pour les investisseurs privilégiant la préservation du capital avec un rendement stable.</p>
                    <ul>
                        <li>Allocation majoritairement en obligations</li>
                        <li>Actions de grandes entreprises stables</li>
                        <li>Produits monétaires</li>
                        <li>Rendement attendu : 3-5% annuel</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Équilibrée</h4>
                    <p>Équilibre entre croissance et stabilité pour un portefeuille diversifié.</p>
                    <ul>
                        <li>Mix actions/obligations 60/40</li>
                        <li>Diversification internationale</li>
                        <li>Produits alternatifs</li>
                        <li>Rendement attendu : 6-8% annuel</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Dynamique</h4>
                    <p>Pour les investisseurs recherchant une croissance agressive du capital.</p>
                    <ul>
                        <li>Majorité en actions</li>
                        <li>Exposition aux marchés émergents</li>
                        <li>Produits structurés</li>
                        <li>Rendement attendu : 8-12% annuel</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Alternative</h4>
                    <p>Investissements non traditionnels pour diversifier et améliorer les rendements.</p>
                    <ul>
                        <li>Private Equity</li>
                        <li>Immobilier d'entreprise</li>
                        <li>Commodities et matières premières</li>
                        <li>Hedge Funds</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie ESG</h4>
                    <p>Investissement responsable intégrant les critères environnementaux, sociaux et de gouvernance.</p>
                    <ul>
                        <li>Fonds verts et durables</li>
                        <li>Entreprises à impact positif</li>
                        <li>Exclusion des secteurs controversés</li>
                        <li>Mesure de l'impact</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Tactique</h4>
                    <p>Approche flexible s'adaptant aux conditions de marché en temps réel.</p>
                    <ul>
                        <li>Rotation sectorielle</li>
                        <li>Timing de marché</li>
                        <li>Gestion des liquidités</li>
                        <li>Ajustements fréquents</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto text-center">
                    <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
                    <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                    <a href="<?php echo $url; ?><?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="cta-button">Commencer Maintenant</a>
                </div>
            </div>
        </div>
    </section>

    <?php include '../footer.php'; ?>

    <!-- JavaScript Files -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
    <script src="<?php echo $url; ?>js/main.js"></script>
    
    <!-- Custom JavaScript for Investment Management -->
    <script>
        $(document).ready(function() {
            // Animation des statistiques avec gestion des suffixes
            $('.stat-number').each(function() {
                var $this = $(this);
                var original = $this.text().trim();
                var match = original.match(/([\d,.]+)/);
                var number = match ? parseFloat(match[1].replace(',', '.')) : 0;
                var suffix = original.replace(match ? match[1] : '', '');
                $this.text('0' + suffix);
                $({Counter: 0}).animate({Counter: number}, {
                    duration: 2000,
                    easing: 'swing',
                    step: function(now) {
                        var display = Math.ceil(now) + suffix;
                        $this.text(display);
                    },
                    complete: function() {
                        $this.text(original);
                    }
                });
            });
            // Smooth scrolling for anchor links
            $('a[href^="#"]').on('click', function(event) {
                var target = $(this.getAttribute('href'));
                if (target.length) {
                    event.preventDefault();
                    $('html, body').stop().animate({
                        scrollTop: target.offset().top - 100
                    }, 1000);
                }
            });
            // Add hover effects to service cards
            $('.service-card').hover(
                function() {
                    $(this).find('.service-icon').css('transform', 'scale(1.1)');
                },
                function() {
                    $(this).find('.service-icon').css('transform', 'scale(1)');
                }
            );
        });
    </script>
</body>
</html> 
