<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
// $page_title = "Investment";
// $query = "SELECT * FROM investment WHERE page_name = ?";
// $stmt = $conn->prepare($query);
// $stmt->bind_param("s", $page_title);
// $stmt->execute();
// $result = $stmt->get_result();
// $page_data = $result->fetch_assoc();

// Récupération des données dynamiques de la page
$page_title = "Investment";
$query = "SELECT * FROM investment WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Valeurs par défaut pour chaque champ attendu
$defaults = [
    'page_title' => 'Investment',
    'meta_description' => "Découvrez nos solutions d'investissement sur-mesure : analyse, sélection, gestion et suivi pour optimiser votre patrimoine.",
    'meta_keywords' => 'investissement, gestion, portefeuille, analyse, GIFAM, stratégie',
    'hero_title' => 'Solutions d\'Investissement',
    'hero_subtitle' => 'Des stratégies personnalisées pour faire fructifier et sécuriser votre capital.',
    'hero_image' => 'images/investment/hero.jpg',
    'hero_intro' => 'GIFAM propose des services d\'investissement complets pour atteindre vos objectifs financiers. Notre équipe d\'experts élabore des stratégies personnalisées, gère votre portefeuille et vous accompagne dans la durée.',
    'hero_button_text' => 'Demander un conseil',
    'hero_button_link' => '../contact-us/',
    'services_title' => 'Nos services d\'investissement',
    'service_1_title' => 'Analyse de portefeuille',
    'service_1_description' => 'Évaluation complète de votre situation et de vos objectifs.',
    'service_1_icon' => 'icofont-chart-line',
    'service_2_title' => "Sélection d'actifs",
    'service_2_description' => 'Choix des meilleurs supports selon votre profil.',
    'service_2_icon' => 'icofont-tasks-alt',
    'service_3_title' => 'Gestion & suivi',
    'service_3_description' => 'Accompagnement dans la gestion, le suivi et l\'optimisation de vos placements.',
    'service_3_icon' => 'icofont-ui-check',
    'types_title' => 'Types d\'investissement',
    'type_1_title' => 'Actions',
    'type_1_description' => 'Titres de sociétés cotées pour dynamiser votre portefeuille.',
    'type_1_image' => 'images/case-study/case-study-2.jpg',
    'type_2_title' => 'Obligations',
    'type_2_description' => 'Titres à revenu fixe pour sécuriser une partie de votre capital.',
    'type_2_image' => 'images/case-study/case-study-3.jpg',
    'type_3_title' => 'Immobilier',
    'type_3_description' => 'Investissements immobiliers directs ou via SCPI/OPCI.',
    'type_3_image' => 'images/case-study/case-study-4.jpg',
    'type_4_title' => 'Alternatifs',
    'type_4_description' => 'Fonds alternatifs, private equity, matières premières.',
    'type_4_image' => 'images/case-study/case-study-5.jpg',
    'process_title' => 'Notre démarche',
    'process_1_title' => 'Consultation initiale',
    'process_1_description' => 'Compréhension de vos objectifs et de votre profil.',
    'process_2_title' => 'Analyse de portefeuille',
    'process_2_description' => 'Diagnostic de votre situation actuelle.',
    'process_3_title' => 'Définition de la stratégie',
    'process_3_description' => 'Construction d\'une allocation sur-mesure.',
    'process_4_title' => 'Mise en œuvre & suivi',
    'process_4_description' => 'Investissement progressif, reporting et ajustements.',
    'metrics_title' => 'Nos chiffres clés',
    'metric_1_number' => '500+',
    'metric_1_label' => 'Clients accompagnés',
    'metric_2_number' => '10M€',
    'metric_2_label' => 'Encours moyen géré',
    'metric_3_number' => '98%',
    'metric_3_label' => 'Clients satisfaits',
    'metric_4_number' => '48h',
    'metric_4_label' => 'Délai moyen de souscription',
    'advantages_title' => 'Les avantages',
    'advantages_intro' => 'Pourquoi choisir GIFAM pour vos investissements ?',
    'advantage_1_title' => 'Gestion experte',
    'advantage_1_description' => 'Accès à des professionnels expérimentés.',
    'advantage_2_title' => 'Réduction des risques',
    'advantage_2_description' => 'Diversification et gestion active.',
    'advantage_3_title' => 'Gain de temps',
    'advantage_3_description' => 'Nous gérons, vous profitez.',
    'advantage_4_title' => 'Opportunités exclusives',
    'advantage_4_description' => 'Accès à des placements réservés aux institutionnels.',
    'strategies_title' => 'Nos stratégies',
    'strategy_1_title' => 'Stratégie de croissance',
    'strategy_1_description' => 'Recherche de performance via des actifs à fort potentiel.',
    'strategy_2_title' => 'Stratégie de revenu',
    'strategy_2_description' => 'Génération de revenus réguliers (dividendes, coupons).',
    'strategy_3_title' => 'Stratégie équilibrée',
    'strategy_3_description' => 'Mix entre croissance et sécurité.',
    'cta_title' => 'Prêt à investir ?',
    'cta_subtitle' => 'Nos experts vous accompagnent pour bâtir votre stratégie patrimoniale.',
    'cta_button_text' => 'Contactez-nous',
    'cta_button_link' => '../contact-us/'
];

// Remplacer les valeurs NULL ou absentes par les valeurs par défaut
foreach ($defaults as $key => $value) {
    if (!isset($page_data[$key]) || is_null($page_data[$key]) || trim($page_data[$key]) === '') {
        $page_data[$key] = $value;
    }
}
// Debug : Affichage du contenu de $page_data
// À retirer en production
// echo '<pre>';
// var_dump($page_data);
// echo '</pre>';
// Test affichage HTML
// echo '<h2>TEST AFFICHAGE</h2><p>Ceci est un test</p>';

// Fonction pour décoder les entités HTML avant affichage
function decode_entities(
    $string
) {
    return htmlspecialchars(html_entity_decode($string, ENT_QUOTES | ENT_HTML5, 'UTF-8'));
}
?>

    <?php
// Connexion à la base
include 'db.php';
// Charger les slides
$page_data = $pdo->query("SELECT * FROM investment LIMIT 1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <!-- Tabs CSS -->
    <style>
        /* Tabs Container */
        .tabs-container {
            background: #fff;
            border-radius: 0px;
            overflow: hidden;
        }
        
        /* Tabs Navigation */
        .tabs-nav {
            display: flex;
            flex-wrap: wrap;
            background: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: #d12907 #f8f9fa;
        }
        
        .tabs-nav::-webkit-scrollbar {
            height: 6px;
        }
        
        .tabs-nav::-webkit-scrollbar-track {
            background: #f8f9fa;
        }
        
        .tabs-nav::-webkit-scrollbar-thumb {
            background: #d12907;
            border-radius: 3px;
        }
        
        .tab-item {
            flex: 1;
            min-width: 250px;
            padding: 12px 16px;
            text-align: center;
            background: #f8f9fa;
            color: #666;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.9rem;
            font-weight: 500;
            white-space: nowrap;
            border-right: 1px solid #e9ecef;
        }
        
        .tab-item:hover {
            background: #e9ecef;
            color: #333;
        }
        
        .tab-item.active {
            background: #dc3545;
            color: white;
            font-weight: 600;
            padding:12px 20px;
        }
        
        /* Tab Content */
        .tab-content-container {
            padding: 30px;
            min-height: 400px;
        }
        
        .tab-content {
            display: none;
            animation: fadeIn 0.3s ease-in;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .tab-header {
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f8f9fa;
        }
        
        .tab-header h3 {
            color: #333;
            font-weight: 700;
            margin: 0;
        }
        
        /* Form Styling */
        .form-section {
            margin-bottom: 25px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        
        .form-control {
            width: 100%;
            padding: 2px 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #fff;
        }
        
        .form-control:focus {
            border-color: #dc3545;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
            outline: none;
        }
        
        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .form-check {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .form-check-input {
            margin-right: 8px;
            width: 18px;
            height: 18px;
        }
        
        .form-check-label {
            margin: 0;
            font-weight: 500;
            color: #555;
        }
        
        /* Navigation Buttons */
        .tab-navigation {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 30px;
            background: #f8f9fa;
            border-top: 1px solid #e9ecef;
        }
        
        .btn {
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }
        
        .btn-primary {
            background: #dc3545;
            color: white;
        }
        
        .btn-primary:hover {
            background: #c82333;
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background: #dc3545
            color: white;
        }
        
        .btn-success:hover {
            background: #dc3545;
            transform: translateY(-2px);
        }
        
        /* Progress Indicator */
        .progress-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .progress-step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e9ecef;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 5px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .progress-step.active {
            background: #dc3545;
            color: white;
        }
        
        .progress-step.completed {
            background: #dc3545;
            color: white;
        }
        
        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .tabs-nav {
                flex-direction: column;
            }
            
            .tab-item {
                min-width: auto;
                border-right: none;
                border-bottom: 1px solid #e9ecef;
            }
            
            .tab-content-container {
                padding: 20px;
            }
            
            .checkbox-group {
                flex-direction: column;
                gap: 10px;
            }
            
            .tab-navigation {
                flex-direction: column;
                gap: 10px;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>investment/">Investment Services</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Page Title -->

    <br>
    <br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h2><?php echo decode_entities($page_data['hero_title']); ?></h2>
                            <p class="lead"><?php echo decode_entities($page_data['hero_subtitle']); ?></p>
                            <p><?php echo decode_entities($page_data['hero_intro']); ?></p>
                            <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-primary btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url . htmlspecialchars($page_data['hero_image']); ?>" alt="Investment" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Investment Services Grid -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['services_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>" style="font-size: 3rem; color: #dc3545 !important;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>" style="font-size: 3rem; color: #dc3545 !important;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>" style="font-size: 3rem; color: #dc3545 !important;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Investment tabs form -->
                  <?php
// process_form.php
// Configuration
$to_email = "info@gifam.eu"; // Changez ceci par votre adresse email
$from_email = "info@gifam.eu"; // Email d'expéditeur
$email_subject = "Nouvelle demande d'étude de faisabilité";
// Dossier pour les uploads
$upload_dir = 'uploads/';
$base_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['SCRIPT_NAME']);
$base_url = rtrim($base_url, '/');
// Créer le répertoire de téléchargement s'il n'existe pas
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}
// Vérifier que la méthode est POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Fonction pour nettoyer les données
    function clean_data($data) {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars($data);
        return $data;
    }
    // Collecter toutes les données du formulaire
    $form_data = array();
    // Section 1: Informations du demandeur
    $form_data['applicantName'] = isset($_POST['applicantName']) ? clean_data($_POST['applicantName']) : '';
    $form_data['applicantSurname'] = isset($_POST['applicantSurname']) ? clean_data($_POST['applicantSurname']) : '';
    $form_data['country'] = isset($_POST['country']) ? clean_data($_POST['country']) : '';
    $form_data['city'] = isset($_POST['city']) ? clean_data($_POST['city']) : '';
    $form_data['street'] = isset($_POST['street']) ? clean_data($_POST['street']) : '';
    $form_data['zip'] = isset($_POST['zip']) ? clean_data($_POST['zip']) : '';
    $form_data['phoneNumber'] = isset($_POST['phoneNumber']) ? clean_data($_POST['phoneNumber']) : '';
    $form_data['email'] = isset($_POST['email']) ? clean_data($_POST['email']) : '';
    // Section 2: Situation actuelle de l'entreprise
    $form_data['currentState'] = isset($_POST['currentState']) ? clean_data($_POST['currentState']) : '';
    $form_data['businessChallenges'] = isset($_POST['businessChallenges']) ? clean_data($_POST['businessChallenges']) : '';
    $form_data['businessOpportunities'] = isset($_POST['businessOpportunities']) ? clean_data($_POST['businessOpportunities']) : '';
    // Gérer les cases à cocher multiples
    $form_data['role'] = isset($_POST['role']) ? (is_array($_POST['role']) ? implode(', ', $_POST['role']) : $_POST['role']) : '';
    // Section 3: Informations sur le projet
    $form_data['projectPurpose'] = isset($_POST['projectPurpose']) ? clean_data($_POST['projectPurpose']) : '';
    $form_data['projectGoals'] = isset($_POST['projectGoals']) ? clean_data($_POST['projectGoals']) : '';
    $form_data['projectOwner'] = isset($_POST['projectOwner']) ? (is_array($_POST['projectOwner']) ? implode(', ', $_POST['projectOwner']) : $_POST['projectOwner']) : '';
    $form_data['role_project'] = isset($_POST['role']) ? clean_data($_POST['role']) : '';
    $form_data['projectLocation'] = isset($_POST['projectLocation']) ? clean_data($_POST['projectLocation']) : '';
    $form_data['landOwner'] = isset($_POST['landOwner']) ? (is_array($_POST['landOwner']) ? implode(', ', $_POST['landOwner']) : $_POST['landOwner']) : '';
    // Section 4: Financement
    $form_data['fundingSource'] = isset($_POST['fundingSource']) ? clean_data($_POST['fundingSource']) : '';
    $form_data['fundingType'] = isset($_POST['fundingType']) ? 'Oui' : 'Non';
    $form_data['loanDetails'] = isset($_POST['loanDetails']) ? clean_data($_POST['loanDetails']) : '';
    // Section 5: Données
    $form_data['dataCollection'] = isset($_POST['dataCollection']) ? clean_data($_POST['dataCollection']) : '';
    $form_data['dataType'] = isset($_POST['dataType']) ? (is_array($_POST['dataType']) ? implode(', ', $_POST['dataType']) : $_POST['dataType']) : '';
    $form_data['dataSource'] = isset($_POST['dataSource']) ? (is_array($_POST['dataSource']) ? implode(', ', $_POST['dataSource']) : $_POST['dataSource']) : '';
    // Section 6: Méthodologie
    $form_data['methodology'] = isset($_POST['methodology']) ? clean_data($_POST['methodology']) : '';
    // Sections 7-10: Études et conceptions
    $architecturalConception = isset($_POST['architecturalConception']) ? (is_array($_POST['architecturalConception']) ? $_POST['architecturalConception'] : [$_POST['architecturalConception']]) : array();
    $economicStudy = isset($_POST['economicStudy']) ? (is_array($_POST['economicStudy']) ? $_POST['economicStudy'] : [$_POST['economicStudy']]) : array();
    $financialStudy = isset($_POST['financialStudy']) ? (is_array($_POST['financialStudy']) ? $_POST['financialStudy'] : [$_POST['financialStudy']]) : array();
    $impact = isset($_POST['impact']) ? (is_array($_POST['impact']) ? $_POST['impact'] : [$_POST['impact']]) : array();
    $form_data['architecturalConception'] = !empty($architecturalConception) ? implode(', ', $architecturalConception) : '';
    $form_data['economicStudy'] = !empty($economicStudy) ? implode(', ', $economicStudy) : '';
    $form_data['financialStudy'] = !empty($financialStudy) ? implode(', ', $financialStudy) : '';
    $form_data['impact'] = !empty($impact) ? implode(', ', $impact) : '';
    // Section 11: Délai
    $form_data['timeline'] = isset($_POST['timeline']) ? clean_data($_POST['timeline']) : '';
    $form_data['startDate'] = isset($_POST['startDate']) ? clean_data($_POST['startDate']) : '';
    $form_data['deliveryDate'] = isset($_POST['deliveryDate']) ? clean_data($_POST['deliveryDate']) : '';
    // Section 12: Ressources
    $resources = isset($_POST['resources']) ? (is_array($_POST['resources']) ? $_POST['resources'] : [$_POST['resources']]) : array();
    $form_data['resources'] = !empty($resources) ? implode(', ', $resources) : '';
    // Section 13: Profil du consultant
    $form_data['consultantProfile'] = isset($_POST['consultantProfile']) ? clean_data($_POST['consultantProfile']) : '';
    // Section 14: Expertise supplémentaire
    $form_data['expertise'] = isset($_POST['expertise']) ? (is_array($_POST['expertise']) ? implode(', ', $_POST['expertise']) : $_POST['expertise']) : '';
    $form_data['expertiseArea'] = isset($_POST['expertiseArea']) ? clean_data($_POST['expertiseArea']) : '';
    // Section 15: Endossements
    $form_data['endorsements'] = isset($_POST['endorsements']) ? (is_array($_POST['endorsements']) ? implode(', ', $_POST['endorsements']) : $_POST['endorsements']) : '';
    // Section 16: Budget
    $form_data['budget'] = isset($_POST['budget']) ? clean_data($_POST['budget']) : '';
    $form_data['budgetFinancing'] = isset($_POST['budgetFinancing']) ? clean_data($_POST['budgetFinancing']) : '';
    // Section 17: Résultats
    $form_data['resultsPresentation'] = isset($_POST['resultsPresentation']) ? clean_data($_POST['resultsPresentation']) : '';
    // Section 18: Prochaine étape
    $form_data['nextStepIfViable'] = isset($_POST['nextStepIfViable']) ? clean_data($_POST['nextStepIfViable']) : '';
    $form_data['nextStepIfNotViable'] = isset($_POST['nextStepIfNotViable']) ? clean_data($_POST['nextStepIfNotViable']) : '';
    // Section 19: Informations supplémentaires
    $form_data['additionalInformation'] = isset($_POST['additionalInformation']) ? clean_data($_POST['additionalInformation']) : '';
    // Section 20: Approbation du demandeur
    $form_data['applicantNameApproval'] = isset($_POST['applicantNameApproval']) ? clean_data($_POST['applicantNameApproval']) : '';
    $form_data['approvalDate'] = isset($_POST['approvalDate']) ? clean_data($_POST['approvalDate']) : '';
    // Initialiser les variables pour les fichiers
    $signature_url = '';
    $file_url = '';
    $file_name = '';
    // Gérer la signature
    $signature_data = isset($_POST['signature_data']) ? $_POST['signature_data'] : '';
    if (!empty($signature_data) && preg_match('/^data:image\/(\w+);base64,/', $signature_data, $type)) {
        $data = substr($signature_data, strpos($signature_data, ',') + 1);
        $type = strtolower($type[1]); // jpg, png, gif
        if (in_array($type, array('jpg', 'jpeg', 'gif', 'png'))) {
            $data = base64_decode($data);
            if ($data !== false) {
                $signature_file_name = 'signature_' . uniqid() . '.' . $type;
                $signature_file_path = $upload_dir . $signature_file_name;
                if (file_put_contents($signature_file_path, $data)) {
                    $signature_url = $base_url . '/' . $signature_file_path;
                }
            }
        }
    }
    // Gérer le téléchargement de fichier
    $file_uploaded = false;
    if (isset($_FILES['Uploadyourproject']) && $_FILES['Uploadyourproject']['error'] == 0) {
        $file_name = $_FILES['Uploadyourproject']['name'];
        $file_tmp = $_FILES['Uploadyourproject']['tmp_name'];
        $file_size = $_FILES['Uploadyourproject']['size'];
        $file_type = $_FILES['Uploadyourproject']['type'];
        // Générer un nom de fichier unique
        $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
        $new_file_name = 'project_' . uniqid() . '_' . $file_name;
        $file_path = $upload_dir . $new_file_name;
        // Vérifier le type de fichier (ajuster selon vos besoins)
        $allowed_types = array('pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png', 'zip', 'txt');
        if (in_array(strtolower($file_ext), $allowed_types)) {
            // Déplacer le fichier téléchargé
            if (move_uploaded_file($file_tmp, $file_path)) {
                $file_uploaded = true;
                $file_url = $base_url . '/' . $file_path;
            }
        }
    }
    // Créer le corps de l'email
    $email_body = "
    <html>
    <head>
        <title>Demande d'étude de faisabilité</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .header { background-color: #000; color: white; padding: 20px; text-align: center; }
            .section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
            .section-title { color: #007bff; border-bottom: 2px solid #007bff; padding-bottom: 5px; margin-bottom: 15px; }
            .field { margin-bottom: 10px; }
            .field-label { font-weight: bold; display: inline-block; width: 250px; }
            .field-value { }
            .file-link { color: #007bff; text-decoration: none; }
            .file-link:hover { text-decoration: underline; }
        </style>
    </head>
    <body>
        <div class='header'>
            <h2>Demande d'étude de faisabilité</h2>
            <p>Date de soumission: " . date('d/m/Y H:i:s') . "</p>
        </div>
        <div class='section'>
            <h3 class='section-title'>1. INFORMATIONS DU DEMANDEUR</h3>
            <div class='field'><span class='field-label'>Nom(s):</span> <span class='field-value'>" . $form_data['applicantName'] . "</span></div>
            <div class='field'><span class='field-label'>Prénom:</span> <span class='field-value'>" . $form_data['applicantSurname'] . "</span></div>
            <div class='field'><span class='field-label'>Pays:</span> <span class='field-value'>" . $form_data['country'] . "</span></div>
            <div class='field'><span class='field-label'>Ville:</span> <span class='field-value'>" . $form_data['city'] . "</span></div>
            <div class='field'><span class='field-label'>Rue:</span> <span class='field-value'>" . $form_data['street'] . "</span></div>
            <div class='field'><span class='field-label'>Code postal:</span> <span class='field-value'>" . $form_data['zip'] . "</span></div>
            <div class='field'><span class='field-label'>Téléphone(s):</span> <span class='field-value'>" . $form_data['phoneNumber'] . "</span></div>
            <div class='field'><span class='field-label'>Email:</span> <span class='field-value'>" . $form_data['email'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>2. SITUATION ACTUELLE DE L'ENTREPRISE</h3>
            <div class='field'><span class='field-label'>État actuel de l'entreprise:</span> <span class='field-value'>" . $form_data['currentState'] . "</span></div>
            <div class='field'><span class='field-label'>Défis commerciaux:</span> <span class='field-value'>" . $form_data['businessChallenges'] . "</span></div>
            <div class='field'><span class='field-label'>Opportunités commerciales:</span> <span class='field-value'>" . $form_data['businessOpportunities'] . "</span></div>
            <div class='field'><span class='field-label'>Rôle de l'entreprise dans le projet:</span> <span class='field-value'>" . $form_data['role'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>3. INFORMATIONS SUR LE PROJET</h3>
            <div class='field'><span class='field-label'>Objectif de l'étude de faisabilité:</span> <span class='field-value'>" . $form_data['projectPurpose'] . "</span></div>
            <div class='field'><span class='field-label'>Objectifs du demandeur:</span> <span class='field-value'>" . $form_data['projectGoals'] . "</span></div>
            <div class='field'><span class='field-label'>Le demandeur est-il propriétaire du projet?:</span> <span class='field-value'>" . $form_data['projectOwner'] . "</span></div>
            <div class='field'><span class='field-label'>Rôle si non propriétaire:</span> <span class='field-value'>" . $form_data['role_project'] . "</span></div>
            <div class='field'><span class='field-label'>Emplacement du projet:</span> <span class='field-value'>" . $form_data['projectLocation'] . "</span></div>
            <div class='field'><span class='field-label'>Le demandeur est-il propriétaire du terrain?:</span> <span class='field-value'>" . $form_data['landOwner'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>4. FINANCEMENT</h3>
            <div class='field'><span class='field-label'>Origine du financement:</span> <span class='field-value'>" . $form_data['fundingSource'] . "</span></div>
            <div class='field'><span class='field-label'>Prêt:</span> <span class='field-value'>" . $form_data['fundingType'] . "</span></div>
            <div class='field'><span class='field-label'>Détails du prêt:</span> <span class='field-value'>" . $form_data['loanDetails'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>5. DONNÉES</h3>
            <div class='field'><span class='field-label'>Données à collecter et analyser:</span> <span class='field-value'>" . $form_data['dataCollection'] . "</span></div>
            <div class='field'><span class='field-label'>Type de données nécessaires:</span> <span class='field-value'>" . $form_data['dataType'] . "</span></div>
            <div class='field'><span class='field-label'>Source des données:</span> <span class='field-value'>" . $form_data['dataSource'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>6. MÉTHODOLOGIE</h3>
            <div class='field'><span class='field-label'>Méthodologie:</span> <span class='field-value'>" . $form_data['methodology'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>7. CONCEPTION ARCHITECTURALE</h3>
            <div class='field'><span class='field-label'>Éléments sélectionnés:</span> <span class='field-value'>" . $form_data['architecturalConception'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>8. ÉTUDE ÉCONOMIQUE</h3>
            <div class='field'><span class='field-label'>Éléments sélectionnés:</span> <span class='field-value'>" . $form_data['economicStudy'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>9. ÉTUDE FINANCIÈRE</h3>
            <div class='field'><span class='field-label'>Éléments sélectionnés:</span> <span class='field-value'>" . $form_data['financialStudy'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>10. IMPACT</h3>
            <div class='field'><span class='field-label'>Types d'impact:</span> <span class='field-value'>" . $form_data['impact'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>11. DÉLAI</h3>
            <div class='field'><span class='field-label'>Délai pour l'étude de faisabilité:</span> <span class='field-value'>" . $form_data['timeline'] . "</span></div>
            <div class='field'><span class='field-label'>Date de début:</span> <span class='field-value'>" . $form_data['startDate'] . "</span></div>
            <div class='field'><span class='field-label'>Date limite de livraison:</span> <span class='field-value'>" . $form_data['deliveryDate'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>12. RESSOURCES</h3>
            <div class='field'><span class='field-label'>Ressources nécessaires:</span> <span class='field-value'>" . $form_data['resources'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>13. PROFIL DU CONSULTANT</h3>
            <div class='field'><span class='field-label'>Profil du consultant nécessaire:</span> <span class='field-value'>" . $form_data['consultantProfile'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>14. EXPERTISE SUPPLÉMENTAIRE</h3>
            <div class='field'><span class='field-label'>Expertise supplémentaire requise:</span> <span class='field-value'>" . $form_data['expertise'] . "</span></div>
            <div class='field'><span class='field-label'>Domaine d'expertise supplémentaire:</span> <span class='field-value'>" . $form_data['expertiseArea'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>15. ENDOSSEMENTS</h3>
            <div class='field'><span class='field-label'>Besoin d'endossements:</span> <span class='field-value'>" . $form_data['endorsements'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>16. BUDGET</h3>
            <div class='field'><span class='field-label'>Budget du demandeur:</span> <span class='field-value'>" . $form_data['budget'] . "</span></div>
            <div class='field'><span class='field-label'>Financement du coût de l'étude:</span> <span class='field-value'>" . $form_data['budgetFinancing'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>17. RÉSULTATS</h3>
            <div class='field'><span class='field-label'>Présentation des résultats:</span> <span class='field-value'>" . $form_data['resultsPresentation'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>18. PROCHAINE ÉTAPE</h3>
            <div class='field'><span class='field-label'>Étapes suivantes si le projet est viable:</span> <span class='field-value'>" . $form_data['nextStepIfViable'] . "</span></div>
            <div class='field'><span class='field-label'>Étapes suivantes si le projet n'est pas viable:</span> <span class='field-value'>" . $form_data['nextStepIfNotViable'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>19. INFORMATIONS SUPPLÉMENTAIRES</h3>
            <div class='field'><span class='field-label'>Informations supplémentaires:</span> <span class='field-value'>" . $form_data['additionalInformation'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>20. APPROBATION DU DEMANDEUR</h3>
            <div class='field'><span class='field-label'>Nom complet du demandeur:</span> <span class='field-value'>" . $form_data['applicantNameApproval'] . "</span></div>
            <div class='field'><span class='field-label'>Date:</span> <span class='field-value'>" . $form_data['approvalDate'] . "</span></div>
    ";
    // Ajouter la signature au corps de l'email si disponible
    if (!empty($signature_url)) {
        $email_body .= "
            <div class='field'><span class='field-label'>Signature:</span> <span class='field-value'><br><img src='" . $signature_url . "' alt='Signature' style='max-width: 300px; border: 1px solid #ddd; padding: 5px; margin-top: 10px;'/><br><a href='" . $signature_url . "' class='file-link' target='_blank'>Voir la signature</a></span></div>
        ";
    }
    // Ajouter le fichier téléchargé au corps de l'email si disponible
    if ($file_uploaded && !empty($file_url)) {
        $email_body .= "
            <div class='field'><span class='field-label'>Fichier téléchargé:</span> <span class='field-value'>" . $file_name . "<br><a href='" . $file_url . "' class='file-link' target='_blank'>Télécharger le fichier</a></span></div>
        ";
    }
    // Fermer le corps de l'email
    $email_body .= "
        </div>
    </body>
    </html>
    ";
    // En-têtes de l'email
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $from_email . "\r\n";
    $headers .= "Reply-To: " . $form_data['email'] . "\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    // Envoyer l'email
    $mail_sent = mail($to_email, $email_subject, $email_body, $headers);
    // Préparer la réponse
    if ($mail_sent) {
        // Réponse de succès
        $response = array(
            'status' => 'success',
            'message' => 'Votre demande a été envoyée avec succès. Nous vous contacterons bientôt.',
            'signature_url' => $signature_url,
            'file_url' => $file_url
        );
    } else {
        // Réponse d'erreur
        $response = array(
            'status' => 'error',
            'message' => 'Une erreur s\'est produite lors de l\'envoi de votre demande. Veuillez réessayer plus tard.'
        );
    }
    // Retourner la réponse JSON
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // Méthode non autorisée
    header('HTTP/1.1 405 Method Not Allowed');
    $response = array(
        'status' => 'error',
        'message' => 'Méthode non autorisée'
    );
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
                    <!-- Feasibility Study Application Form -->
                     <form action="" method="POST" enctype="multipart/form-data">
                       <div class="row mb-5">
                        <div class="col-12">
                            <div class="card border-0 shadow-lg">
                                <div class="card-header bg-primary text-white text-center" style="background-color: #000 !important;">
                                    <h2 class="mb-0">Feasibility Study Application Form</h2>
                                    <p class="mb-0">Complete all sections to submit your application</p>
                                </div>
                                <div class="card-body p-0">
                                    <!-- Tabs Navigation -->
                                    <div class="tabs-container">
                                        <div class="tabs-nav" id="tabsNav">
										<div class="tab-item active" data-tab="0">Applicant Information</div>
										<div class="tab-item" data-tab="1">Company Current Situation</div>
										<div class="tab-item" data-tab="2">Project Information</div>
										<div class="tab-item" data-tab="3">Funding</div>
										<div class="tab-item" data-tab="4">Data</div>
										<div class="tab-item" data-tab="5">Methodology</div>
										<div class="tab-item" data-tab="6">Architectural Conception</div>
										<div class="tab-item" data-tab="7">Economic Study</div>
										<div class="tab-item" data-tab="8">Financial Study</div>
										<div class="tab-item" data-tab="9">Impact</div>
										<div class="tab-item" data-tab="10">Time Frame</div>
										<div class="tab-item" data-tab="11">Resources</div>
										<div class="tab-item" data-tab="12">Consultant's Profile</div>
										<div class="tab-item" data-tab="13">Additional Expertise</div>
										<div class="tab-item" data-tab="14">Endorsements</div>
										<div class="tab-item" data-tab="15">Budget</div>
										<div class="tab-item" data-tab="16">Results</div>
										<div class="tab-item" data-tab="17">Next Step</div>
										<div class="tab-item" data-tab="18">Additional Information</div>
										<div class="tab-item" data-tab="19">Applicant's Approval</div>
									</div>

                                        <!-- Tab Content -->
                                       <div class="tab-content-container">
                                    <!-- Tab 1: Applicant Information -->
                                    <div class="tab-content active" id="tab-0">
                                        <div class="tab-header">
                                            <h3>1. APPLICANT INFORMATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="applicantName">Applicant's Name(s):</label>
                                                        <input type="text" id="applicantName" name="applicantName" class="form-control" >
                                                        <div class="error-message" id="error-applicantName" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="applicantSurname">Applicant's Surname:</label>
                                                        <input type="text" id="applicantSurname" name="applicantSurname" class="form-control" >
                                                        <div class="error-message" id="error-applicantSurname" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="country">Country:</label>
                                                        <input type="text" id="country" name="country" class="form-control" >
                                                        <div class="error-message" id="error-country" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="city">City:</label>
                                                        <input type="text" id="city" name="city" class="form-control" >
                                                        <div class="error-message" id="error-city" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="street">Street:</label>
                                                        <input type="text" id="street" name="street" class="form-control" >
                                                        <div class="error-message" id="error-street" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="zip">Zip:</label>
                                                        <input type="text" id="zip" name="zip" class="form-control" >
                                                        <div class="error-message" id="error-zip" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="phoneNumber">Phone Number(s):</label>
                                                        <input type="tel" id="phoneNumber" name="phoneNumber" class="form-control" >
                                                        <div class="error-message" id="error-phoneNumber" style="display: none;">This field is </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="email">Email Address:</label>
                                                        <input type="email" id="email" name="email" class="form-control" >
                                                        <div class="error-message" id="error-email" style="display: none;">Please enter a valid email address</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 2: Company Current Situation -->
                                    <div class="tab-content" id="tab-1">
                                        <div class="tab-header">
                                            <h3>2. COMPANY CURRENT SITUATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="currentState">What is the company's current state of affairs?</label>
                                                <textarea id="currentState" name="currentState" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-currentState" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="businessChallenges">What business challenges is the applicant facing?</label>
                                                <textarea id="businessChallenges" name="businessChallenges" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-businessChallenges" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="businessOpportunities">What business opportunities is the applicant viewing?</label>
                                                <textarea id="businessOpportunities" name="businessOpportunities" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-businessOpportunities" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Specify the company's role in the project:</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="owner" name="role[]" value="Owner" class="form-check-input">
                                                        <label class="form-check-label" for="owner">Owner</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="subcontractor" name="role[]" value="Subcontractor" class="form-check-input">
                                                        <label class="form-check-label" for="subcontractor">Subcontractor</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-role" style="display: none;">Please select at least one option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 3: Project Information -->
                                    <div class="tab-content" id="tab-2">
                                        <div class="tab-header">
                                            <h3>3. PROJECT INFORMATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="projectPurpose">What is the purpose of the feasibility study?</label>
                                                <textarea id="projectPurpose" name="projectPurpose" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-projectPurpose" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="projectGoals">What are the applicant's goals and objectives?</label>
                                                <textarea id="projectGoals" name="projectGoals" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-projectGoals" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Is the applicant the owner of the project?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="projectOwnerYes" name="projectOwner" value="Yes" class="form-check-input" >
                                                        <label class="form-check-label" for="projectOwnerYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="projectOwnerNo" name="projectOwner" value="No" class="form-check-input" >
                                                        <label class="form-check-label" for="projectOwnerNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-projectOwner" style="display: none;">Please select an option</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="role">If the applicant is not the owner, what is their role?</label>
                                                <textarea id="role" name="role" class="form-control" rows="3"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="projectLocation">Please specify the location(s) of the project:</label>
                                                <input type="text" id="projectLocation" name="projectLocation" class="form-control" >
                                                <div class="error-message" id="error-projectLocation" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Is the applicant the owner of the land where the project will be located?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="landOwnerYes" name="landOwner" value="Yes" class="form-check-input" >
                                                        <label class="form-check-label" for="landOwnerYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="landOwnerNo" name="landOwner" value="No" class="form-check-input" >
                                                        <label class="form-check-label" for="landOwnerNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-landOwner" style="display: none;">Please select an option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 4: Funding -->
                                    <div class="tab-content" id="tab-3">
                                        <div class="tab-header">
                                            <h3>4. FUNDING</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="fundingSource">Please specify the origin of the funding:</label>
                                                <input type="text" id="fundingSource" name="fundingSource" class="form-control" >
                                                <div class="error-message" id="error-fundingSource" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Loan:</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="loan" name="fundingType" value="Loan" class="form-check-input">
                                                        <label class="form-check-label" for="loan">Loan</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="loanDetails">Please specify the amount and terms (if applicable):</label>
                                                <textarea id="loanDetails" name="loanDetails" class="form-control" rows="4"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 5: Data -->
                                    <div class="tab-content" id="tab-4">
                                        <div class="tab-header">
                                            <h3>5. DATA</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="dataCollection">What data will be collected and analyzed?</label>
                                                <textarea id="dataCollection" name="dataCollection" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-dataCollection" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label>What type of data will be needed for the feasibility study?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="quantitative" name="dataType[]" value="Quantitative" class="form-check-input">
                                                        <label class="form-check-label" for="quantitative">Quantitative</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="qualitative" name="dataType[]" value="Qualitative" class="form-check-input">
                                                        <label class="form-check-label" for="qualitative">Qualitative</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-dataType" style="display: none;">Please select at least one option</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Will the applicant provide data, or will it need to be collected by GIFAM's team?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="applicantData" name="dataSource[]" value="The applicant" class="form-check-input">
                                                        <label class="form-check-label" for="applicantData">The applicant</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="gifamTeamData" name="dataSource[]" value="GIFAM's team" class="form-check-input">
                                                        <label class="form-check-label" for="gifamTeamData">GIFAM's team</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-dataSource" style="display: none;">Please select at least one option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 6: Methodology -->
                                    <div class="tab-content" id="tab-5">
                                        <div class="tab-header">
                                            <h3>6. METHODOLOGY</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="methodology">How will the feasibility study be conducted?</label>
                                                <textarea id="methodology" name="methodology" class="form-control" rows="6" ></textarea>
                                                <div class="error-message" id="error-methodology" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 7: Architectural Conception -->
                                    <div class="tab-content" id="tab-6">
                                        <div class="tab-header">
                                            <h3>7. ARCHITECTURAL CONCEPTION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="architecturalAnalysis" name="architecturalConception[]" value="Architectural Technical Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="architecturalAnalysis">Architectural Technical Analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="architecturalPlans" name="architecturalConception[]" value="Architectural Plans" class="form-check-input">
                                                    <label class="form-check-label" for="architecturalPlans">Architectural Plans</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="elevationSections" name="architecturalConception[]" value="Elevation and Sections" class="form-check-input">
                                                    <label class="form-check-label" for="elevationSections">Elevation and Sections</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="groundPlan" name="architecturalConception[]" value="Ground Plan" class="form-check-input">
                                                    <label class="form-check-label" for="groundPlan">Ground Plan</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="sketchUp" name="architecturalConception[]" value="Sketch up" class="form-check-input">
                                                    <label class="form-check-label" for="sketchUp">Sketch up</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="3dModeling" name="architecturalConception[]" value="3D modeling" class="form-check-input">
                                                    <label class="form-check-label" for="3dModeling">3D modeling</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="3dVideo" name="architecturalConception[]" value="3D Video" class="form-check-input">
                                                    <label class="form-check-label" for="3dVideo">3D Video</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="rendering" name="architecturalConception[]" value="Rendering" class="form-check-input">
                                                    <label class="form-check-label" for="rendering">Rendering</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 8: Economic Study -->
                                    <div class="tab-content" id="tab-7">
                                        <div class="tab-header">
                                            <h3>8. ECONOMIC STUDY</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="marketStudy" name="economicStudy[]" value="Market Study" class="form-check-input">
                                                    <label class="form-check-label" for="marketStudy">Market Study</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="industryInsight" name="economicStudy[]" value="Industry Insight" class="form-check-input">
                                                    <label class="form-check-label" for="industryInsight">Industry Insight</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="demandAnalysis" name="economicStudy[]" value="Demand analysis" class="form-check-input">
                                                    <label class="form-check-label" for="demandAnalysis">Demand analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="supplyAnalysis" name="economicStudy[]" value="Supply-side analysis" class="form-check-input">
                                                    <label class="form-check-label" for="supplyAnalysis">Supply-side analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="competitiveAnalysis" name="economicStudy[]" value="Competitive analysis" class="form-check-input">
                                                    <label class="form-check-label" for="competitiveAnalysis">Competitive analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="pestleAnalysis" name="economicStudy[]" value="PESTLE Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="pestleAnalysis">PESTLE Analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="swotAnalysis" name="economicStudy[]" value="SWOT Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="swotAnalysis">SWOT Analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="marketingStrategy" name="economicStudy[]" value="Marketing Strategy" class="form-check-input">
                                                    <label class="form-check-label" for="marketingStrategy">Marketing Strategy</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="operationalFeasibility" name="economicStudy[]" value="Operational feasibility" class="form-check-input">
                                                    <label class="form-check-label" for="operationalFeasibility">Operational feasibility</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="organizationalAnalysis" name="economicStudy[]" value="Organizational Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="organizationalAnalysis">Organizational Analysis</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 9: Financial Study -->
                                    <div class="tab-content" id="tab-8">
                                        <div class="tab-header">
                                            <h3>9. FINANCIAL STUDY</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="financialOverview" name="financialStudy[]" value="Financial Overview" class="form-check-input">
                                                    <label class="form-check-label" for="financialOverview">Financial Overview</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="loanAmortizationTable" name="financialStudy[]" value="Loan Amortization Table" class="form-check-input">
                                                    <label class="form-check-label" for="loanAmortizationTable">Loan Amortization Table</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="capexOpexFunding" name="financialStudy[]" value="Capex & Opex funding" class="form-check-input">
                                                    <label class="form-check-label" for="capexOpexFunding">Capex & Opex funding</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="fundingPeriods" name="financialStudy[]" value="Funding Periods" class="form-check-input">
                                                    <label class="form-check-label" for="fundingPeriods">Funding Periods</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="investmentPlan" name="financialStudy[]" value="Investment Plan" class="form-check-input">
                                                    <label class="form-check-label" for="investmentPlan">Investment Plan</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="fixedAssetsDepreciation" name="financialStudy[]" value="Fixed Assets Depreciation Table" class="form-check-input">
                                                    <label class="form-check-label" for="fixedAssetsDepreciation">Fixed Assets Depreciation Table</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="operatingExpensesForecasting" name="financialStudy[]" value="Operating Expenses Forecasting" class="form-check-input">
                                                    <label class="form-check-label" for="operatingExpensesForecasting">Operating Expenses Forecasting</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="salesForecasting" name="financialStudy[]" value="Sales Forecasting" class="form-check-input">
                                                    <label class="form-check-label" for="salesForecasting">Sales Forecasting</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="incomeStatement" name="financialStudy[]" value="Income Statement" class="form-check-input">
                                                    <label class="form-check-label" for="incomeStatement">Income Statement</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="balanceSheet" name="financialStudy[]" value="Balance Sheet" class="form-check-input">
                                                    <label class="form-check-label" for="balanceSheet">Balance Sheet</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="cashFlowStatement" name="financialStudy[]" value="Cash-Flow Statement" class="form-check-input">
                                                    <label class="form-check-label" for="cashFlowStatement">Cash-Flow Statement</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="financialRatios" name="financialStudy[]" value="Financial Ratios Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="financialRatios">Financial Ratios Analysis</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 10: Impact -->
                                    <div class="tab-content" id="tab-9">
                                        <div class="tab-header">
                                            <h3>10. IMPACT</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="economicImpact" name="impact[]" value="Economic impact" class="form-check-input">
                                                    <label class="form-check-label" for="economicImpact">Economic impact (e.g., job creation, GDP growth)</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="socialImpact" name="impact[]" value="Social impact" class="form-check-input">
                                                    <label class="form-check-label" for="socialImpact">Social impact (e.g., education, healthcare)</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="environmentalImpact" name="impact[]" value="Environmental impact" class="form-check-input">
                                                    <label class="form-check-label" for="environmentalImpact">Environmental impact (e.g., sustainability, carbon footprint)</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 11: Time Frame -->
                                    <div class="tab-content" id="tab-10">
                                        <div class="tab-header">
                                            <h3>11. TIME FRAME</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="timeline">What is the timeline for the feasibility study?</label>
                                                <input type="text" id="timeline" name="timeline" class="form-control" >
                                                <div class="error-message" id="error-timeline" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="startDate">When will it begin?</label>
                                                <input type="date" id="startDate" name="startDate" class="form-control" >
                                                <div class="error-message" id="error-startDate" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="deliveryDate">What is the deadline for delivery?</label>
                                                <input type="date" id="deliveryDate" name="deliveryDate" class="form-control" >
                                                <div class="error-message" id="error-deliveryDate" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 12: Resources -->
                                    <div class="tab-content" id="tab-11">
                                        <div class="tab-header">
                                            <h3>12. RESOURCES</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label>Which resources will be needed for the study?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="gifamTeam" name="resources[]" value="GIFAM's Team" class="form-check-input">
                                                        <label class="form-check-label" for="gifamTeam">GIFAM's Team</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="thirdParty" name="resources[]" value="Third Party" class="form-check-input">
                                                        <label class="form-check-label" for="thirdParty">Third Party</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-resources" style="display: none;">Please select at least one option</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Will additional staff or consultants be ?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalStaffYes" name="additionalStaff" value="Yes" class="form-check-input" >
                                                        <label class="form-check-label" for="additionalStaffYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalStaffNo" name="additionalStaff" value="No" class="form-check-input" >
                                                        <label class="form-check-label" for="additionalStaffNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-additionalStaff" style="display: none;">Please select an option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 13: Consultant's Profile -->
                                    <div class="tab-content" id="tab-12">
                                        <div class="tab-header">
                                            <h3>13. CONSULTANT'S PROFILE</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="consultantProfile">Please select the consultant's profile needed for conducting the feasibility study:</label>
                                                <input type="text" id="consultantProfile" name="consultantProfile" class="form-control" >
                                                <div class="error-message" id="error-consultantProfile" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 14: Additional Expertise -->
                                    <div class="tab-content" id="tab-13">
                                        <div class="tab-header">
                                            <h3>14. ADDITIONAL EXPERTISE</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label>Please specify if any additional expertise shall be  for the project.</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalExpertiseYes" name="additionalExpertise" value="Yes" class="form-check-input" >
                                                        <label class="form-check-label" for="additionalExpertiseYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalExpertiseNo" name="additionalExpertise" value="No" class="form-check-input" >
                                                        <label class="form-check-label" for="additionalExpertiseNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-additionalExpertise" style="display: none;">Please select an option</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="expertiseArea">If yes, please indicate the area for which additional expertise would be :</label>
                                                <input type="text" id="expertiseArea" name="expertiseArea" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 15: Endorsements -->
                                    <div class="tab-content" id="tab-14">
                                        <div class="tab-header">
                                            <h3>15. ENDORSEMENTS</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label>Does the feasibility study need endorsements from a certified expert corporation?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="endorsementsYes" name="endorsements" value="Yes" class="form-check-input" >
                                                        <label class="form-check-label" for="endorsementsYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="endorsementsNo" name="endorsements" value="No" class="form-check-input" >
                                                        <label class="form-check-label" for="endorsementsNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-endorsements" style="display: none;">Please select an option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 16: Budget -->
                                    <div class="tab-content" id="tab-15">
                                        <div class="tab-header">
                                            <h3>16. BUDGET</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="budget">What is the applicant's budget for the feasibility study?</label>
                                                <input type="text" id="budget" name="budget" class="form-control" >
                                                <div class="error-message" id="error-budget" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="budgetFinancing">How will the feasibility study cost be financed?</label>
                                                <input type="text" id="budgetFinancing" name="budgetFinancing" class="form-control" >
                                                <div class="error-message" id="error-budgetFinancing" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 17: Results -->
                                    <div class="tab-content" id="tab-16">
                                        <div class="tab-header">
                                            <h3>17. RESULTS</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="resultsPresentation">How will the results of the feasibility study be presented?</label>
                                                <input type="text" id="resultsPresentation" name="resultsPresentation" class="form-control" >
                                                <div class="error-message" id="error-resultsPresentation" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 18: Next Step -->
                                    <div class="tab-content" id="tab-17">
                                        <div class="tab-header">
                                            <h3>18. NEXT STEP</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="nextStepIfViable">If the feasibility study indicates the project is viable, what will be the next steps?</label>
                                                <textarea id="nextStepIfViable" name="nextStepIfViable" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-nextStepIfViable" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="nextStepIfNotViable">If the feasibility study indicates the project is not viable, what will be the next steps?</label>
                                                <textarea id="nextStepIfNotViable" name="nextStepIfNotViable" class="form-control" rows="4" ></textarea>
                                                <div class="error-message" id="error-nextStepIfNotViable" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 19: Additional Information -->
                                    <div class="tab-content" id="tab-18">
                                        <div class="tab-header">
                                            <h3>19. ADDITIONAL INFORMATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="additionalInformation">Please provide any additional information relevant to your project:</label>
                                                <textarea id="additionalInformation" name="additionalInformation" class="form-control" rows="6"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 20: Applicant's Approval -->
                                    <div class="tab-content" id="tab-19">
                                        <div class="tab-header">
                                            <h3>20. APPLICANT'S APPROVAL</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="applicantNameApproval">Applicant's full name:</label>
                                                <input type="text" id="applicantNameApproval" name="applicantNameApproval" class="form-control" >
                                                <div class="error-message" id="error-applicantNameApproval" style="display: none;">This field is </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="Uploadyourproject">Upload your project:</label>
                                                <label class="custom-file-upload">
                                                    <input type="file" id="Uploadyourproject" name="Uploadyourproject" class="hidden-input" onchange="updateFileName(this)">
                                                    📁 Upload your project
                                                </label>
                                                <span class="file-name" id="file-name">No file selected</span>
                                            </div>
                                            <div class="form-group">
                                                <label for="signature">Signature:</label>
                                                <div id="signature-pad" class="mb-2" style="border:1px solid #ccc; border-radius:4px;">
                                                    <canvas id="signature-canvas" width="400" height="150" style="background:#fff;"></canvas>
                                                </div>
                                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="clearSignature()">Clear</button>
                                                <input type="hidden" name="signature_data" id="signature_data">
                                                <div class="error-message" id="error-signature" style="display: none;">Please provide your signature</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="approvalDate">Date:</label>
                                                <input type="date" id="approvalDate" name="approvalDate" class="form-control" >
                                                <div class="error-message" id="error-approvalDate" style="display: none;">This field is </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                        <!-- Navigation Buttons -->
                                        <div class="tab-navigation">
                                            <button type="button" class="btn btn-secondary" id="prevBtn" onclick="previousTab()">Previous</button>
                                            <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextTab()">Next</button>
                                            <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">Submit Application</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>

                    <!-- Investment Types -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['types_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . htmlspecialchars($page_data['type_1_image']); ?>" alt="<?php echo htmlspecialchars($page_data['type_1_title']); ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo htmlspecialchars($page_data['type_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['type_1_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . htmlspecialchars($page_data['type_2_image']); ?>" alt="<?php echo htmlspecialchars($page_data['type_2_title']); ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo htmlspecialchars($page_data['type_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['type_2_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . htmlspecialchars($page_data['type_3_image']); ?>" alt="<?php echo htmlspecialchars($page_data['type_3_title']); ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo htmlspecialchars($page_data['type_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['type_3_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . htmlspecialchars($page_data['type_4_image']); ?>" alt="<?php echo htmlspecialchars($page_data['type_4_title']); ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo htmlspecialchars($page_data['type_4_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['type_4_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Investment Process -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['process_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="process-timeline">
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">1</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_1_description']); ?></p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">2</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_2_description']); ?></p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">3</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_3_description']); ?></p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">4</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_4_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_4_description']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-6.jpg" alt="Investment Process" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Performance Metrics -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['metrics_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-primary"><?php echo htmlspecialchars($page_data['metric_1_number']); ?></h4>
                                    <p><?php echo htmlspecialchars($page_data['metric_1_label']); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-success"><?php echo htmlspecialchars($page_data['metric_2_number']); ?></h4>
                                    <p><?php echo htmlspecialchars($page_data['metric_2_label']); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-info"><?php echo htmlspecialchars($page_data['metric_3_number']); ?></h4>
                                    <p><?php echo htmlspecialchars($page_data['metric_3_label']); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-warning"><?php echo htmlspecialchars($page_data['metric_4_number']); ?></h4>
                                    <p><?php echo htmlspecialchars($page_data['metric_4_label']); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Benefits Section -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-7.jpg" alt="Investment Benefits" class="img-fluid rounded shadow">
                        </div>
                        <div class="col-lg-6">
                            <h3><?php echo htmlspecialchars($page_data['advantages_title']); ?></h3>
                            <p><?php echo htmlspecialchars($page_data['advantages_intro']); ?></p>
                            <div class="feature-list">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['advantage_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['advantage_1_description']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['advantage_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['advantage_2_description']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['advantage_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['advantage_3_description']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['advantage_4_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['advantage_4_description']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Investment Strategies -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['strategies_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="bg-light p-4 rounded h-100">
                                <h4><i class="icofont-chart-flow text-primary me-2"></i><?php echo htmlspecialchars($page_data['strategy_1_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['strategy_1_description']); ?></p>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="bg-light p-4 rounded h-100">
                                <h4><i class="icofont-shield-check text-success me-2"></i><?php echo htmlspecialchars($page_data['strategy_2_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['strategy_2_description']); ?></p>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="bg-light p-4 rounded h-100">
                                <h4><i class="icofont-balance text-warning me-2"></i><?php echo htmlspecialchars($page_data['strategy_3_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['strategy_3_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3><?php echo htmlspecialchars($page_data['cta_title']); ?></h3>
                                <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                                <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn btn-primary btn-lg me-3"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
                                <a href="<?php echo $url; ?>our-services/" class="btn btn-outline-primary btn-lg">View All Services</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

<!-- Tabs JavaScript -->
<script>
    // Variables globales
    let currentTab = 0;
    const totalTabs = 20;
    
    // Initialisation
    document.addEventListener('DOMContentLoaded', function() {
        initializeTabs();
        updateNavigationButtons();
    });
    
    // Initialisation des tabs
    function initializeTabs() {
        // Ajouter les événements click aux tabs
        const tabItems = document.querySelectorAll('.tab-item');
        tabItems.forEach((item, index) => {
            item.addEventListener('click', () => {
                showTab(index);
            });
        });
        
        // Ajouter les événements aux boutons de navigation
        document.getElementById('prevBtn').addEventListener('click', previousTab);
        document.getElementById('nextBtn').addEventListener('click', nextTab);
        document.getElementById('submitBtn').addEventListener('click', submitForm);
        
        // Ajouter la navigation par clavier
        document.addEventListener('keydown', handleKeyboardNavigation);
    }
    
    // Afficher un tab spécifique
    function showTab(tabIndex) {
        // Masquer tous les tabs
        const tabContents = document.querySelectorAll('.tab-content');
        const tabItems = document.querySelectorAll('.tab-item');
        
        tabContents.forEach(content => {
            content.classList.remove('active');
        });
        
        tabItems.forEach(item => {
            item.classList.remove('active');
        });
        
        // Afficher le tab sélectionné
        if (tabContents[tabIndex]) {
            tabContents[tabIndex].classList.add('active');
        }
        
        if (tabItems[tabIndex]) {
            tabItems[tabIndex].classList.add('active');
        }
        
        currentTab = tabIndex;
        updateNavigationButtons();
        scrollToActiveTab();
    }
    
    // Tab précédent
    function previousTab() {
        if (currentTab > 0) {
            showTab(currentTab - 1);
        }
    }
    
    // Tab suivant
    function nextTab() {
        if (currentTab < totalTabs - 1) {
            showTab(currentTab + 1);
        }
    }
    
    // Mettre à jour les boutons de navigation
    function updateNavigationButtons() {
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');
        const submitBtn = document.getElementById('submitBtn');
        
        // Bouton Previous
        if (currentTab === 0) {
            prevBtn.style.display = 'none';
        } else {
            prevBtn.style.display = 'inline-block';
        }
        
        // Bouton Next/Submit
        if (currentTab === totalTabs - 1) {
            nextBtn.style.display = 'none';
            submitBtn.style.display = 'inline-block';
        } else {
            nextBtn.style.display = 'inline-block';
            submitBtn.style.display = 'none';
        }
        
        // Mettre à jour le texte du bouton Next
        if (currentTab === totalTabs - 2) {
            nextBtn.textContent = 'Final Step';
        } else {
            nextBtn.textContent = 'Next';
        }
    }
    
    // Faire défiler vers le tab actif
    function scrollToActiveTab() {
        const activeTab = document.querySelector('.tab-item.active');
        if (activeTab) {
            const tabsNav = document.getElementById('tabsNav');
            const navRect = tabsNav.getBoundingClientRect();
            const tabRect = activeTab.getBoundingClientRect();
            
            if (tabRect.left < navRect.left || tabRect.right > navRect.right) {
                activeTab.scrollIntoView({
                    behavior: 'smooth',
                    block: 'nearest',
                    inline: 'center'
                });
            }
        }
    }
    
    // Navigation par clavier
    function handleKeyboardNavigation(e) {
        if (e.key === 'ArrowLeft' && currentTab > 0) {
            e.preventDefault();
            previousTab();
        } else if (e.key === 'ArrowRight' && currentTab < totalTabs - 1) {
            e.preventDefault();
            nextTab();
        } else if (e.key === 'Enter' && currentTab === totalTabs - 1) {
            e.preventDefault();
            submitForm();
        }
    }
    
    // Soumettre le formulaire
    function submitForm() {
        // Validation des champs requis
        const Fields = document.querySelectorAll('input[], textarea[]');
        let isValid = true;
        
        Fields.forEach(field => {
            if (!field.value.trim()) {
                field.classList.add('is-invalid');
                isValid = false;
            } else {
                field.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            alert('Please fill in all  fields before submitting.');
            return;
        }
        
        // Collecter les données du formulaire
        const formData = new FormData();
        const formElements = document.querySelectorAll('input, textarea, select');
        
        formElements.forEach(element => {
            if (element.type === 'checkbox') {
                if (element.checked) {
                    formData.append(element.name, element.value || 'checked');
                }
            } else {
                formData.append(element.name, element.value);
            }
        });
        
        // Simulation de soumission (remplacer par votre logique de soumission)
        console.log('Form data collected:', Object.fromEntries(formData));
        
        // Afficher un message de succès
        showSuccessMessage();
        // header('Location: merci.php'); // ou affiche un message de succès
        exit;
    }
    
    // Afficher le message de succès
    function showSuccessMessage() {
        const container = document.querySelector('.tabs-container');
        const successMessage = document.createElement('div');
        successMessage.className = 'alert alert-success text-center';
        successMessage.innerHTML = `
            <h4><i class="icofont-check-circled"></i> Application Submitted Successfully!</h4>
            <p>Thank you for your application. We will review your information and contact you within 2-3 business days.</p>
            <button class="btn btn-primary" onclick="location.reload()">Submit Another Application</button>
        `;
        
        container.innerHTML = '';
        container.appendChild(successMessage);
    }
    
    // Validation en temps réel
    function validateField(field) {
        const value = field.value.trim();
        const isValid = value.length > 0;
        
        if (isValid) {
            field.classList.remove('is-invalid');
            field.classList.add('is-valid');
        } else {
            field.classList.remove('is-valid');
            field.classList.add('is-invalid');
        }
        
        return isValid;
    }
    
    // Ajouter la validation en temps réel
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('input, textarea');
        inputs.forEach(input => {
            input.addEventListener('blur', () => validateField(input));
            input.addEventListener('input', () => {
                if (input.classList.contains('is-invalid')) {
                    validateField(input);
                }
            });
        });
    });
    
    // Auto-sauvegarde des données
    function saveFormData() {
        const formData = {};
        const formElements = document.querySelectorAll('input, textarea, select');
        
        formElements.forEach(element => {
            if (element.type === 'checkbox') {
                formData[element.name] = element.checked;
            } else {
                formData[element.name] = element.value;
            }
        });
        
        localStorage.setItem('feasibilityFormData', JSON.stringify(formData));
    }
    
    // Restaurer les données sauvegardées
    function loadFormData() {
        const savedData = localStorage.getItem('feasibilityFormData');
        if (savedData) {
            const formData = JSON.parse(savedData);
            const formElements = document.querySelectorAll('input, textarea, select');
            
            formElements.forEach(element => {
                if (formData[element.name] !== undefined) {
                    if (element.type === 'checkbox') {
                        element.checked = formData[element.name];
                    } else {
                        element.value = formData[element.name];
                    }
                }
            });
        }
    }
    
    // Auto-sauvegarde toutes les 5 secondes
    setInterval(saveFormData, 5000);
    
    // Charger les données au démarrage
    document.addEventListener('DOMContentLoaded', loadFormData);
</script>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.1.6/dist/signature_pad.umd.min.js"></script>
<script>
var canvas = document.getElementById('signature-canvas');
var signaturePad = new SignaturePad(canvas);
function clearSignature() {
    signaturePad.clear();
}
document.querySelector('form').addEventListener('submit', function(e) {
    if (!signaturePad.isEmpty()) {
        document.getElementById('signature_data').value = signaturePad.toDataURL('image/png');
    } else {
        document.getElementById('signature_data').value = '';
    }
});
</script>

</body>
</html>