<?php
// process_form.php
// Configuration
$to_email = "info@gifam.eu"; // Changez ceci par votre adresse email
$from_email = "info@gifam.eu"; // Email d'expéditeur
$email_subject = "Nouvelle demande d'étude de faisabilité";

// Dossier pour les uploads
$upload_dir = 'uploads/';
$base_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['SCRIPT_NAME']);
$base_url = rtrim($base_url, '/');

// Créer le répertoire de téléchargement s'il n'existe pas
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Vérifier que la méthode est POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Fonction pour nettoyer les données
    function clean_data($data) {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars($data);
        return $data;
    }
    
    // Collecter toutes les données du formulaire
    $form_data = array();
    
    // Section 1: Informations du demandeur
    $form_data['applicantName'] = isset($_POST['applicantName']) ? clean_data($_POST['applicantName']) : '';
    $form_data['applicantSurname'] = isset($_POST['applicantSurname']) ? clean_data($_POST['applicantSurname']) : '';
    $form_data['country'] = isset($_POST['country']) ? clean_data($_POST['country']) : '';
    $form_data['city'] = isset($_POST['city']) ? clean_data($_POST['city']) : '';
    $form_data['street'] = isset($_POST['street']) ? clean_data($_POST['street']) : '';
    $form_data['zip'] = isset($_POST['zip']) ? clean_data($_POST['zip']) : '';
    $form_data['phoneNumber'] = isset($_POST['phoneNumber']) ? clean_data($_POST['phoneNumber']) : '';
    $form_data['email'] = isset($_POST['email']) ? clean_data($_POST['email']) : '';
    
    // Section 2: Situation actuelle de l'entreprise
    $form_data['currentState'] = isset($_POST['currentState']) ? clean_data($_POST['currentState']) : '';
    $form_data['businessChallenges'] = isset($_POST['businessChallenges']) ? clean_data($_POST['businessChallenges']) : '';
    $form_data['businessOpportunities'] = isset($_POST['businessOpportunities']) ? clean_data($_POST['businessOpportunities']) : '';
    
    // Gérer les cases à cocher multiples
    $form_data['role'] = isset($_POST['role']) ? (is_array($_POST['role']) ? implode(', ', $_POST['role']) : $_POST['role']) : '';
    
    // Section 3: Informations sur le projet
    $form_data['projectPurpose'] = isset($_POST['projectPurpose']) ? clean_data($_POST['projectPurpose']) : '';
    $form_data['projectGoals'] = isset($_POST['projectGoals']) ? clean_data($_POST['projectGoals']) : '';
    $form_data['projectOwner'] = isset($_POST['projectOwner']) ? (is_array($_POST['projectOwner']) ? implode(', ', $_POST['projectOwner']) : $_POST['projectOwner']) : '';
    $form_data['role_project'] = isset($_POST['role_project']) ? clean_data($_POST['role_project']) : '';
    $form_data['projectLocation'] = isset($_POST['projectLocation']) ? clean_data($_POST['projectLocation']) : '';
    $form_data['landOwner'] = isset($_POST['landOwner']) ? (is_array($_POST['landOwner']) ? implode(', ', $_POST['landOwner']) : $_POST['landOwner']) : '';
    
    // Section 4: Financement
    $form_data['fundingSource'] = isset($_POST['fundingSource']) ? clean_data($_POST['fundingSource']) : '';
    $form_data['fundingType'] = isset($_POST['fundingType']) ? 'Oui' : 'Non';
    $form_data['loanDetails'] = isset($_POST['loanDetails']) ? clean_data($_POST['loanDetails']) : '';
    
    // Section 5: Données
    $form_data['dataCollection'] = isset($_POST['dataCollection']) ? clean_data($_POST['dataCollection']) : '';
    $form_data['dataType'] = isset($_POST['dataType']) ? (is_array($_POST['dataType']) ? implode(', ', $_POST['dataType']) : $_POST['dataType']) : '';
    $form_data['dataSource'] = isset($_POST['dataSource']) ? (is_array($_POST['dataSource']) ? implode(', ', $_POST['dataSource']) : $_POST['dataSource']) : '';
    
    // Section 6: Méthodologie
    $form_data['methodology'] = isset($_POST['methodology']) ? clean_data($_POST['methodology']) : '';
    
    // Sections 7-10: Études et conceptions
    $architecturalConception = isset($_POST['architecturalConception']) ? (is_array($_POST['architecturalConception']) ? $_POST['architecturalConception'] : [$_POST['architecturalConception']]) : array();
    $economicStudy = isset($_POST['economicStudy']) ? (is_array($_POST['economicStudy']) ? $_POST['economicStudy'] : [$_POST['economicStudy']]) : array();
    $financialStudy = isset($_POST['financialStudy']) ? (is_array($_POST['financialStudy']) ? $_POST['financialStudy'] : [$_POST['financialStudy']]) : array();
    $impact = isset($_POST['impact']) ? (is_array($_POST['impact']) ? $_POST['impact'] : [$_POST['impact']]) : array();
    
    $form_data['architecturalConception'] = !empty($architecturalConception) ? implode(', ', $architecturalConception) : '';
    $form_data['economicStudy'] = !empty($economicStudy) ? implode(', ', $economicStudy) : '';
    $form_data['financialStudy'] = !empty($financialStudy) ? implode(', ', $financialStudy) : '';
    $form_data['impact'] = !empty($impact) ? implode(', ', $impact) : '';
    
    // Section 11: Délai
    $form_data['timeline'] = isset($_POST['timeline']) ? clean_data($_POST['timeline']) : '';
    $form_data['startDate'] = isset($_POST['startDate']) ? clean_data($_POST['startDate']) : '';
    $form_data['deliveryDate'] = isset($_POST['deliveryDate']) ? clean_data($_POST['deliveryDate']) : '';
    
    // Section 12: Ressources
    $resources = isset($_POST['resources']) ? (is_array($_POST['resources']) ? $_POST['resources'] : [$_POST['resources']]) : array();
    $form_data['resources'] = !empty($resources) ? implode(', ', $resources) : '';
    
    // Section 13: Profil du consultant
    $form_data['consultantProfile'] = isset($_POST['consultantProfile']) ? clean_data($_POST['consultantProfile']) : '';
    
    // Section 14: Expertise supplémentaire
    $form_data['additionalExpertise'] = isset($_POST['additionalExpertise']) ? (is_array($_POST['additionalExpertise']) ? implode(', ', $_POST['additionalExpertise']) : $_POST['additionalExpertise']) : '';
    $form_data['expertiseArea'] = isset($_POST['expertiseArea']) ? clean_data($_POST['expertiseArea']) : '';
    
    // Section 15: Endossements
    $form_data['endorsements'] = isset($_POST['endorsements']) ? (is_array($_POST['endorsements']) ? implode(', ', $_POST['endorsements']) : $_POST['endorsements']) : '';
    
    // Section 16: Budget
    $form_data['budget'] = isset($_POST['budget']) ? clean_data($_POST['budget']) : '';
    $form_data['budgetFinancing'] = isset($_POST['budgetFinancing']) ? clean_data($_POST['budgetFinancing']) : '';
    
    // Section 17: Résultats
    $form_data['resultsPresentation'] = isset($_POST['resultsPresentation']) ? clean_data($_POST['resultsPresentation']) : '';
    
    // Section 18: Prochaine étape
    $form_data['nextStepIfViable'] = isset($_POST['nextStepIfViable']) ? clean_data($_POST['nextStepIfViable']) : '';
    $form_data['nextStepIfNotViable'] = isset($_POST['nextStepIfNotViable']) ? clean_data($_POST['nextStepIfNotViable']) : '';
    
    // Section 19: Informations supplémentaires
    $form_data['additionalInformation'] = isset($_POST['additionalInformation']) ? clean_data($_POST['additionalInformation']) : '';
    
    // Section 20: Approbation du demandeur
    $form_data['applicantNameApproval'] = isset($_POST['applicantNameApproval']) ? clean_data($_POST['applicantNameApproval']) : '';
    $form_data['approvalDate'] = isset($_POST['approvalDate']) ? clean_data($_POST['approvalDate']) : '';
    
    // Initialiser les variables pour les fichiers
    $signature_url = '';
    $file_url = '';
    $file_name = '';
    
    // Gérer la signature
    $signature_data = isset($_POST['signature_data']) ? $_POST['signature_data'] : '';
    if (!empty($signature_data) && preg_match('/^data:image\/(\w+);base64,/', $signature_data, $type)) {
        $data = substr($signature_data, strpos($signature_data, ',') + 1);
        $type = strtolower($type[1]); // jpg, png, gif
        if (in_array($type, array('jpg', 'jpeg', 'gif', 'png'))) {
            $data = base64_decode($data);
            if ($data !== false) {
                $signature_file_name = 'signature_' . uniqid() . '.' . $type;
                $signature_file_path = $upload_dir . $signature_file_name;
                if (file_put_contents($signature_file_path, $data)) {
                    $signature_url = $base_url . '/' . $signature_file_path;
                }
            }
        }
    }
    
    // Gérer le téléchargement de fichier
    $file_uploaded = false;
    if (isset($_FILES['Uploadyourproject']) && $_FILES['Uploadyourproject']['error'] == 0) {
        $file_name = $_FILES['Uploadyourproject']['name'];
        $file_tmp = $_FILES['Uploadyourproject']['tmp_name'];
        $file_size = $_FILES['Uploadyourproject']['size'];
        $file_type = $_FILES['Uploadyourproject']['type'];
        
        // Générer un nom de fichier unique
        $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
        $new_file_name = 'project_' . uniqid() . '_' . $file_name;
        $file_path = $upload_dir . $new_file_name;
        
        // Vérifier le type de fichier (ajuster selon vos besoins)
        $allowed_types = array('pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png', 'zip', 'txt');
        if (in_array(strtolower($file_ext), $allowed_types)) {
            // Déplacer le fichier téléchargé
            if (move_uploaded_file($file_tmp, $file_path)) {
                $file_uploaded = true;
                $file_url = $base_url . '/' . $file_path;
            }
        }
    }
    
    // Créer le corps de l'email
    $email_body = "
    <html>
    <head>
        <title>Demande d'étude de faisabilité</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .header { background-color: #000; color: white; padding: 20px; text-align: center; }
            .section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
            .section-title { color: #007bff; border-bottom: 2px solid #007bff; padding-bottom: 5px; margin-bottom: 15px; }
            .field { margin-bottom: 10px; }
            .field-label { font-weight: bold; display: inline-block; width: 250px; }
            .field-value { }
            .file-link { color: #007bff; text-decoration: none; }
            .file-link:hover { text-decoration: underline; }
        </style>
    </head>
    <body>
        <div class='header'>
            <h2>Demande d'étude de faisabilité</h2>
            <p>Date de soumission: " . date('d/m/Y H:i:s') . "</p>
        </div>
        <div class='section'>
            <h3 class='section-title'>1. INFORMATIONS DU DEMANDEUR</h3>
            <div class='field'><span class='field-label'>Nom(s):</span> <span class='field-value'>" . $form_data['applicantName'] . "</span></div>
            <div class='field'><span class='field-label'>Prénom:</span> <span class='field-value'>" . $form_data['applicantSurname'] . "</span></div>
            <div class='field'><span class='field-label'>Pays:</span> <span class='field-value'>" . $form_data['country'] . "</span></div>
            <div class='field'><span class='field-label'>Ville:</span> <span class='field-value'>" . $form_data['city'] . "</span></div>
            <div class='field'><span class='field-label'>Rue:</span> <span class='field-value'>" . $form_data['street'] . "</span></div>
            <div class='field'><span class='field-label'>Code postal:</span> <span class='field-value'>" . $form_data['zip'] . "</span></div>
            <div class='field'><span class='field-label'>Téléphone(s):</span> <span class='field-value'>" . $form_data['phoneNumber'] . "</span></div>
            <div class='field'><span class='field-label'>Email:</span> <span class='field-value'>" . $form_data['email'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>2. SITUATION ACTUELLE DE L'ENTREPRISE</h3>
            <div class='field'><span class='field-label'>État actuel de l'entreprise:</span> <span class='field-value'>" . $form_data['currentState'] . "</span></div>
            <div class='field'><span class='field-label'>Défis commerciaux:</span> <span class='field-value'>" . $form_data['businessChallenges'] . "</span></div>
            <div class='field'><span class='field-label'>Opportunités commerciales:</span> <span class='field-value'>" . $form_data['businessOpportunities'] . "</span></div>
            <div class='field'><span class='field-label'>Rôle de l'entreprise dans le projet:</span> <span class='field-value'>" . $form_data['role'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>3. INFORMATIONS SUR LE PROJET</h3>
            <div class='field'><span class='field-label'>Objectif de l'étude de faisabilité:</span> <span class='field-value'>" . $form_data['projectPurpose'] . "</span></div>
            <div class='field'><span class='field-label'>Objectifs du demandeur:</span> <span class='field-value'>" . $form_data['projectGoals'] . "</span></div>
            <div class='field'><span class='field-label'>Le demandeur est-il propriétaire du projet?:</span> <span class='field-value'>" . $form_data['projectOwner'] . "</span></div>
            <div class='field'><span class='field-label'>Rôle si non propriétaire:</span> <span class='field-value'>" . $form_data['role_project'] . "</span></div>
            <div class='field'><span class='field-label'>Emplacement du projet:</span> <span class='field-value'>" . $form_data['projectLocation'] . "</span></div>
            <div class='field'><span class='field-label'>Le demandeur est-il propriétaire du terrain?:</span> <span class='field-value'>" . $form_data['landOwner'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>4. FINANCEMENT</h3>
            <div class='field'><span class='field-label'>Origine du financement:</span> <span class='field-value'>" . $form_data['fundingSource'] . "</span></div>
            <div class='field'><span class='field-label'>Prêt:</span> <span class='field-value'>" . $form_data['fundingType'] . "</span></div>
            <div class='field'><span class='field-label'>Détails du prêt:</span> <span class='field-value'>" . $form_data['loanDetails'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>5. DONNÉES</h3>
            <div class='field'><span class='field-label'>Données à collecter et analyser:</span> <span class='field-value'>" . $form_data['dataCollection'] . "</span></div>
            <div class='field'><span class='field-label'>Type de données nécessaires:</span> <span class='field-value'>" . $form_data['dataType'] . "</span></div>
            <div class='field'><span class='field-label'>Source des données:</span> <span class='field-value'>" . $form_data['dataSource'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>6. MÉTHODOLOGIE</h3>
            <div class='field'><span class='field-label'>Méthodologie:</span> <span class='field-value'>" . $form_data['methodology'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>7. CONCEPTION ARCHITECTURALE</h3>
            <div class='field'><span class='field-label'>Éléments sélectionnés:</span> <span class='field-value'>" . $form_data['architecturalConception'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>8. ÉTUDE ÉCONOMIQUE</h3>
            <div class='field'><span class='field-label'>Éléments sélectionnés:</span> <span class='field-value'>" . $form_data['economicStudy'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>9. ÉTUDE FINANCIÈRE</h3>
            <div class='field'><span class='field-label'>Éléments sélectionnés:</span> <span class='field-value'>" . $form_data['financialStudy'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>10. IMPACT</h3>
            <div class='field'><span class='field-label'>Types d'impact:</span> <span class='field-value'>" . $form_data['impact'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>11. DÉLAI</h3>
            <div class='field'><span class='field-label'>Délai pour l'étude de faisabilité:</span> <span class='field-value'>" . $form_data['timeline'] . "</span></div>
            <div class='field'><span class='field-label'>Date de début:</span> <span class='field-value'>" . $form_data['startDate'] . "</span></div>
            <div class='field'><span class='field-label'>Date limite de livraison:</span> <span class='field-value'>" . $form_data['deliveryDate'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>12. RESSOURCES</h3>
            <div class='field'><span class='field-label'>Ressources nécessaires:</span> <span class='field-value'>" . $form_data['resources'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>13. PROFIL DU CONSULTANT</h3>
            <div class='field'><span class='field-label'>Profil du consultant nécessaire:</span> <span class='field-value'>" . $form_data['consultantProfile'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>14. EXPERTISE SUPPLÉMENTAIRE</h3>
            <div class='field'><span class='field-label'>Expertise supplémentaire requise:</span> <span class='field-value'>" . $form_data['additionalExpertise'] . "</span></div>
            <div class='field'><span class='field-label'>Domaine d'expertise supplémentaire:</span> <span class='field-value'>" . $form_data['expertiseArea'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>15. ENDOSSEMENTS</h3>
            <div class='field'><span class='field-label'>Besoin d'endossements:</span> <span class='field-value'>" . $form_data['endorsements'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>16. BUDGET</h3>
            <div class='field'><span class='field-label'>Budget du demandeur:</span> <span class='field-value'>" . $form_data['budget'] . "</span></div>
            <div class='field'><span class='field-label'>Financement du coût de l'étude:</span> <span class='field-value'>" . $form_data['budgetFinancing'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>17. RÉSULTATS</h3>
            <div class='field'><span class='field-label'>Présentation des résultats:</span> <span class='field-value'>" . $form_data['resultsPresentation'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>18. PROCHAINE ÉTAPE</h3>
            <div class='field'><span class='field-label'>Étapes suivantes si le projet est viable:</span> <span class='field-value'>" . $form_data['nextStepIfViable'] . "</span></div>
            <div class='field'><span class='field-label'>Étapes suivantes si le projet n'est pas viable:</span> <span class='field-value'>" . $form_data['nextStepIfNotViable'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>19. INFORMATIONS SUPPLÉMENTAIRES</h3>
            <div class='field'><span class='field-label'>Informations supplémentaires:</span> <span class='field-value'>" . $form_data['additionalInformation'] . "</span></div>
        </div>
        <div class='section'>
            <h3 class='section-title'>20. APPROBATION DU DEMANDEUR</h3>
            <div class='field'><span class='field-label'>Nom complet du demandeur:</span> <span class='field-value'>" . $form_data['applicantNameApproval'] . "</span></div>
            <div class='field'><span class='field-label'>Date:</span> <span class='field-value'>" . $form_data['approvalDate'] . "</span></div>
    ";
    
    // Ajouter la signature au corps de l'email si disponible
    if (!empty($signature_url)) {
        $email_body .= "
            <div class='field'><span class='field-label'>Signature:</span> <span class='field-value'><br><img src='" . $signature_url . "' alt='Signature' style='max-width: 300px; border: 1px solid #ddd; padding: 5px; margin-top: 10px;'/><br><a href='" . $signature_url . "' class='file-link' target='_blank'>Voir la signature</a></span></div>
        ";
    }
    
    // Ajouter le fichier téléchargé au corps de l'email si disponible
    if ($file_uploaded && !empty($file_url)) {
        $email_body .= "
            <div class='field'><span class='field-label'>Fichier téléchargé:</span> <span class='field-value'>" . $file_name . "<br><a href='" . $file_url . "' class='file-link' target='_blank'>Télécharger le fichier</a></span></div>
        ";
    }
    
    // Fermer le corps de l'email
    $email_body .= "
        </div>
    </body>
    </html>
    ";
    
    // En-têtes de l'email
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $from_email . "\r\n";
    $headers .= "Reply-To: " . $form_data['email'] . "\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    
    // Envoyer l'email
    $mail_sent = mail($to_email, $email_subject, $email_body, $headers);
    
    // Préparer la réponse
    if ($mail_sent) {
        // Réponse de succès
        $response = array(
            'status' => 'success',
            'message' => 'Votre demande a été envoyée avec succès. Nous vous contacterons bientôt.',
            'signature_url' => $signature_url,
            'file_url' => $file_url
        );
    } else {
        // Réponse d'erreur
        $response = array(
            'status' => 'error',
            'message' => 'Une erreur s\'est produite lors de l\'envoi de votre demande. Veuillez réessayer plus tard.'
        );
    }
    
    // Retourner la réponse JSON
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // Méthode non autorisée
    header('HTTP/1.1 405 Method Not Allowed');
    $response = array(
        'status' => 'error',
        'message' => 'Méthode non autorisée'
    );
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>