Le problème que vous rencontrez est dû à une erreur dans la validation des champs du formulaire. Le message "Please fill in all required fields before proceeding" s'affiche même lorsque tous les champs sont remplis parce que la fonction de validation a des problèmes avec certains types de champs. Voici le code corrigé :

```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Feasibility Study Application Form</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
    <style>
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .card-header {
            border-radius: 10px 10px 0 0 !important;
            background-color: #000 !important;
            color: white;
            text-align: center;
            padding: 1.5rem;
        }
        .tabs-container {
            display: flex;
            flex-direction: column;
            min-height: 600px;
        }
        .tabs-nav {
            display: flex;
            overflow-x: auto;
            background-color: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
            padding: 0.5rem 0;
            margin-bottom: 1rem;
        }
        .tab-item {
            padding: 0.75rem 1rem;
            cursor: pointer;
            font-size: 0.85rem;
            white-space: nowrap;
            transition: all 0.3s;
            border-radius: 5px 5px 0 0;
            margin: 0 2px;
            color: #6c757d;
        }
        .tab-item.active {
            background-color: #007bff;
            color: white;
            font-weight: bold;
        }
        .tab-item:hover:not(.active) {
            background-color: #e9ecef;
        }
        .tab-content-container {
            flex: 1;
            padding: 1rem;
        }
        .tab-content {
            display: none;
            animation: fadeIn 0.5s;
        }
        .tab-content.active {
            display: block;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .tab-header {
            margin-bottom: 1.5rem;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid #007bff;
        }
        .tab-header h3 {
            color: #007bff;
            margin: 0;
        }
        .form-section {
            background-color: #f8f9fa;
            padding: 1.5rem;
            border-radius: 8px;
        }
        .form-group {
            margin-bottom: 1rem;
        }
        .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 0.5rem;
            display: block;
        }
        .form-control, textarea {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 0.5rem;
            width: 100%;
            box-sizing: border-box;
        }
        textarea {
            resize: vertical;
            min-height: 100px;
        }
        .checkbox-group {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 0.5rem;
            margin-top: 0.5rem;
        }
        .form-check {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        .form-check-input {
            margin: 0;
            width: 18px;
            height: 18px;
        }
        .form-check-label {
            font-weight: normal;
            color: #555;
        }
        .tab-navigation {
            display: flex;
            justify-content: space-between;
            padding: 1rem 0;
            margin-top: 1rem;
            border-top: 1px solid #dee2e6;
        }
        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 5px;
            font-weight: 600;
        }
        .btn-secondary {
            background-color: #6c757d;
            border: none;
            color: white;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
        }
        .btn-primary {
            background-color: #007bff;
            border: none;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .btn-success {
            background-color: #28a745;
            border: none;
        }
        .btn-success:hover {
            background-color: #218838;
        }
        .custom-file-upload {
            display: inline-block;
            padding: 10px 20px;
            cursor: pointer;
            background-color: #dc3545;
            color: white !important;
            border-radius: 4px;
            font-weight: bold;
            text-decoration: none;
        }
        .custom-file-upload:hover {
            background-color: #c82333;
        }
        .hidden-input {
            display: none;
        }
        .file-name {
            margin-left: 10px;
            font-style: italic;
            color: #555;
        }
        #signature-pad {
            margin: 1rem 0;
        }
        #signature-canvas {
            background: #fff;
            border-radius: 4px;
        }
        .progress-bar {
            height: 5px;
            border-radius: 3px;
        }
        .error-message {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 0.25rem;
        }
        .success-message {
            display: none;
            text-align: center;
            padding: 2rem;
            background-color: #d4edda;
            color: #155724;
            border-radius: 8px;
            margin: 1rem 0;
        }
        .loading {
            opacity: 0.7;
            pointer-events: none;
        }
        #error-message {
            display: none;
            color: #dc3545;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 4px;
            padding: 1rem;
            margin: 1rem 0;
        }
        @media (max-width: 768px) {
            .checkbox-group {
                grid-template-columns: 1fr;
            }
            .tab-item {
                font-size: 0.8rem;
                padding: 0.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <form id="feasibilityForm" enctype="multipart/form-data">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="card border-0 shadow-lg">
                        <div class="card-header bg-primary text-white text-center" style="background-color: #000 !important;">
                            <h2 class="mb-0">Feasibility Study Application Form</h2>
                            <p class="mb-0">Complete all sections to submit your application</p>
                        </div>
                        <div class="card-body p-0">
                            <!-- Error Message -->
                            <div id="error-message"></div>
                            <!-- Progress Bar -->
                            <div class="px-4 py-2">
                                <div class="progress-bar bg-primary" id="progressBar" style="width: 5%;"></div>
                            </div>
                            <!-- Tabs Navigation -->
                            <div class="tabs-container">
                                <div class="tabs-nav" id="tabsNav">
                                    <div class="tab-item active" data-tab="0">Applicant Information</div>
                                    <div class="tab-item" data-tab="1">Company Current Situation</div>
                                    <div class="tab-item" data-tab="2">Project Information</div>
                                    <div class="tab-item" data-tab="3">Funding</div>
                                    <div class="tab-item" data-tab="4">Data</div>
                                    <div class="tab-item" data-tab="5">Methodology</div>
                                    <div class="tab-item" data-tab="6">Architectural Conception</div>
                                    <div class="tab-item" data-tab="7">Economic Study</div>
                                    <div class="tab-item" data-tab="8">Financial Study</div>
                                    <div class="tab-item" data-tab="9">Impact</div>
                                    <div class="tab-item" data-tab="10">Time Frame</div>
                                    <div class="tab-item" data-tab="11">Resources</div>
                                    <div class="tab-item" data-tab="12">Consultant's Profile</div>
                                    <div class="tab-item" data-tab="13">Additional Expertise</div>
                                    <div class="tab-item" data-tab="14">Endorsements</div>
                                    <div class="tab-item" data-tab="15">Budget</div>
                                    <div class="tab-item" data-tab="16">Results</div>
                                    <div class="tab-item" data-tab="17">Next Step</div>
                                    <div class="tab-item" data-tab="18">Additional Information</div>
                                    <div class="tab-item" data-tab="19">Applicant's Approval</div>
                                </div>
                                <!-- Tab Content -->
                                <div class="tab-content-container">
                                    <!-- Tab 1: Applicant Information -->
                                    <div class="tab-content active" id="tab-0">
                                        <div class="tab-header">
                                            <h3>1. APPLICANT INFORMATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="applicantName">Applicant's Name(s):</label>
                                                        <input type="text" id="applicantName" name="applicantName" class="form-control" required>
                                                        <div class="error-message" id="error-applicantName" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="applicantSurname">Applicant's Surname:</label>
                                                        <input type="text" id="applicantSurname" name="applicantSurname" class="form-control" required>
                                                        <div class="error-message" id="error-applicantSurname" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="country">Country:</label>
                                                        <input type="text" id="country" name="country" class="form-control" required>
                                                        <div class="error-message" id="error-country" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="city">City:</label>
                                                        <input type="text" id="city" name="city" class="form-control" required>
                                                        <div class="error-message" id="error-city" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="street">Street:</label>
                                                        <input type="text" id="street" name="street" class="form-control" required>
                                                        <div class="error-message" id="error-street" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="zip">Zip:</label>
                                                        <input type="text" id="zip" name="zip" class="form-control" required>
                                                        <div class="error-message" id="error-zip" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="phoneNumber">Phone Number(s):</label>
                                                        <input type="tel" id="phoneNumber" name="phoneNumber" class="form-control" required>
                                                        <div class="error-message" id="error-phoneNumber" style="display: none;">This field is required</div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="email">Email Address:</label>
                                                        <input type="email" id="email" name="email" class="form-control" required>
                                                        <div class="error-message" id="error-email" style="display: none;">Please enter a valid email address</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 2: Company Current Situation -->
                                    <div class="tab-content" id="tab-1">
                                        <div class="tab-header">
                                            <h3>2. COMPANY CURRENT SITUATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="currentState">What is the company's current state of affairs?</label>
                                                <textarea id="currentState" name="currentState" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-currentState" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="businessChallenges">What business challenges is the applicant facing?</label>
                                                <textarea id="businessChallenges" name="businessChallenges" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-businessChallenges" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="businessOpportunities">What business opportunities is the applicant viewing?</label>
                                                <textarea id="businessOpportunities" name="businessOpportunities" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-businessOpportunities" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Specify the company's role in the project:</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="owner" name="role[]" value="Owner" class="form-check-input">
                                                        <label class="form-check-label" for="owner">Owner</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="subcontractor" name="role[]" value="Subcontractor" class="form-check-input">
                                                        <label class="form-check-label" for="subcontractor">Subcontractor</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-role" style="display: none;">Please select at least one option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 3: Project Information -->
                                    <div class="tab-content" id="tab-2">
                                        <div class="tab-header">
                                            <h3>3. PROJECT INFORMATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="projectPurpose">What is the purpose of the feasibility study?</label>
                                                <textarea id="projectPurpose" name="projectPurpose" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-projectPurpose" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="projectGoals">What are the applicant's goals and objectives?</label>
                                                <textarea id="projectGoals" name="projectGoals" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-projectGoals" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Is the applicant the owner of the project?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="projectOwnerYes" name="projectOwner" value="Yes" class="form-check-input" required>
                                                        <label class="form-check-label" for="projectOwnerYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="projectOwnerNo" name="projectOwner" value="No" class="form-check-input" required>
                                                        <label class="form-check-label" for="projectOwnerNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-projectOwner" style="display: none;">Please select an option</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="role_project">If the applicant is not the owner, what is their role?</label>
                                                <textarea id="role_project" name="role_project" class="form-control" rows="3"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="projectLocation">Please specify the location(s) of the project:</label>
                                                <input type="text" id="projectLocation" name="projectLocation" class="form-control" required>
                                                <div class="error-message" id="error-projectLocation" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Is the applicant the owner of the land where the project will be located?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="landOwnerYes" name="landOwner" value="Yes" class="form-check-input" required>
                                                        <label class="form-check-label" for="landOwnerYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="landOwnerNo" name="landOwner" value="No" class="form-check-input" required>
                                                        <label class="form-check-label" for="landOwnerNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-landOwner" style="display: none;">Please select an option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 4: Funding -->
                                    <div class="tab-content" id="tab-3">
                                        <div class="tab-header">
                                            <h3>4. FUNDING</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="fundingSource">Please specify the origin of the funding:</label>
                                                <input type="text" id="fundingSource" name="fundingSource" class="form-control" required>
                                                <div class="error-message" id="error-fundingSource" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Loan:</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="loan" name="fundingType" value="Loan" class="form-check-input">
                                                        <label class="form-check-label" for="loan">Loan</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="loanDetails">Please specify the amount and terms (if applicable):</label>
                                                <textarea id="loanDetails" name="loanDetails" class="form-control" rows="4"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 5: Data -->
                                    <div class="tab-content" id="tab-4">
                                        <div class="tab-header">
                                            <h3>5. DATA</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="dataCollection">What data will be collected and analyzed?</label>
                                                <textarea id="dataCollection" name="dataCollection" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-dataCollection" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label>What type of data will be needed for the feasibility study?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="quantitative" name="dataType[]" value="Quantitative" class="form-check-input">
                                                        <label class="form-check-label" for="quantitative">Quantitative</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="qualitative" name="dataType[]" value="Qualitative" class="form-check-input">
                                                        <label class="form-check-label" for="qualitative">Qualitative</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-dataType" style="display: none;">Please select at least one option</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Will the applicant provide data, or will it need to be collected by GIFAM's team?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="applicantData" name="dataSource[]" value="The applicant" class="form-check-input">
                                                        <label class="form-check-label" for="applicantData">The applicant</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="gifamTeamData" name="dataSource[]" value="GIFAM's team" class="form-check-input">
                                                        <label class="form-check-label" for="gifamTeamData">GIFAM's team</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-dataSource" style="display: none;">Please select at least one option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 6: Methodology -->
                                    <div class="tab-content" id="tab-5">
                                        <div class="tab-header">
                                            <h3>6. METHODOLOGY</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="methodology">How will the feasibility study be conducted?</label>
                                                <textarea id="methodology" name="methodology" class="form-control" rows="6" required></textarea>
                                                <div class="error-message" id="error-methodology" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 7: Architectural Conception -->
                                    <div class="tab-content" id="tab-6">
                                        <div class="tab-header">
                                            <h3>7. ARCHITECTURAL CONCEPTION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="architecturalAnalysis" name="architecturalConception[]" value="Architectural Technical Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="architecturalAnalysis">Architectural Technical Analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="architecturalPlans" name="architecturalConception[]" value="Architectural Plans" class="form-check-input">
                                                    <label class="form-check-label" for="architecturalPlans">Architectural Plans</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="elevationSections" name="architecturalConception[]" value="Elevation and Sections" class="form-check-input">
                                                    <label class="form-check-label" for="elevationSections">Elevation and Sections</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="groundPlan" name="architecturalConception[]" value="Ground Plan" class="form-check-input">
                                                    <label class="form-check-label" for="groundPlan">Ground Plan</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="sketchUp" name="architecturalConception[]" value="Sketch up" class="form-check-input">
                                                    <label class="form-check-label" for="sketchUp">Sketch up</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="3dModeling" name="architecturalConception[]" value="3D modeling" class="form-check-input">
                                                    <label class="form-check-label" for="3dModeling">3D modeling</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="3dVideo" name="architecturalConception[]" value="3D Video" class="form-check-input">
                                                    <label class="form-check-label" for="3dVideo">3D Video</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="rendering" name="architecturalConception[]" value="Rendering" class="form-check-input">
                                                    <label class="form-check-label" for="rendering">Rendering</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 8: Economic Study -->
                                    <div class="tab-content" id="tab-7">
                                        <div class="tab-header">
                                            <h3>8. ECONOMIC STUDY</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="marketStudy" name="economicStudy[]" value="Market Study" class="form-check-input">
                                                    <label class="form-check-label" for="marketStudy">Market Study</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="industryInsight" name="economicStudy[]" value="Industry Insight" class="form-check-input">
                                                    <label class="form-check-label" for="industryInsight">Industry Insight</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="demandAnalysis" name="economicStudy[]" value="Demand analysis" class="form-check-input">
                                                    <label class="form-check-label" for="demandAnalysis">Demand analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="supplyAnalysis" name="economicStudy[]" value="Supply-side analysis" class="form-check-input">
                                                    <label class="form-check-label" for="supplyAnalysis">Supply-side analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="competitiveAnalysis" name="economicStudy[]" value="Competitive analysis" class="form-check-input">
                                                    <label class="form-check-label" for="competitiveAnalysis">Competitive analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="pestleAnalysis" name="economicStudy[]" value="PESTLE Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="pestleAnalysis">PESTLE Analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="swotAnalysis" name="economicStudy[]" value="SWOT Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="swotAnalysis">SWOT Analysis</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="marketingStrategy" name="economicStudy[]" value="Marketing Strategy" class="form-check-input">
                                                    <label class="form-check-label" for="marketingStrategy">Marketing Strategy</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="operationalFeasibility" name="economicStudy[]" value="Operational feasibility" class="form-check-input">
                                                    <label class="form-check-label" for="operationalFeasibility">Operational feasibility</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="organizationalAnalysis" name="economicStudy[]" value="Organizational Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="organizationalAnalysis">Organizational Analysis</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 9: Financial Study -->
                                    <div class="tab-content" id="tab-8">
                                        <div class="tab-header">
                                            <h3>9. FINANCIAL STUDY</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="financialOverview" name="financialStudy[]" value="Financial Overview" class="form-check-input">
                                                    <label class="form-check-label" for="financialOverview">Financial Overview</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="loanAmortizationTable" name="financialStudy[]" value="Loan Amortization Table" class="form-check-input">
                                                    <label class="form-check-label" for="loanAmortizationTable">Loan Amortization Table</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="capexOpexFunding" name="financialStudy[]" value="Capex & Opex funding" class="form-check-input">
                                                    <label class="form-check-label" for="capexOpexFunding">Capex & Opex funding</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="fundingPeriods" name="financialStudy[]" value="Funding Periods" class="form-check-input">
                                                    <label class="form-check-label" for="fundingPeriods">Funding Periods</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="investmentPlan" name="financialStudy[]" value="Investment Plan" class="form-check-input">
                                                    <label class="form-check-label" for="investmentPlan">Investment Plan</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="fixedAssetsDepreciation" name="financialStudy[]" value="Fixed Assets Depreciation Table" class="form-check-input">
                                                    <label class="form-check-label" for="fixedAssetsDepreciation">Fixed Assets Depreciation Table</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="operatingExpensesForecasting" name="financialStudy[]" value="Operating Expenses Forecasting" class="form-check-input">
                                                    <label class="form-check-label" for="operatingExpensesForecasting">Operating Expenses Forecasting</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="salesForecasting" name="financialStudy[]" value="Sales Forecasting" class="form-check-input">
                                                    <label class="form-check-label" for="salesForecasting">Sales Forecasting</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="incomeStatement" name="financialStudy[]" value="Income Statement" class="form-check-input">
                                                    <label class="form-check-label" for="incomeStatement">Income Statement</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="balanceSheet" name="financialStudy[]" value="Balance Sheet" class="form-check-input">
                                                    <label class="form-check-label" for="balanceSheet">Balance Sheet</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="cashFlowStatement" name="financialStudy[]" value="Cash-Flow Statement" class="form-check-input">
                                                    <label class="form-check-label" for="cashFlowStatement">Cash-Flow Statement</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="financialRatios" name="financialStudy[]" value="Financial Ratios Analysis" class="form-check-input">
                                                    <label class="form-check-label" for="financialRatios">Financial Ratios Analysis</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 10: Impact -->
                                    <div class="tab-content" id="tab-9">
                                        <div class="tab-header">
                                            <h3>10. IMPACT</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="economicImpact" name="impact[]" value="Economic impact" class="form-check-input">
                                                    <label class="form-check-label" for="economicImpact">Economic impact (e.g., job creation, GDP growth)</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="socialImpact" name="impact[]" value="Social impact" class="form-check-input">
                                                    <label class="form-check-label" for="socialImpact">Social impact (e.g., education, healthcare)</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="environmentalImpact" name="impact[]" value="Environmental impact" class="form-check-input">
                                                    <label class="form-check-label" for="environmentalImpact">Environmental impact (e.g., sustainability, carbon footprint)</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 11: Time Frame -->
                                    <div class="tab-content" id="tab-10">
                                        <div class="tab-header">
                                            <h3>11. TIME FRAME</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="timeline">What is the timeline for the feasibility study?</label>
                                                <input type="text" id="timeline" name="timeline" class="form-control" required>
                                                <div class="error-message" id="error-timeline" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="startDate">When will it begin?</label>
                                                <input type="date" id="startDate" name="startDate" class="form-control" required>
                                                <div class="error-message" id="error-startDate" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="deliveryDate">What is the deadline for delivery?</label>
                                                <input type="date" id="deliveryDate" name="deliveryDate" class="form-control" required>
                                                <div class="error-message" id="error-deliveryDate" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 12: Resources -->
                                    <div class="tab-content" id="tab-11">
                                        <div class="tab-header">
                                            <h3>12. RESOURCES</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label>Which resources will be needed for the study?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="checkbox" id="gifamTeam" name="resources[]" value="GIFAM's Team" class="form-check-input">
                                                        <label class="form-check-label" for="gifamTeam">GIFAM's Team</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" id="thirdParty" name="resources[]" value="Third Party" class="form-check-input">
                                                        <label class="form-check-label" for="thirdParty">Third Party</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-resources" style="display: none;">Please select at least one option</div>
                                            </div>
                                            <div class="form-group">
                                                <label>Will additional staff or consultants be required?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalStaffYes" name="additionalStaff" value="Yes" class="form-check-input" required>
                                                        <label class="form-check-label" for="additionalStaffYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalStaffNo" name="additionalStaff" value="No" class="form-check-input" required>
                                                        <label class="form-check-label" for="additionalStaffNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-additionalStaff" style="display: none;">Please select an option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 13: Consultant's Profile -->
                                    <div class="tab-content" id="tab-12">
                                        <div class="tab-header">
                                            <h3>13. CONSULTANT'S PROFILE</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="consultantProfile">Please select the consultant's profile needed for conducting the feasibility study:</label>
                                                <input type="text" id="consultantProfile" name="consultantProfile" class="form-control" required>
                                                <div class="error-message" id="error-consultantProfile" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 14: Additional Expertise -->
                                    <div class="tab-content" id="tab-13">
                                        <div class="tab-header">
                                            <h3>14. ADDITIONAL EXPERTISE</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label>Please specify if any additional expertise shall be required for the project.</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalExpertiseYes" name="additionalExpertise" value="Yes" class="form-check-input" required>
                                                        <label class="form-check-label" for="additionalExpertiseYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="additionalExpertiseNo" name="additionalExpertise" value="No" class="form-check-input" required>
                                                        <label class="form-check-label" for="additionalExpertiseNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-additionalExpertise" style="display: none;">Please select an option</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="expertiseArea">If yes, please indicate the area for which additional expertise would be required:</label>
                                                <input type="text" id="expertiseArea" name="expertiseArea" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 15: Endorsements -->
                                    <div class="tab-content" id="tab-14">
                                        <div class="tab-header">
                                            <h3>15. ENDORSEMENTS</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label>Does the feasibility study need endorsements from a certified expert corporation?</label>
                                                <div class="checkbox-group">
                                                    <div class="form-check">
                                                        <input type="radio" id="endorsementsYes" name="endorsements" value="Yes" class="form-check-input" required>
                                                        <label class="form-check-label" for="endorsementsYes">Yes</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="endorsementsNo" name="endorsements" value="No" class="form-check-input" required>
                                                        <label class="form-check-label" for="endorsementsNo">No</label>
                                                    </div>
                                                </div>
                                                <div class="error-message" id="error-endorsements" style="display: none;">Please select an option</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 16: Budget -->
                                    <div class="tab-content" id="tab-15">
                                        <div class="tab-header">
                                            <h3>16. BUDGET</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="budget">What is the applicant's budget for the feasibility study?</label>
                                                <input type="text" id="budget" name="budget" class="form-control" required>
                                                <div class="error-message" id="error-budget" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="budgetFinancing">How will the feasibility study cost be financed?</label>
                                                <input type="text" id="budgetFinancing" name="budgetFinancing" class="form-control" required>
                                                <div class="error-message" id="error-budgetFinancing" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 17: Results -->
                                    <div class="tab-content" id="tab-16">
                                        <div class="tab-header">
                                            <h3>17. RESULTS</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="resultsPresentation">How will the results of the feasibility study be presented?</label>
                                                <input type="text" id="resultsPresentation" name="resultsPresentation" class="form-control" required>
                                                <div class="error-message" id="error-resultsPresentation" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 18: Next Step -->
                                    <div class="tab-content" id="tab-17">
                                        <div class="tab-header">
                                            <h3>18. NEXT STEP</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="nextStepIfViable">If the feasibility study indicates the project is viable, what will be the next steps?</label>
                                                <textarea id="nextStepIfViable" name="nextStepIfViable" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-nextStepIfViable" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="nextStepIfNotViable">If the feasibility study indicates the project is not viable, what will be the next steps?</label>
                                                <textarea id="nextStepIfNotViable" name="nextStepIfNotViable" class="form-control" rows="4" required></textarea>
                                                <div class="error-message" id="error-nextStepIfNotViable" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 19: Additional Information -->
                                    <div class="tab-content" id="tab-18">
                                        <div class="tab-header">
                                            <h3>19. ADDITIONAL INFORMATION</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="additionalInformation">Please provide any additional information relevant to your project:</label>
                                                <textarea id="additionalInformation" name="additionalInformation" class="form-control" rows="6"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab 20: Applicant's Approval -->
                                    <div class="tab-content" id="tab-19">
                                        <div class="tab-header">
                                            <h3>20. APPLICANT'S APPROVAL</h3>
                                        </div>
                                        <div class="form-section">
                                            <div class="form-group">
                                                <label for="applicantNameApproval">Applicant's full name:</label>
                                                <input type="text" id="applicantNameApproval" name="applicantNameApproval" class="form-control" required>
                                                <div class="error-message" id="error-applicantNameApproval" style="display: none;">This field is required</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="Uploadyourproject">Upload your project:</label>
                                                <label class="custom-file-upload">
                                                    <input type="file" id="Uploadyourproject" name="Uploadyourproject" class="hidden-input" onchange="updateFileName(this)">
                                                    📁 Upload your project
                                                </label>
                                                <span class="file-name" id="file-name">No file selected</span>
                                            </div>
                                            <div class="form-group">
                                                <label for="signature">Signature:</label>
                                                <div id="signature-pad" class="mb-2" style="border:1px solid #ccc; border-radius:4px;">
                                                    <canvas id="signature-canvas" width="400" height="150" style="background:#fff;"></canvas>
                                                </div>
                                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="clearSignature()">Clear</button>
                                                <input type="hidden" name="signature_data" id="signature_data">
                                                <div class="error-message" id="error-signature" style="display: none;">Please provide your signature</div>
                                            </div>
                                            <div class="form-group">
                                                <label for="approvalDate">Date:</label>
                                                <input type="date" id="approvalDate" name="approvalDate" class="form-control" required>
                                                <div class="error-message" id="error-approvalDate" style="display: none;">This field is required</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Navigation Buttons -->
                                <div class="tab-navigation">
                                    <button type="button" class="btn btn-secondary" id="prevBtn" onclick="previousTab()">Previous</button>
                                    <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextTab()">Next</button>
                                    <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">Submit Application</button>
                                </div>
                                <!-- Success Message -->
                                <div class="success-message" id="successMessage">
                                    <h4>Application Submitted Successfully!</h4>
                                    <p>Your feasibility study application has been sent successfully. We will contact you soon.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>
        // Tab functionality
        let currentTab = 0;
        const totalTabs = 20;
        const tabItems = document.querySelectorAll('.tab-item');
        const tabContents = document.querySelectorAll('.tab-content');
        const progressBar = document.getElementById('progressBar');
        const errorMessage = document.getElementById('error-message');
        
        // Initialize signature pad
        let signaturePad;
        window.addEventListener('load', function() {
            const canvas = document.getElementById('signature-canvas');
            signaturePad = new SignaturePad(canvas);
            // Initialize the first tab
            showTab(currentTab);
            // Update progress bar
            updateProgress();
            // Clear error message on page load
            errorMessage.style.display = 'none';
        });
        
        function showTab(n) {
            // Hide all tab contents
            tabContents.forEach(content => {
                content.classList.remove('active');
            });
            // Remove active class from all tab items
            tabItems.forEach(item => {
                item.classList.remove('active');
            });
            // Show the current tab
            tabContents[n].classList.add('active');
            tabItems[n].classList.add('active');
            // Update navigation buttons
            if (n === 0) {
                document.getElementById('prevBtn').style.display = 'none';
            } else {
                document.getElementById('prevBtn').style.display = 'inline-block';
            }
            if (n === totalTabs - 1) {
                document.getElementById('nextBtn').style.display = 'none';
                document.getElementById('submitBtn').style.display = 'inline-block';
            } else {
                document.getElementById('nextBtn').style.display = 'inline-block';
                document.getElementById('submitBtn').style.display = 'none';
            }
            // Update progress bar
            updateProgress();
            // Clear error message when changing tabs
            errorMessage.style.display = 'none';
        }
        
        function nextTab() {
            // Validate current tab before moving to next
            if (validateTab(currentTab)) {
                if (currentTab < totalTabs - 1) {
                    currentTab++;
                    showTab(currentTab);
                }
            }
        }
        
        function previousTab() {
            if (currentTab > 0) {
                currentTab--;
                showTab(currentTab);
            }
        }
        
        function updateProgress() {
            const progress = ((currentTab) / (totalTabs - 1)) * 100;
            progressBar.style.width = progress + '%';
        }
        
        function validateTab(tabIndex) {
            let isValid = true;
            // Clear previous error messages
            document.querySelectorAll('.error-message').forEach(el => {
                el.style.display = 'none';
            });
            
            // Get all required fields in the current tab
            const currentTabContent = tabContents[tabIndex];
            const requiredFields = currentTabContent.querySelectorAll('[required]');
            
            // Validate each required field
            requiredFields.forEach(field => {
                if (field.type === 'checkbox' || field.type === 'radio') {
                    const name = field.name;
                    const group = document.querySelectorAll(`input[name="${name}"]`);
                    const checked = Array.from(group).some(input => input.checked);
                    if (!checked) {
                        isValid = false;
                        const errorId = 'error-' + name;
                        const errorElement = document.getElementById(errorId);
                        if (errorElement) {
                            errorElement.style.display = 'block';
                        }
                        field.style.borderColor = 'red';
                    } else {
                        field.style.borderColor = '#ddd';
                    }
                } else if (field.tagName === 'TEXTAREA' || field.type === 'text' || field.type === 'email' || field.type === 'tel' || field.type === 'date') {
                    if (!field.value || field.value.trim() === '') {
                        isValid = false;
                        const errorId = 'error-' + field.id;
                        const errorElement = document.getElementById(errorId);
                        if (errorElement) {
                            errorElement.style.display = 'block';
                        }
                        field.style.borderColor = 'red';
                    } else {
                        field.style.borderColor = '#ddd';
                    }
                } else if (!field.value || field.value === '') {
                    isValid = false;
                    const errorId = 'error-' + field.id;
                    const errorElement = document.getElementById(errorId);
                    if (errorElement) {
                        errorElement.style.display = 'block';
                    }
                    field.style.borderColor = 'red';
                } else {
                    field.style.borderColor = '#ddd';
                }
            });
            
            // Special validation for checkboxes and radio buttons
            switch(tabIndex) {
                case 1: // Company Current Situation
                    const roleCheckboxes = document.querySelectorAll('input[name="role[]"]');
                    const roleChecked = Array.from(roleCheckboxes).some(cb => cb.checked);
                    if (!roleChecked) {
                        isValid = false;
                        document.getElementById('error-role').style.display = 'block';
                    }
                    break;
                case 4: // Data
                    const dataTypeCheckboxes = document.querySelectorAll('input[name="dataType[]"]');
                    const dataTypeChecked = Array.from(dataTypeCheckboxes).some(cb => cb.checked);
                    if (!dataTypeChecked) {
                        isValid = false;
                        document.getElementById('error-dataType').style.display = 'block';
                    }
                    const dataSourceCheckboxes = document.querySelectorAll('input[name="dataSource[]"]');
                    const dataSourceChecked = Array.from(dataSourceCheckboxes).some(cb => cb.checked);
                    if (!dataSourceChecked) {
                        isValid = false;
                        document.getElementById('error-dataSource').style.display = 'block';
                    }
                    break;
                case 11: // Resources
                    const resourcesCheckboxes = document.querySelectorAll('input[name="resources[]"]');
                    const resourcesChecked = Array.from(resourcesCheckboxes).some(cb => cb.checked);
                    if (!resourcesChecked) {
                        isValid = false;
                        document.getElementById('error-resources').style.display = 'block';
                    }
                    break;
                case 19: // Applicant's Approval
                    if (signaturePad.isEmpty()) {
                        isValid = false;
                        document.getElementById('error-signature').style.display = 'block';
                    }
                    break;
            }
            
            // Radio button validations
            const radioGroups = [
                { name: 'projectOwner', errorId: 'error-projectOwner' },
                { name: 'landOwner', errorId: 'error-landOwner' },
                { name: 'additionalStaff', errorId: 'error-additionalStaff' },
                { name: 'additionalExpertise', errorId: 'error-additionalExpertise' },
                { name: 'endorsements', errorId: 'error-endorsements' }
            ];
            
            radioGroups.forEach(group => {
                const radioButtons = document.querySelectorAll(`input[name="${group.name}"]`);
                const checked = Array.from(radioButtons).some(rb => rb.checked);
                if (!checked) {
                    isValid = false;
                    const errorElement = document.getElementById(group.errorId);
                    if (errorElement) {
                        errorElement.style.display = 'block';
                    }
                }
            });
            
            if (!isValid) {
                errorMessage.textContent = 'Please fill in all required fields before proceeding.';
                errorMessage.style.display = 'block';
            }
            
            return isValid;
        }
        
        function updateFileName(input) {
            const fileNameSpan = document.getElementById("file-name");
            if (input.files && input.files.length > 0) {
                fileNameSpan.textContent = input.files[0].name;
            } else {
                fileNameSpan.textContent = "No file selected";
            }
            // Clear error message when file is selected
            errorMessage.style.display = 'none';
        }
        
        function clearSignature() {
            signaturePad.clear();
            document.getElementById('signature_data').value = '';
            document.getElementById('error-signature').style.display = 'none';
            errorMessage.style.display = 'none';
        }
        
        // Form submission
        document.getElementById('feasibilityForm').addEventListener('submit', function(e) {
            e.preventDefault();
            // Validate final tab
            if (!validateTab(currentTab)) {
                return;
            }
            // Get signature data
            if (signaturePad.isEmpty()) {
                document.getElementById('error-signature').style.display = 'block';
                errorMessage.textContent = 'Please provide your signature before submitting.';
                errorMessage.style.display = 'block';
                return;
            }
            const signatureData = signaturePad.toDataURL();
            document.getElementById('signature_data').value = signatureData;
            // Show loading state
            const submitBtn = document.getElementById('submitBtn');
            const originalText = submitBtn.textContent;
            submitBtn.textContent = 'Sending...';
            submitBtn.disabled = true;
            submitBtn.classList.add('loading');
            // Create FormData object
            const formData = new FormData(this);
            // Send the form data via AJAX
            fetch('process_form.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                console.log('Server response:', data);
                if (data.status === 'success') {
                    // Show success message
                    document.getElementById('successMessage').style.display = 'block';
                    document.querySelector('.tab-content-container').style.display = 'none';
                    document.querySelector('.tab-navigation').style.display = 'none';
                } else {
                    // Show error message
                    errorMessage.textContent = 'Error: ' + (data.message || 'Unknown error occurred');
                    errorMessage.style.display = 'block';
                    submitBtn.textContent = originalText;
                    submitBtn.disabled = false;
                    submitBtn.classList.remove('loading');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                errorMessage.textContent = 'An error occurred while submitting the form: ' + error.message + '. Please check your console for details.';
                errorMessage.style.display = 'block';
                submitBtn.textContent = originalText;
                submitBtn.disabled = false;
                submitBtn.classList.remove('loading');
            });
        });
        
        // Navigate by clicking on tabs
        tabItems.forEach((item, index) => {
            item.addEventListener('click', function() {
                if (validateTab(currentTab)) {
                    currentTab = index;
                    showTab(currentTab);
                }
            });
        });
        
        // Add event listeners to remove error styling when user starts typing
        document.querySelectorAll('input[required], textarea[required]').forEach(field => {
            field.addEventListener('input', function() {
                this.style.borderColor = '#ddd';
                const errorId = 'error-' + this.id;
                const errorElement = document.getElementById(errorId);
                if (errorElement) {
                    errorElement.style.display = 'none';
                }
                errorMessage.style.display = 'none';
            });
        });
        
        // Add event listeners for radio buttons and checkboxes
        document.querySelectorAll('input[type="radio"], input[type="checkbox"]').forEach(input => {
            input.addEventListener('change', function() {
                errorMessage.style.display = 'none';
            });
        });
    </script>
</body>
</html>
```

Les corrections principales apportées :

1. **Correction du nom de champ** : J'ai changé `id="role"` à `id="role_project"` dans la section "Project Information" pour éviter les conflits avec le champ `name="role[]"` dans la section "Company Current Situation".

2. **Amélioration de la validation** : La fonction `validateTab` a été améliorée pour mieux gérer les différents types de champs (texte, textarea, checkbox, radio).

3. **Correction de la validation des boutons radio** : La validation des groupes de boutons radio est maintenant plus robuste.

4. **Meilleure gestion des erreurs** : Les messages d'erreur sont maintenant correctement affichés et masqués.

Ces corrections devraient résoudre le problème de navigation entre les onglets. Vous devriez maintenant pouvoir passer d'un onglet à l'autre sans problème une fois que tous les champs requis sont remplis.