```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Feasibility Study Application Form</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Arial', sans-serif;
        }
        .card {
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .card-header {
            background-color: #000;
            color: white;
            text-align: center;
            padding: 1.5rem;
            border-bottom: 3px solid #007bff;
        }
        .tabs-container {
            background-color: white;
            border-radius: 0 0 15px 15px;
            overflow: hidden;
        }
        .tabs-nav {
            display: flex;
            flex-wrap: wrap;
            background-color: #f1f1f1;
            padding: 0.5rem;
            overflow-x: auto;
        }
        .tab-item {
            padding: 0.75rem 1rem;
            cursor: pointer;
            border-radius: 10px;
            margin: 0.25rem;
            font-size: 0.85rem;
            transition: all 0.3s ease;
            white-space: nowrap;
        }
        .tab-item.active {
            background-color: #007bff;
            color: white;
            font-weight: bold;
        }
        .tab-item:hover:not(.active) {
            background-color: #e9ecef;
        }
        .tab-content-container {
            padding: 2rem;
            min-height: 400px;
        }
        .tab-content {
            display: none;
        }
        .tab-content.active {
            display: block;
            animation: fadeIn 0.5s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .tab-header h3 {
            color: #007bff;
            border-bottom: 2px solid #007bff;
            padding-bottom: 0.5rem;
            margin-bottom: 1.5rem;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-control {
            border-radius: 8px;
            border: 1px solid #ced4da;
            padding: 0.75rem 1rem;
        }
        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }
        .checkbox-group {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 0.5rem;
            margin-top: 0.5rem;
        }
        .form-check {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        .custom-file-upload {
            display: inline-block;
            cursor: pointer;
            background-color: #f8f9fa;
            padding: 0.75rem 1rem;
            border: 1px dashed #007bff;
            border-radius: 8px;
            color: #007bff;
            transition: all 0.3s ease;
            text-align: center;
        }
        .custom-file-upload:hover {
            background-color: #007bff;
            color: white;
        }
        .hidden-input {
            display: none;
        }
        .file-name {
            margin-left: 0.5rem;
            font-size: 0.9rem;
            color: #6c757d;
        }
        .tab-navigation {
            display: flex;
            justify-content: space-between;
            padding: 1rem 2rem 2rem;
            background-color: white;
            border-top: 1px solid #dee2e6;
        }
        .btn {
            border-radius: 8px;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
        }
        .error-message {
            color: #dc3545;
            font-size: 0.875rem;
            margin-top: 0.25rem;
            display: none;
        }
        .form-group.has-error .form-control {
            border-color: #dc3545;
        }
        .form-group.has-error label {
            color: #dc3545;
        }
        .success-message {
            display: none;
            background-color: #d4edda;
            color: #155724;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            border: 1px solid #c3e6cb;
        }
        .error-alert {
            display: none;
            background-color: #f8d7da;
            color: #721c24;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            border: 1px solid #f5c6cb;
        }
        @media (max-width: 768px) {
            .checkbox-group {
                grid-template-columns: 1fr;
            }
            .tab-item {
                min-width: 120px;
            }
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row mb-5">
            <div class="col-12">
                <div class="card border-0 shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2 class="mb-0">Feasibility Study Application Form</h2>
                        <p class="mb-0">Complete all sections to submit your application</p>
                    </div>
                    <div class="card-body p-0">
                        <!-- Success and Error Messages -->
                        <div class="success-message" id="successMessage">
                            Your application has been submitted successfully. We will contact you soon.
                        </div>
                        <div class="error-alert" id="errorMessage">
                            An error occurred while submitting your application. Please try again.
                        </div>
                        
                        <!-- Tabs Navigation -->
                        <div class="tabs-container">
                            <div class="tabs-nav" id="tabsNav">
                                <div class="tab-item active" data-tab="0">Applicant Information</div>
                                <div class="tab-item" data-tab="1">Company Current Situation</div>
                                <div class="tab-item" data-tab="2">Project Information</div>
                                <div class="tab-item" data-tab="3">Funding</div>
                                <div class="tab-item" data-tab="4">Data</div>
                                <div class="tab-item" data-tab="5">Methodology</div>
                                <div class="tab-item" data-tab="6">Architectural Conception</div>
                                <div class="tab-item" data-tab="7">Economic Study</div>
                                <div class="tab-item" data-tab="8">Financial Study</div>
                                <div class="tab-item" data-tab="9">Impact</div>
                                <div class="tab-item" data-tab="10">Time Frame</div>
                                <div class="tab-item" data-tab="11">Resources</div>
                                <div class="tab-item" data-tab="12">Consultant's Profile</div>
                                <div class="tab-item" data-tab="13">Additional Expertise</div>
                                <div class="tab-item" data-tab="14">Endorsements</div>
                                <div class="tab-item" data-tab="15">Budget</div>
                                <div class="tab-item" data-tab="16">Results</div>
                                <div class="tab-item" data-tab="17">Next Step</div>
                                <div class="tab-item" data-tab="18">Additional Information</div>
                                <div class="tab-item" data-tab="19">Applicant's Approval</div>
                            </div>
                            
                            <!-- Tab Content -->
                            <div class="tab-content-container">
                                <!-- Tab 1: Applicant Information -->
                                <div class="tab-content active" id="tab-0">
                                    <div class="tab-header">
                                        <h3>1. APPLICANT INFORMATION</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="applicantName">Applicant's Name(s):</label>
                                                    <input type="text" id="applicantName" name="applicantName" class="form-control" required>
                                                    <div class="error-message" id="error-applicantName">This field is required</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="applicantSurname">Applicant's Surname:</label>
                                                    <input type="text" id="applicantSurname" name="applicantSurname" class="form-control" required>
                                                    <div class="error-message" id="error-applicantSurname">This field is required</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="country">Country:</label>
                                                    <input type="text" id="country" name="country" class="form-control" required>
                                                    <div class="error-message" id="error-country">This field is required</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="city">City:</label>
                                                    <input type="text" id="city" name="city" class="form-control" required>
                                                    <div class="error-message" id="error-city">This field is required</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="street">Street:</label>
                                                    <input type="text" id="street" name="street" class="form-control" required>
                                                    <div class="error-message" id="error-street">This field is required</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="zip">Zip:</label>
                                                    <input type="text" id="zip" name="zip" class="form-control" required>
                                                    <div class="error-message" id="error-zip">This field is required</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="phoneNumber">Phone Number(s):</label>
                                                    <input type="tel" id="phoneNumber" name="phoneNumber" class="form-control" required>
                                                    <div class="error-message" id="error-phoneNumber">This field is required</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="email">Email Address:</label>
                                                    <input type="email" id="email" name="email" class="form-control" required>
                                                    <div class="error-message" id="error-email">Please enter a valid email address</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 2: Company Current Situation -->
                                <div class="tab-content" id="tab-1">
                                    <div class="tab-header">
                                        <h3>2. COMPANY CURRENT SITUATION</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="currentState">What is the company's current state of affairs?</label>
                                            <textarea id="currentState" name="currentState" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-currentState">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="businessChallenges">What business challenges is the applicant facing?</label>
                                            <textarea id="businessChallenges" name="businessChallenges" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-businessChallenges">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="businessOpportunities">What business opportunities is the applicant viewing?</label>
                                            <textarea id="businessOpportunities" name="businessOpportunities" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-businessOpportunities">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label>Specify the company's role in the project:</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="owner" name="role[]" value="Owner" class="form-check-input">
                                                    <label class="form-check-label" for="owner">Owner</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="subcontractor" name="role[]" value="Subcontractor" class="form-check-input">
                                                    <label class="form-check-label" for="subcontractor">Subcontractor</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-role">Please select at least one option</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 3: Project Information -->
                                <div class="tab-content" id="tab-2">
                                    <div class="tab-header">
                                        <h3>3. PROJECT INFORMATION</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="projectPurpose">What is the purpose of the feasibility study?</label>
                                            <textarea id="projectPurpose" name="projectPurpose" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-projectPurpose">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="projectGoals">What are the applicant's goals and objectives?</label>
                                            <textarea id="projectGoals" name="projectGoals" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-projectGoals">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label>Is the applicant the owner of the project?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="radio" id="projectOwnerYes" name="projectOwner" value="Yes" class="form-check-input" required>
                                                    <label class="form-check-label" for="projectOwnerYes">Yes</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio" id="projectOwnerNo" name="projectOwner" value="No" class="form-check-input" required>
                                                    <label class="form-check-label" for="projectOwnerNo">No</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-projectOwner">Please select an option</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="role_project">If the applicant is not the owner, what is their role?</label>
                                            <textarea id="role_project" name="role_project" class="form-control" rows="3"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="projectLocation">Please specify the location(s) of the project:</label>
                                            <input type="text" id="projectLocation" name="projectLocation" class="form-control" required>
                                            <div class="error-message" id="error-projectLocation">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label>Is the applicant the owner of the land where the project will be located?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="radio" id="landOwnerYes" name="landOwner" value="Yes" class="form-check-input" required>
                                                    <label class="form-check-label" for="landOwnerYes">Yes</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio" id="landOwnerNo" name="landOwner" value="No" class="form-check-input" required>
                                                    <label class="form-check-label" for="landOwnerNo">No</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-landOwner">Please select an option</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 4: Funding -->
                                <div class="tab-content" id="tab-3">
                                    <div class="tab-header">
                                        <h3>4. FUNDING</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="fundingSource">Please specify the origin of the funding:</label>
                                            <input type="text" id="fundingSource" name="fundingSource" class="form-control" required>
                                            <div class="error-message" id="error-fundingSource">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label>Loan:</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="fundingType" name="fundingType" value="Loan" class="form-check-input">
                                                    <label class="form-check-label" for="fundingType">Loan</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="loanDetails">Please specify the amount and terms (if applicable):</label>
                                            <textarea id="loanDetails" name="loanDetails" class="form-control" rows="4"></textarea>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 5: Data -->
                                <div class="tab-content" id="tab-4">
                                    <div class="tab-header">
                                        <h3>5. DATA</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="dataCollection">What data will be collected and analyzed?</label>
                                            <textarea id="dataCollection" name="dataCollection" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-dataCollection">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label>What type of data will be needed for the feasibility study?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="quantitative" name="dataType[]" value="Quantitative" class="form-check-input">
                                                    <label class="form-check-label" for="quantitative">Quantitative</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="qualitative" name="dataType[]" value="Qualitative" class="form-check-input">
                                                    <label class="form-check-label" for="qualitative">Qualitative</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-dataType">Please select at least one option</div>
                                        </div>
                                        <div class="form-group">
                                            <label>Will the applicant provide data, or will it need to be collected by GIFAM's team?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="applicantData" name="dataSource[]" value="The applicant" class="form-check-input">
                                                    <label class="form-check-label" for="applicantData">The applicant</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="gifamTeamData" name="dataSource[]" value="GIFAM's team" class="form-check-input">
                                                    <label class="form-check-label" for="gifamTeamData">GIFAM's team</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-dataSource">Please select at least one option</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 6: Methodology -->
                                <div class="tab-content" id="tab-5">
                                    <div class="tab-header">
                                        <h3>6. METHODOLOGY</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="methodology">How will the feasibility study be conducted?</label>
                                            <textarea id="methodology" name="methodology" class="form-control" rows="6" required></textarea>
                                            <div class="error-message" id="error-methodology">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 7: Architectural Conception -->
                                <div class="tab-content" id="tab-6">
                                    <div class="tab-header">
                                        <h3>7. ARCHITECTURAL CONCEPTION</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="checkbox-group">
                                            <div class="form-check">
                                                <input type="checkbox" id="architecturalAnalysis" name="architecturalConception[]" value="Architectural Technical Analysis" class="form-check-input">
                                                <label class="form-check-label" for="architecturalAnalysis">Architectural Technical Analysis</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="architecturalPlans" name="architecturalConception[]" value="Architectural Plans" class="form-check-input">
                                                <label class="form-check-label" for="architecturalPlans">Architectural Plans</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="elevationSections" name="architecturalConception[]" value="Elevation and Sections" class="form-check-input">
                                                <label class="form-check-label" for="elevationSections">Elevation and Sections</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="groundPlan" name="architecturalConception[]" value="Ground Plan" class="form-check-input">
                                                <label class="form-check-label" for="groundPlan">Ground Plan</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="sketchUp" name="architecturalConception[]" value="Sketch up" class="form-check-input">
                                                <label class="form-check-label" for="sketchUp">Sketch up</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="3dModeling" name="architecturalConception[]" value="3D modeling" class="form-check-input">
                                                <label class="form-check-label" for="3dModeling">3D modeling</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="3dVideo" name="architecturalConception[]" value="3D Video" class="form-check-input">
                                                <label class="form-check-label" for="3dVideo">3D Video</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="rendering" name="architecturalConception[]" value="Rendering" class="form-check-input">
                                                <label class="form-check-label" for="rendering">Rendering</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 8: Economic Study -->
                                <div class="tab-content" id="tab-7">
                                    <div class="tab-header">
                                        <h3>8. ECONOMIC STUDY</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="checkbox-group">
                                            <div class="form-check">
                                                <input type="checkbox" id="marketStudy" name="economicStudy[]" value="Market Study" class="form-check-input">
                                                <label class="form-check-label" for="marketStudy">Market Study</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="industryInsight" name="economicStudy[]" value="Industry Insight" class="form-check-input">
                                                <label class="form-check-label" for="industryInsight">Industry Insight</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="demandAnalysis" name="economicStudy[]" value="Demand analysis" class="form-check-input">
                                                <label class="form-check-label" for="demandAnalysis">Demand analysis</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="supplyAnalysis" name="economicStudy[]" value="Supply-side analysis" class="form-check-input">
                                                <label class="form-check-label" for="supplyAnalysis">Supply-side analysis</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="competitiveAnalysis" name="economicStudy[]" value="Competitive analysis" class="form-check-input">
                                                <label class="form-check-label" for="competitiveAnalysis">Competitive analysis</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="pestleAnalysis" name="economicStudy[]" value="PESTLE Analysis" class="form-check-input">
                                                <label class="form-check-label" for="pestleAnalysis">PESTLE Analysis</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="swotAnalysis" name="economicStudy[]" value="SWOT Analysis" class="form-check-input">
                                                <label class="form-check-label" for="swotAnalysis">SWOT Analysis</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="marketingStrategy" name="economicStudy[]" value="Marketing Strategy" class="form-check-input">
                                                <label class="form-check-label" for="marketingStrategy">Marketing Strategy</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="operationalFeasibility" name="economicStudy[]" value="Operational feasibility" class="form-check-input">
                                                <label class="form-check-label" for="operationalFeasibility">Operational feasibility</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="organizationalAnalysis" name="economicStudy[]" value="Organizational Analysis" class="form-check-input">
                                                <label class="form-check-label" for="organizationalAnalysis">Organizational Analysis</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 9: Financial Study -->
                                <div class="tab-content" id="tab-8">
                                    <div class="tab-header">
                                        <h3>9. FINANCIAL STUDY</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="checkbox-group">
                                            <div class="form-check">
                                                <input type="checkbox" id="financialOverview" name="financialStudy[]" value="Financial Overview" class="form-check-input">
                                                <label class="form-check-label" for="financialOverview">Financial Overview</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="loanAmortizationTable" name="financialStudy[]" value="Loan Amortization Table" class="form-check-input">
                                                <label class="form-check-label" for="loanAmortizationTable">Loan Amortization Table</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="capexOpexFunding" name="financialStudy[]" value="Capex & Opex funding" class="form-check-input">
                                                <label class="form-check-label" for="capexOpexFunding">Capex & Opex funding</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="fundingPeriods" name="financialStudy[]" value="Funding Periods" class="form-check-input">
                                                <label class="form-check-label" for="fundingPeriods">Funding Periods</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="investmentPlan" name="financialStudy[]" value="Investment Plan" class="form-check-input">
                                                <label class="form-check-label" for="investmentPlan">Investment Plan</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="fixedAssetsDepreciation" name="financialStudy[]" value="Fixed Assets Depreciation Table" class="form-check-input">
                                                <label class="form-check-label" for="fixedAssetsDepreciation">Fixed Assets Depreciation Table</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="operatingExpensesForecasting" name="financialStudy[]" value="Operating Expenses Forecasting" class="form-check-input">
                                                <label class="form-check-label" for="operatingExpensesForecasting">Operating Expenses Forecasting</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="salesForecasting" name="financialStudy[]" value="Sales Forecasting" class="form-check-input">
                                                <label class="form-check-label" for="salesForecasting">Sales Forecasting</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="incomeStatement" name="financialStudy[]" value="Income Statement" class="form-check-input">
                                                <label class="form-check-label" for="incomeStatement">Income Statement</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="balanceSheet" name="financialStudy[]" value="Balance Sheet" class="form-check-input">
                                                <label class="form-check-label" for="balanceSheet">Balance Sheet</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="cashFlowStatement" name="financialStudy[]" value="Cash-Flow Statement" class="form-check-input">
                                                <label class="form-check-label" for="cashFlowStatement">Cash-Flow Statement</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="financialRatios" name="financialStudy[]" value="Financial Ratios Analysis" class="form-check-input">
                                                <label class="form-check-label" for="financialRatios">Financial Ratios Analysis</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 10: Impact -->
                                <div class="tab-content" id="tab-9">
                                    <div class="tab-header">
                                        <h3>10. IMPACT</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="checkbox-group">
                                            <div class="form-check">
                                                <input type="checkbox" id="economicImpact" name="impact[]" value="Economic impact" class="form-check-input">
                                                <label class="form-check-label" for="economicImpact">Economic impact (e.g., job creation, GDP growth)</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="socialImpact" name="impact[]" value="Social impact" class="form-check-input">
                                                <label class="form-check-label" for="socialImpact">Social impact (e.g., education, healthcare)</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" id="environmentalImpact" name="impact[]" value="Environmental impact" class="form-check-input">
                                                <label class="form-check-label" for="environmentalImpact">Environmental impact (e.g., sustainability, carbon footprint)</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 11: Time Frame -->
                                <div class="tab-content" id="tab-10">
                                    <div class="tab-header">
                                        <h3>11. TIME FRAME</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="timeline">What is the timeline for the feasibility study?</label>
                                            <input type="text" id="timeline" name="timeline" class="form-control" required>
                                            <div class="error-message" id="error-timeline">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="startDate">When will it begin?</label>
                                            <input type="date" id="startDate" name="startDate" class="form-control" required>
                                            <div class="error-message" id="error-startDate">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="deliveryDate">What is the deadline for delivery?</label>
                                            <input type="date" id="deliveryDate" name="deliveryDate" class="form-control" required>
                                            <div class="error-message" id="error-deliveryDate">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 12: Resources -->
                                <div class="tab-content" id="tab-11">
                                    <div class="tab-header">
                                        <h3>12. RESOURCES</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label>Which resources will be needed for the study?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="checkbox" id="gifamTeam" name="resources[]" value="GIFAM's Team" class="form-check-input">
                                                    <label class="form-check-label" for="gifamTeam">GIFAM's Team</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="checkbox" id="thirdParty" name="resources[]" value="Third Party" class="form-check-input">
                                                    <label class="form-check-label" for="thirdParty">Third Party</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-resources">Please select at least one option</div>
                                        </div>
                                        <div class="form-group">
                                            <label>Will additional staff or consultants be needed?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="radio" id="additionalStaffYes" name="additionalStaff" value="Yes" class="form-check-input" required>
                                                    <label class="form-check-label" for="additionalStaffYes">Yes</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio" id="additionalStaffNo" name="additionalStaff" value="No" class="form-check-input" required>
                                                    <label class="form-check-label" for="additionalStaffNo">No</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-additionalStaff">Please select an option</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 13: Consultant's Profile -->
                                <div class="tab-content" id="tab-12">
                                    <div class="tab-header">
                                        <h3>13. CONSULTANT'S PROFILE</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="consultantProfile">Please select the consultant's profile needed for conducting the feasibility study:</label>
                                            <input type="text" id="consultantProfile" name="consultantProfile" class="form-control" required>
                                            <div class="error-message" id="error-consultantProfile">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 14: Additional Expertise -->
                                <div class="tab-content" id="tab-13">
                                    <div class="tab-header">
                                        <h3>14. ADDITIONAL EXPERTISE</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label>Please specify if any additional expertise shall be needed for the project.</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="radio" id="additionalExpertiseYes" name="additionalExpertise" value="Yes" class="form-check-input" required>
                                                    <label class="form-check-label" for="additionalExpertiseYes">Yes</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio" id="additionalExpertiseNo" name="additionalExpertise" value="No" class="form-check-input" required>
                                                    <label class="form-check-label" for="additionalExpertiseNo">No</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-additionalExpertise">Please select an option</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="expertiseArea">If yes, please indicate the area for which additional expertise would be needed:</label>
                                            <input type="text" id="expertiseArea" name="expertiseArea" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 15: Endorsements -->
                                <div class="tab-content" id="tab-14">
                                    <div class="tab-header">
                                        <h3>15. ENDORSEMENTS</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label>Does the feasibility study need endorsements from a certified expert corporation?</label>
                                            <div class="checkbox-group">
                                                <div class="form-check">
                                                    <input type="radio" id="endorsementsYes" name="endorsements" value="Yes" class="form-check-input" required>
                                                    <label class="form-check-label" for="endorsementsYes">Yes</label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio" id="endorsementsNo" name="endorsements" value="No" class="form-check-input" required>
                                                    <label class="form-check-label" for="endorsementsNo">No</label>
                                                </div>
                                            </div>
                                            <div class="error-message" id="error-endorsements">Please select an option</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 16: Budget -->
                                <div class="tab-content" id="tab-15">
                                    <div class="tab-header">
                                        <h3>16. BUDGET</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="budget">What is the applicant's budget for the feasibility study?</label>
                                            <input type="text" id="budget" name="budget" class="form-control" required>
                                            <div class="error-message" id="error-budget">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="budgetFinancing">How will the feasibility study cost be financed?</label>
                                            <input type="text" id="budgetFinancing" name="budgetFinancing" class="form-control" required>
                                            <div class="error-message" id="error-budgetFinancing">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 17: Results -->
                                <div class="tab-content" id="tab-16">
                                    <div class="tab-header">
                                        <h3>17. RESULTS</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="resultsPresentation">How will the results of the feasibility study be presented?</label>
                                            <input type="text" id="resultsPresentation" name="resultsPresentation" class="form-control" required>
                                            <div class="error-message" id="error-resultsPresentation">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 18: Next Step -->
                                <div class="tab-content" id="tab-17">
                                    <div class="tab-header">
                                        <h3>18. NEXT STEP</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="nextStepIfViable">If the feasibility study indicates the project is viable, what will be the next steps?</label>
                                            <textarea id="nextStepIfViable" name="nextStepIfViable" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-nextStepIfViable">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="nextStepIfNotViable">If the feasibility study indicates the project is not viable, what will be the next steps?</label>
                                            <textarea id="nextStepIfNotViable" name="nextStepIfNotViable" class="form-control" rows="4" required></textarea>
                                            <div class="error-message" id="error-nextStepIfNotViable">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 19: Additional Information -->
                                <div class="tab-content" id="tab-18">
                                    <div class="tab-header">
                                        <h3>19. ADDITIONAL INFORMATION</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="additionalInformation">Please provide any additional information relevant to your project:</label>
                                            <textarea id="additionalInformation" name="additionalInformation" class="form-control" rows="6"></textarea>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Tab 20: Applicant's Approval -->
                                <div class="tab-content" id="tab-19">
                                    <div class="tab-header">
                                        <h3>20. APPLICANT'S APPROVAL</h3>
                                    </div>
                                    <div class="form-section">
                                        <div class="form-group">
                                            <label for="applicantNameApproval">Applicant's full name:</label>
                                            <input type="text" id="applicantNameApproval" name="applicantNameApproval" class="form-control" required>
                                            <div class="error-message" id="error-applicantNameApproval">This field is required</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="Uploadyourproject">Upload your project:</label>
                                            <label class="custom-file-upload">
                                                <input type="file" id="Uploadyourproject" name="Uploadyourproject" class="hidden-input" onchange="updateFileName(this)">
                                                📁 Upload your project
                                            </label>
                                            <span class="file-name" id="file-name">No file selected</span>
                                        </div>
                                        <div class="form-group">
                                            <label for="signature">Signature:</label>
                                            <div id="signature-pad" class="mb-2" style="border:1px solid #ccc; border-radius:4px;">
                                                <canvas id="signature-canvas" width="400" height="150" style="background:#fff;"></canvas>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="clearSignature()">Clear</button>
                                            <input type="hidden" name="signature_data" id="signature_data">
                                            <div class="error-message" id="error-signature">Please provide your signature</div>
                                        </div>
                                        <div class="form-group">
                                            <label for="approvalDate">Date:</label>
                                            <input type="date" id="approvalDate" name="approvalDate" class="form-control" required>
                                            <div class="error-message" id="error-approvalDate">This field is required</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Navigation Buttons -->
                                <div class="tab-navigation">
                                    <button type="button" class="btn btn-secondary" id="prevBtn" onclick="previousTab()">Previous</button>
                                    <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextTab()">Next</button>
                                    <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">Submit Application</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Tab navigation
        let currentTab = 0;
        const totalTabs = 20;
        
        function showTab(n) {
            const tabs = document.getElementsByClassName("tab-content");
            const tabItems = document.getElementsByClassName("tab-item");
            
            for (let i = 0; i < tabs.length; i++) {
                tabs[i].classList.remove("active");
            }
            for (let i = 0; i < tabItems.length; i++) {
                tabItems[i].classList.remove("active");
            }
            
            tabs[n].classList.add("active");
            tabItems[n].classList.add("active");
            
            // Update navigation buttons
            if (n === 0) {
                document.getElementById("prevBtn").style.display = "none";
            } else {
                document.getElementById("prevBtn").style.display = "inline-block";
            }
            
            if (n === totalTabs - 1) {
                document.getElementById("nextBtn").style.display = "none";
                document.getElementById("submitBtn").style.display = "inline-block";
            } else {
                document.getElementById("nextBtn").style.display = "inline-block";
                document.getElementById("submitBtn").style.display = "none";
            }
            
            // Scroll to top of form
            document.querySelector('.tabs-container').scrollIntoView({ behavior: 'smooth' });
        }
        
        function nextTab() {
            if (validateForm()) {
                currentTab++;
                showTab(currentTab);
            }
        }
        
        function previousTab() {
            currentTab--;
            showTab(currentTab);
        }
        
        // Form validation
        function validateForm() {
            let valid = true;
            const currentTabContent = document.getElementsByClassName("tab-content")[currentTab];
            const inputs = currentTabContent.querySelectorAll("input[required], textarea[required]");
            
            // Remove previous error states
            const errorMessages = currentTabContent.querySelectorAll(".error-message");
            const formGroups = currentTabContent.querySelectorAll(".form-group");
            
            errorMessages.forEach(msg => msg.style.display = "none");
            formGroups.forEach(group => group.classList.remove("has-error"));
            
            // Validate inputs
            inputs.forEach(input => {
                if (input.type === "email") {
                    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                    if (!emailRegex.test(input.value)) {
                        showError(input, "Please enter a valid email address");
                        valid = false;
                    }
                } else if (input.type === "checkbox") {
                    const checkboxes = currentTabContent.querySelectorAll(`input[name="${input.name}"]`);
                    const checked = Array.from(checkboxes).some(cb => cb.checked);
                    if (!checked) {
                        const errorId = `error-${input.name.replace('[]', '')}`;
                        document.getElementById(errorId).style.display = "block";
                        valid = false;
                    }
                } else if (input.type === "radio") {
                    const radios = currentTabContent.querySelectorAll(`input[name="${input.name}"]`);
                    const checked = Array.from(radios).some(r => r.checked);
                    if (!checked) {
                        const errorId = `error-${input.name}`;
                        document.getElementById(errorId).style.display = "block";
                        valid = false;
                    }
                } else {
                    if (!input.value.trim()) {
                        showError(input, "This field is required");
                        valid = false;
                    }
                }
            });
            
            // Special validation for role checkboxes in tab 1
            if (currentTab === 1) {
                const roleCheckboxes = document.querySelectorAll('input[name="role[]"]');
                const roleChecked = Array.from(roleCheckboxes).some(cb => cb.checked);
                if (!roleChecked) {
                    document.getElementById("error-role").style.display = "block";
                    valid = false;
                }
            }
            
            // Special validation for data type checkboxes in tab 4
            if (currentTab === 4) {
                const dataTypeCheckboxes = document.querySelectorAll('input[name="dataType[]"]');
                const dataTypeChecked = Array.from(dataTypeCheckboxes).some(cb => cb.checked);
                if (!dataTypeChecked) {
                    document.getElementById("error-dataType").style.display = "block";
                    valid = false;
                }
                
                const dataSourceCheckboxes = document.querySelectorAll('input[name="dataSource[]"]');
                const dataSourceChecked = Array.from(dataSourceCheckboxes).some(cb => cb.checked);
                if (!dataSourceChecked) {
                    document.getElementById("error-dataSource").style.display = "block";
                    valid = false;
                }
            }
            
            // Special validation for resources checkboxes in tab 11
            if (currentTab === 11) {
                const resourcesCheckboxes = document.querySelectorAll('input[name="resources[]"]');
                const resourcesChecked = Array.from(resourcesCheckboxes).some(cb => cb.checked);
                if (!resourcesChecked) {
                    document.getElementById("error-resources").style.display = "block";
                    valid = false;
                }
            }
            
            // Validate signature in last tab
            if (currentTab === 19) {
                const signaturePad = window.signaturePad;
                if (!signaturePad || signaturePad.isEmpty()) {
                    document.getElementById("error-signature").style.display = "block";
                    valid = false;
                }
            }
            
            return valid;
        }
        
        function showError(input, message) {
            const errorId = `error-${input.id}`;
            const errorMessage = document.getElementById(errorId);
            if (errorMessage) {
                errorMessage.textContent = message;
                errorMessage.style.display = "block";
            }
            const formGroup = input.closest(".form-group");
            if (formGroup) {
                formGroup.classList.add("has-error");
            }
        }
        
        // File upload handling
        function updateFileName(input) {
            const fileName = input.files[0] ? input.files[0].name : "No file selected";
            document.getElementById("file-name").textContent = fileName;
        }
        
        // Signature pad functionality
        let signaturePad;
        
        function setupSignaturePad() {
            const canvas = document.getElementById('signature-canvas');
            const ctx = canvas.getContext('2d');
            
            // Make canvas high DPI for better quality
            const rect = canvas.getBoundingClientRect();
            canvas.width = rect.width * 2;
            canvas.height = rect.height * 2;
            ctx.scale(2, 2);
            
            signaturePad = new SignaturePad(canvas, {
                backgroundColor: 'rgb(255, 255, 255)',
                penColor: 'rgb(0, 0, 0)',
                minWidth: 0.5,
                maxWidth: 2.5
            });
            
            // Clear signature data when clearing
            window.clearSignature = function() {
                signaturePad.clear();
                document.getElementById('signature_data').value = '';
            };
            
            // Update hidden field when signature changes
            signaturePad.addEventListener("endStroke", () => {
                if (!signaturePad.isEmpty()) {
                    document.getElementById('signature_data').value = signaturePad.toDataURL();
                } else {
                    document.getElementById('signature_data').value = '';
                }
            });
        }
        
        // Form submission
        document.addEventListener('DOMContentLoaded', function() {
            showTab(currentTab);
            setupSignaturePad();
            
            // Make tabs clickable
            const tabItems = document.querySelectorAll('.tab-item');
            tabItems.forEach((item, index) => {
                item.addEventListener('click', () => {
                    // Only allow jumping to previous tabs
                    if (index < currentTab) {
                        currentTab = index;
                        showTab(currentTab);
                    }
                });
            });
            
            // Form submission
            const form = document.querySelector('form');
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Validate final tab
                if (!validateForm()) {
                    return;
                }
                
                // Collect form data
                const formData = new FormData(this);
                
                // Show loading state
                const submitBtn = document.getElementById('submitBtn');
                const originalText = submitBtn.textContent;
                submitBtn.textContent = 'Submitting...';
                submitBtn.disabled = true;
                
                // Send form data via fetch
                fetch('process_forms.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    // Restore button state
                    submitBtn.textContent = originalText;
                    submitBtn.disabled = false;
                    
                    // Show success or error message
                    const successMsg = document.getElementById('successMessage');
                    const errorMsg = document.getElementById('errorMessage');
                    
                    if (data.status === 'success') {
                        successMsg.style.display = 'block';
                        errorMsg.style.display = 'none';
                        form.reset();
                        if (signaturePad) {
                            signaturePad.clear();
                        }
                        // Reset file name display
                        document.getElementById("file-name").textContent = "No file selected";
                        // Reset to first tab
                        currentTab = 0;
                        showTab(currentTab);
                    } else {
                        successMsg.style.display = 'none';
                        errorMsg.style.display = 'block';
                    }
                })
                .catch(error => {
                    // Restore button state
                    submitBtn.textContent = originalText;
                    submitBtn.disabled = false;
                    
                    // Show error message
                    const successMsg = document.getElementById('successMessage');
                    const errorMsg = document.getElementById('errorMessage');
                    successMsg.style.display = 'none';
                    errorMsg.style.display = 'block';
                    console.error('Error:', error);
                });
            });
        });
        
        // Handle window resize for signature pad
        window.addEventListener('resize', function() {
            if (signaturePad) {
                const canvas = document.getElementById('signature-canvas');
                const rect = canvas.getBoundingClientRect();
                canvas.width = rect.width * 2;
                canvas.height = rect.height * 2;
                const ctx = canvas.getContext('2d');
                ctx.scale(2, 2);
                
                // Redraw signature if it exists
                if (!signaturePad.isEmpty()) {
                    const data = signaturePad.toData();
                    signaturePad.clear();
                    signaturePad.fromData(data);
                }
            }
        });
    </script>
</body>
</html>
```