<?php

// process_form.php - Traitement du formulaire d'étude de faisabilité



// Configuration email

define('RECIPIENT_EMAIL', 'info@gifam.eu'); // Remplacez par votre email

define('SENDER_EMAIL', 'info@gifam.eu'); // Email expéditeur

define('SUBJECT', 'Nouvelle demande d\'étude de faisabilité');



// Fonction pour nettoyer les données

function sanitizeInput($data) {

    return htmlspecialchars(strip_tags(trim($data)));

}



// Fonction pour traiter les checkboxes

function processCheckboxes($checkboxArray) {

    if (is_array($checkboxArray)) {

        return implode(', ', array_map('sanitizeInput', $checkboxArray));

    }

    return '';

}



// Fonction pour gérer l'upload de fichier

function handleFileUpload() {

    if (isset($_FILES['Uploadyourproject']) && $_FILES['Uploadyourproject']['error'] == 0) {

        $uploadDir = 'uploads/';

        

        // Créer le dossier uploads s'il n'existe pas

        if (!is_dir($uploadDir)) {

            mkdir($uploadDir, 0755, true);

        }

        

        $fileName = basename($_FILES['Uploadyourproject']['name']);

        $targetPath = $uploadDir . uniqid() . '_' . $fileName;

        

        // Vérifier la taille du fichier (max 10MB)

        if ($_FILES['Uploadyourproject']['size'] > 10 * 1024 * 1024) {

            return ['error' => 'Fichier trop volumineux (max 10MB)'];

        }

        

        // Types de fichiers autorisés

        $allowedTypes = ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', 'txt', 'jpg', 'jpeg', 'png', 'zip', 'rar'];

        $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

        

        if (!in_array($fileExtension, $allowedTypes)) {

            return ['error' => 'Type de fichier non autorisé'];

        }

        

        if (move_uploaded_file($_FILES['Uploadyourproject']['tmp_name'], $targetPath)) {

            return ['success' => true, 'path' => $targetPath, 'name' => $fileName];

        } else {

            return ['error' => 'Erreur lors de l\'upload du fichier'];

        }

    }

    return ['success' => false];

}



// Vérifier si le formulaire a été soumis

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    try {

        // Traitement de l'upload de fichier

        $fileUpload = handleFileUpload();

        

        // Collecte et nettoyage des données

        $formData = [

            // Section 1: Informations du demandeur

            'applicant_name' => sanitizeInput($_POST['applicantName'] ?? ''),

            'applicant_surname' => sanitizeInput($_POST['applicantSurname'] ?? ''),

            'country' => sanitizeInput($_POST['country'] ?? ''),

            'city' => sanitizeInput($_POST['city'] ?? ''),

            'street' => sanitizeInput($_POST['street'] ?? ''),

            'zip' => sanitizeInput($_POST['zip'] ?? ''),

            'phone_number' => sanitizeInput($_POST['phoneNumber'] ?? ''),

            'email' => sanitizeInput($_POST['email'] ?? ''),

            

            // Section 2: Situation actuelle de l'entreprise

            'current_state' => sanitizeInput($_POST['currentState'] ?? ''),

            'business_challenges' => sanitizeInput($_POST['businessChallenges'] ?? ''),

            'business_opportunities' => sanitizeInput($_POST['businessOpportunities'] ?? ''),

            'company_role' => processCheckboxes($_POST['role'] ?? []),

            

            // Section 3: Informations sur le projet

            'project_purpose' => sanitizeInput($_POST['projectPurpose'] ?? ''),

            'project_goals' => sanitizeInput($_POST['projectGoals'] ?? ''),

            'project_owner' => processCheckboxes($_POST['projectOwner'] ?? []),

            'applicant_role' => sanitizeInput($_POST['role'] ?? ''),

            'project_location' => sanitizeInput($_POST['projectLocation'] ?? ''),

            'land_owner' => processCheckboxes($_POST['landOwner'] ?? []),

            

            // Section 4: Financement

            'funding_source' => sanitizeInput($_POST['fundingSource'] ?? ''),

            'loan_details' => sanitizeInput($_POST['loanDetails'] ?? ''),

            

            // Section 5: Données

            'data_collection' => sanitizeInput($_POST['dataCollection'] ?? ''),

            'data_type' => isset($_POST['dataType']) ? implode(', ', $_POST['dataType']) : '',

            'data_source' => isset($_POST['dataSource']) ? implode(', ', $_POST['dataSource']) : '',

            

            // Section 6: Méthodologie

            'methodology' => sanitizeInput($_POST['methodology'] ?? ''),

            

            // Section 7: Conception architecturale

            'architectural_conception' => isset($_POST['architecturalConception']) ? implode(', ', $_POST['architecturalConception']) : '',

            

            // Section 8: Étude économique

            'economic_study' => isset($_POST['economicStudy']) ? implode(', ', $_POST['economicStudy']) : '',

            

            // Section 9: Étude financière

            'financial_study' => isset($_POST['financialStudy']) ? implode(', ', $_POST['financialStudy']) : '',

            

            // Section 10: Impact

            'impact' => isset($_POST['impact']) ? implode(', ', $_POST['impact']) : '',

            

            // Section 11: Délais

            'timeline' => sanitizeInput($_POST['timeline'] ?? ''),

            'start_date' => sanitizeInput($_POST['startDate'] ?? ''),

            'delivery_date' => sanitizeInput($_POST['deliveryDate'] ?? ''),

            

            // Section 12: Ressources

            'resources' => isset($_POST['resources']) ? implode(', ', $_POST['resources']) : '',

            

            // Section 13: Profil du consultant

            'consultant_profile' => sanitizeInput($_POST['consultantProfile'] ?? ''),

            

            // Section 14: Expertise supplémentaire

            'additional_expertise' => isset($_POST['expertise']) ? implode(', ', $_POST['expertise']) : '',

            'expertise_area' => sanitizeInput($_POST['expertiseArea'] ?? ''),

            

            // Section 15: Endorsements

            'endorsements' => isset($_POST['endorsements']) ? implode(', ', $_POST['endorsements']) : '',

            

            // Section 16: Budget

            'budget' => sanitizeInput($_POST['budget'] ?? ''),

            'budget_financing' => sanitizeInput($_POST['budgetFinancing'] ?? ''),

            

            // Section 17: Résultats

            'results_presentation' => sanitizeInput($_POST['resultsPresentation'] ?? ''),

            

            // Section 18: Prochaines étapes

            'next_step_viable' => sanitizeInput($_POST['nextStepIfViable'] ?? ''),

            'next_step_not_viable' => sanitizeInput($_POST['nextStepIfNotViable'] ?? ''),

            

            // Section 19: Informations supplémentaires

            'additional_information' => sanitizeInput($_POST['additionalInformation'] ?? ''),

            

            // Section 20: Approbation du demandeur

            'applicant_name_approval' => sanitizeInput($_POST['applicantNameApproval'] ?? ''),

            'signature_data' => $_POST['signature_data'] ?? '',

            'approval_date' => sanitizeInput($_POST['approvalDate'] ?? ''),

        ];

        

        // Création du contenu de l'email

        $emailContent = "NOUVELLE DEMANDE D'ÉTUDE DE FAISABILITÉ\n";

        $emailContent .= str_repeat("=", 50) . "\n\n";

        

        $emailContent .= "1. INFORMATIONS DU DEMANDEUR\n";

        $emailContent .= "Nom: " . $formData['applicant_name'] . "\n";

        $emailContent .= "Prénom: " . $formData['applicant_surname'] . "\n";

        $emailContent .= "Pays: " . $formData['country'] . "\n";

        $emailContent .= "Ville: " . $formData['city'] . "\n";

        $emailContent .= "Rue: " . $formData['street'] . "\n";

        $emailContent .= "Code postal: " . $formData['zip'] . "\n";

        $emailContent .= "Téléphone: " . $formData['phone_number'] . "\n";

        $emailContent .= "Email: " . $formData['email'] . "\n\n";

        

        $emailContent .= "2. SITUATION ACTUELLE DE L'ENTREPRISE\n";

        $emailContent .= "État actuel: " . $formData['current_state'] . "\n";

        $emailContent .= "Défis business: " . $formData['business_challenges'] . "\n";

        $emailContent .= "Opportunités business: " . $formData['business_opportunities'] . "\n";

        $emailContent .= "Rôle de l'entreprise: " . $formData['company_role'] . "\n\n";

        

        $emailContent .= "3. INFORMATIONS SUR LE PROJET\n";

        $emailContent .= "Objectif de l'étude: " . $formData['project_purpose'] . "\n";

        $emailContent .= "Buts et objectifs: " . $formData['project_goals'] . "\n";

        $emailContent .= "Propriétaire du projet: " . $formData['project_owner'] . "\n";

        $emailContent .= "Rôle du demandeur: " . $formData['applicant_role'] . "\n";

        $emailContent .= "Localisation: " . $formData['project_location'] . "\n";

        $emailContent .= "Propriétaire du terrain: " . $formData['land_owner'] . "\n\n";

        

        $emailContent .= "4. FINANCEMENT\n";

        $emailContent .= "Source de financement: " . $formData['funding_source'] . "\n";

        $emailContent .= "Détails du prêt: " . $formData['loan_details'] . "\n\n";

        

        $emailContent .= "5. DONNÉES\n";

        $emailContent .= "Collecte de données: " . $formData['data_collection'] . "\n";

        $emailContent .= "Type de données: " . $formData['data_type'] . "\n";

        $emailContent .= "Source des données: " . $formData['data_source'] . "\n\n";

        

        $emailContent .= "6. MÉTHODOLOGIE\n";

        $emailContent .= "Méthodologie: " . $formData['methodology'] . "\n\n";

        

        $emailContent .= "7. CONCEPTION ARCHITECTURALE\n";

        $emailContent .= "Éléments requis: " . $formData['architectural_conception'] . "\n\n";

        

        $emailContent .= "8. ÉTUDE ÉCONOMIQUE\n";

        $emailContent .= "Analyses requises: " . $formData['economic_study'] . "\n\n";

        

        $emailContent .= "9. ÉTUDE FINANCIÈRE\n";

        $emailContent .= "Éléments financiers: " . $formData['financial_study'] . "\n\n";

        

        $emailContent .= "10. IMPACT\n";

        $emailContent .= "Types d'impact: " . $formData['impact'] . "\n\n";

        

        $emailContent .= "11. DÉLAIS\n";

        $emailContent .= "Timeline: " . $formData['timeline'] . "\n";

        $emailContent .= "Date de début: " . $formData['start_date'] . "\n";

        $emailContent .= "Date de livraison: " . $formData['delivery_date'] . "\n\n";

        

        $emailContent .= "12. RESSOURCES\n";

        $emailContent .= "Ressources nécessaires: " . $formData['resources'] . "\n\n";

        

        $emailContent .= "13. PROFIL DU CONSULTANT\n";

        $emailContent .= "Profil requis: " . $formData['consultant_profile'] . "\n\n";

        

        $emailContent .= "14. EXPERTISE SUPPLÉMENTAIRE\n";

        $emailContent .= "Expertise supplémentaire: " . $formData['additional_expertise'] . "\n";

        $emailContent .= "Domaine d'expertise: " . $formData['expertise_area'] . "\n\n";

        

        $emailContent .= "15. ENDORSEMENTS\n";

        $emailContent .= "Endorsements requis: " . $formData['endorsements'] . "\n\n";

        

        $emailContent .= "16. BUDGET\n";

        $emailContent .= "Budget: " . $formData['budget'] . "\n";

        $emailContent .= "Financement du budget: " . $formData['budget_financing'] . "\n\n";

        

        $emailContent .= "17. RÉSULTATS\n";

        $emailContent .= "Présentation des résultats: " . $formData['results_presentation'] . "\n\n";

        

        $emailContent .= "18. PROCHAINES ÉTAPES\n";

        $emailContent .= "Si viable: " . $formData['next_step_viable'] . "\n";

        $emailContent .= "Si non viable: " . $formData['next_step_not_viable'] . "\n\n";

        

        $emailContent .= "19. INFORMATIONS SUPPLÉMENTAIRES\n";

        $emailContent .= $formData['additional_information'] . "\n\n";

        

        $emailContent .= "20. APPROBATION\n";

        $emailContent .= "Nom complet: " . $formData['applicant_name_approval'] . "\n";

        $emailContent .= "Date d'approbation: " . $formData['approval_date'] . "\n";

        $emailContent .= "Signature incluse: " . (!empty($formData['signature_data']) ? 'Oui' : 'Non') . "\n\n";

        

        if ($fileUpload['success'] && isset($fileUpload['name'])) {

            $emailContent .= "FICHIER JOINT: " . $fileUpload['name'] . "\n";

        }

        

        $emailContent .= "\nDate de soumission: " . date('d/m/Y H:i:s') . "\n";

        $emailContent .= "IP du demandeur: " . $_SERVER['REMOTE_ADDR'] . "\n";

        

        // Configuration des headers email

        $headers = [

            'From: ' . SENDER_EMAIL,

            'Reply-To: ' . $formData['email'],

            'X-Mailer: PHP/' . phpversion(),

            'Content-Type: text/plain; charset=UTF-8'

        ];

        

        // Envoi de l'email principal

        $mailSent = mail(RECIPIENT_EMAIL, SUBJECT, $emailContent, implode("\r\n", $headers));

        

        // Envoi d'un email de confirmation au demandeur

        $confirmationSubject = 'Confirmation de réception - Demande d\'étude de faisabilité';

        $confirmationContent = "Bonjour " . $formData['applicant_name'] . " " . $formData['applicant_surname'] . ",\n\n";

        $confirmationContent .= "Nous accusons réception de votre demande d'étude de faisabilité.\n";

        $confirmationContent .= "Notre équipe examinera votre dossier et vous contactera dans les plus brefs délais.\n\n";

        $confirmationContent .= "Détails de votre demande:\n";

        $confirmationContent .= "- Date de soumission: " . date('d/m/Y H:i:s') . "\n";

        $confirmationContent .= "- Projet: " . $formData['project_purpose'] . "\n";

        $confirmationContent .= "- Localisation: " . $formData['project_location'] . "\n\n";

        $confirmationContent .= "Cordialement,\nL'équipe GIFAM\n";

        

        $confirmationHeaders = [

            'From: ' . SENDER_EMAIL,

            'X-Mailer: PHP/' . phpversion(),

            'Content-Type: text/plain; charset=UTF-8'

        ];

        

        mail($formData['email'], $confirmationSubject, $confirmationContent, implode("\r\n", $confirmationHeaders));

        

        // Sauvegarde des données dans un fichier log (optionnel)

        $logEntry = date('Y-m-d H:i:s') . " - Nouvelle demande de " . $formData['applicant_name'] . " " . $formData['applicant_surname'] . " (" . $formData['email'] . ")\n";

        file_put_contents('submissions.log', $logEntry, FILE_APPEND | LOCK_EX);

        

        // Réponse de succès

        if ($mailSent) {

            echo json_encode([

                'success' => true,

                'message' => 'Votre demande a été envoyée avec succès. Un email de confirmation vous a été envoyé.'

            ]);

        } else {

            throw new Exception('Erreur lors de l\'envoi de l\'email');

        }

        

    } catch (Exception $e) {

        // Gestion des erreurs

        http_response_code(500);

        echo json_encode([

            'success' => false,

            'message' => 'Erreur lors du traitement: ' . $e->getMessage()

        ]);

        

        // Log de l'erreur

        error_log("Erreur formulaire faisabilité: " . $e->getMessage());

    }

} else {

    // Méthode non autorisée

    http_response_code(405);

    echo json_encode([

        'success' => false,

        'message' => 'Méthode non autorisée'

    ]);

}

?>