<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Legal Notices";
$query = "SELECT * FROM legal_notices WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Legal Notices - GIFAM | Compliance & Regulatory Information',
        'meta_description' => 'Comprehensive legal notices and compliance information for GIFAM. Access privacy policies, terms and conditions, cookie policies, and legal disclaimers.',
        'meta_keywords' => 'legal notices, compliance, privacy policy, terms and conditions, cookie policy, legal disclaimer, GIFAM',
        'hero_title' => 'Legal Notices & Compliance',
        'hero_subtitle' => 'GIFAM is committed to transparency and legal compliance. Our comprehensive legal framework ensures that all our operations, data handling practices, and client interactions adhere to the highest standards of legal and regulatory requirements.',
        'hero_image' => '../images/case-study/case-study-1.jpg',
        'compliance_badge_1' => 'GDPR Compliant',
        'compliance_badge_2' => 'ISO 27001 Certified',
        'last_updated_date' => 'December 15, 2024',
        'last_updated_text' => 'These legal notices were last updated on',
        'last_updated_description' => 'We regularly review and update our legal documents to ensure compliance with current regulations and best practices.',
        'framework_title' => 'Our Legal Framework',
        'framework_description' => 'GIFAM operates under a comprehensive legal framework designed to protect our clients, partners, and stakeholders while ensuring full compliance with international regulations and industry standards.',
        'document_1_title' => 'Privacy Policy',
        'document_1_icon' => 'icofont-shield-check text-success me-2',
        'document_1_description' => 'Comprehensive information about how we collect, use, store, and protect your personal data in accordance with GDPR and other privacy regulations.',
        'document_1_link' => '../privacy-policy/',
        'document_1_button' => 'Read Privacy Policy',
        'document_2_title' => 'Terms and Conditions',
        'document_2_icon' => 'icofont-file-text text-primary me-2',
        'document_2_description' => 'Detailed terms governing the use of our services, website, and the relationship between GIFAM and our clients.',
        'document_2_link' => '../terms-and-conditions/',
        'document_2_button' => 'Read Terms & Conditions',
        'document_3_title' => 'Cookie Policy',
        'document_3_icon' => 'icofont-cookie text-warning me-2',
        'document_3_description' => 'Information about how we use cookies and similar technologies to enhance your browsing experience and provide personalized services.',
        'document_3_link' => '../cookie-policy/',
        'document_3_button' => 'Read Cookie Policy',
        'document_4_title' => 'Legal Disclaimer',
        'document_4_icon' => 'icofont-gavel text-danger me-2',
        'document_4_description' => 'Important disclaimers regarding the use of our website, services, and the limitations of liability under applicable law.',
        'document_4_link' => '../legal-disclaimer/',
        'document_4_button' => 'Read Legal Disclaimer',
        'compliance_title' => 'Regulatory Compliance',
        'international_standards_title' => 'International Standards',
        'international_standard_1' => 'GDPR (General Data Protection Regulation)',
        'international_standard_2' => 'ISO 27001 Information Security Management',
        'international_standard_3' => 'SOX (Sarbanes-Oxley Act) Compliance',
        'international_standard_4' => 'PCI DSS (Payment Card Industry Standards)',
        'industry_regulations_title' => 'Industry Regulations',
        'industry_regulation_1' => 'Financial Services Regulations',
        'industry_regulation_2' => 'Investment Advisory Standards',
        'industry_regulation_3' => 'Anti-Money Laundering (AML) Compliance',
        'industry_regulation_4' => 'Know Your Customer (KYC) Procedures',
        'data_protection_title' => 'Data Protection & Privacy',
        'data_protection_description' => 'At GIFAM, we take data protection seriously. Our comprehensive privacy framework ensures that your personal and business information is handled with the utmost care and in full compliance with international privacy laws.',
        'protection_1_title' => 'Secure Data Storage',
        'protection_1_icon' => 'icofont-lock text-primary',
        'protection_1_description' => 'Enterprise-grade encryption and secure data centers ensure your information remains protected.',
        'protection_2_title' => 'Privacy by Design',
        'protection_2_icon' => 'icofont-eye-blocked text-success',
        'protection_2_description' => 'Our systems are built with privacy protection as a fundamental component from the ground up.',
        'protection_3_title' => 'Transparent Practices',
        'protection_3_icon' => 'icofont-handshake-deal text-warning',
        'protection_3_description' => 'Clear communication about how we use your data and your rights regarding your information.',
        'contact_title' => 'Legal Contact Information',
        'dpo_title' => 'Data Protection Officer',
        'dpo_email' => 'dpo@gifam.eu',
        'dpo_phone' => '+1 (555) 123-4567',
        'dpo_address' => '123 Business Street, Suite 100, New York, NY 10001',
        'legal_dept_title' => 'Legal Department',
        'legal_dept_email' => 'legal@gifam.eu',
        'legal_dept_phone' => '+1 (555) 123-4568',
        'legal_dept_urgent' => '+1 (555) 123-4569',
        'updates_title' => 'Updates and Changes',
        'updates_description' => 'We may update these legal notices from time to time to reflect changes in our practices, technology, legal requirements, or other factors. When we make changes, we will:',
        'update_point_1' => 'Update the "Last Updated" date at the top of each document',
        'update_point_2' => 'Provide notice of significant changes through our website or email',
        'update_point_3' => 'Maintain version history for transparency',
        'update_point_4' => 'Ensure changes are communicated clearly and in advance',
        'cta_title' => 'Questions About Our Legal Framework?',
        'cta_subtitle' => 'Our legal team is here to help clarify any questions about our policies, procedures, or compliance measures.',
        'cta_button_text' => 'Contact Legal Team',
        'cta_button_link' => '../contact-us/',
        'cta_button_2_text' => 'Learn More About GIFAM',
        'cta_button_2_link' => '../about/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .legal-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .legal-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }
        
        .legal-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        
        .legal-card h4 {
            color: #d12907;
            margin-bottom: 15px;
        }
        
        .legal-links a {
            color: #d12907;
            text-decoration: none;
            font-weight: 600;
        }
        
        .legal-links a:hover {
            text-decoration: underline;
        }
        
        .compliance-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .update-info {
                background: #dc35451f;
    border: 1px solid #dc3545;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
<br><br>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                            <div class="compliance-badge"><?php echo htmlspecialchars($page_data['compliance_badge_1']); ?></div>
                            <div class="compliance-badge"><?php echo htmlspecialchars($page_data['compliance_badge_2']); ?></div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url . htmlspecialchars($page_data['hero_image']); ?>" alt="Legal Compliance" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Update Information -->
                    <div class="update-info">
                        <h5><i class="icofont-info-circle"></i> Last Updated</h5>
                        <p class="mb-0"><?php echo htmlspecialchars($page_data['last_updated_text']); ?> <strong><?php echo htmlspecialchars($page_data['last_updated_date']); ?></strong>. <?php echo htmlspecialchars($page_data['last_updated_description']); ?></p>
                    </div>

                    <!-- Legal Documents Overview -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h2><?php echo htmlspecialchars($page_data['framework_title']); ?></h2>
                            <p><?php echo htmlspecialchars($page_data['framework_description']); ?></p>
                        </div>
                        
                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="<?php echo htmlspecialchars($page_data['document_1_icon']); ?>"></i><?php echo htmlspecialchars($page_data['document_1_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['document_1_description']); ?></p>
                                <a href="<?php echo $url . htmlspecialchars($page_data['document_1_link']); ?>" class="btn btn-outline-primary"><?php echo htmlspecialchars($page_data['document_1_button']); ?></a>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="<?php echo htmlspecialchars($page_data['document_2_icon']); ?>"></i><?php echo htmlspecialchars($page_data['document_2_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['document_2_description']); ?></p>
                                <a href="<?php echo $url . htmlspecialchars($page_data['document_2_link']); ?>" class="btn btn-outline-primary"><?php echo htmlspecialchars($page_data['document_2_button']); ?></a>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="<?php echo htmlspecialchars($page_data['document_3_icon']); ?>"></i><?php echo htmlspecialchars($page_data['document_3_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['document_3_description']); ?></p>
                                <a href="<?php echo $url . htmlspecialchars($page_data['document_3_link']); ?>" class="btn btn-outline-primary"><?php echo htmlspecialchars($page_data['document_3_button']); ?></a>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="<?php echo htmlspecialchars($page_data['document_4_icon']); ?>"></i><?php echo htmlspecialchars($page_data['document_4_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['document_4_description']); ?></p>
                                <a href="<?php echo $url . htmlspecialchars($page_data['document_4_link']); ?>" class="btn btn-outline-primary"><?php echo htmlspecialchars($page_data['document_4_button']); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Compliance Section -->
                    <div class="legal-section">
                        <h2><?php echo htmlspecialchars($page_data['compliance_title']); ?></h2>
                        <div class="row">
                            <div class="col-lg-6">
                                <h4><?php echo htmlspecialchars($page_data['international_standards_title']); ?></h4>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['international_standard_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['international_standard_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['international_standard_3']); ?></li>
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['international_standard_4']); ?></li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4><?php echo htmlspecialchars($page_data['industry_regulations_title']); ?></h4>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['industry_regulation_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['industry_regulation_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['industry_regulation_3']); ?></li>
                                    <li><i class="icofont-check-circled text-success me-2"></i><?php echo htmlspecialchars($page_data['industry_regulation_4']); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Data Protection Section -->
                    <div class="legal-section">
                        <h2><?php echo htmlspecialchars($page_data['data_protection_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['data_protection_description']); ?></p>
                        
                        <div class="row">
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="text-center">
                                    <i class="<?php echo htmlspecialchars($page_data['protection_1_icon']); ?>" style="font-size: 3rem;"></i>
                                    <h5><?php echo htmlspecialchars($page_data['protection_1_title']); ?></h5>
                                    <p><?php echo htmlspecialchars($page_data['protection_1_description']); ?></p>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="text-center">
                                    <i class="<?php echo htmlspecialchars($page_data['protection_2_icon']); ?>" style="font-size: 3rem;"></i>
                                    <h5><?php echo htmlspecialchars($page_data['protection_2_title']); ?></h5>
                                    <p><?php echo htmlspecialchars($page_data['protection_2_description']); ?></p>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="text-center">
                                    <i class="<?php echo htmlspecialchars($page_data['protection_3_icon']); ?>" style="font-size: 3rem;"></i>
                                    <h5><?php echo htmlspecialchars($page_data['protection_3_title']); ?></h5>
                                    <p><?php echo htmlspecialchars($page_data['protection_3_description']); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="legal-section">
                        <h2><?php echo htmlspecialchars($page_data['contact_title']); ?></h2>
                        <div class="row">
                            <div class="col-lg-6">
                                <h4><?php echo htmlspecialchars($page_data['dpo_title']); ?></h4>
                                <p><strong>Email:</strong> <?php echo htmlspecialchars($page_data['dpo_email']); ?><br>
                                <strong>Phone:</strong> <?php echo htmlspecialchars($page_data['dpo_phone']); ?><br>
                                <strong>Address:</strong> <?php echo htmlspecialchars($page_data['dpo_address']); ?></p>
                            </div>
                            <div class="col-lg-6">
                                <h4><?php echo htmlspecialchars($page_data['legal_dept_title']); ?></h4>
                                <p><strong>Email:</strong> <?php echo htmlspecialchars($page_data['legal_dept_email']); ?><br>
                                <strong>Phone:</strong> <?php echo htmlspecialchars($page_data['legal_dept_phone']); ?><br>
                                <strong>For urgent matters:</strong> <?php echo htmlspecialchars($page_data['legal_dept_urgent']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Updates and Changes -->
                    <div class="legal-section">
                        <h2><?php echo htmlspecialchars($page_data['updates_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['updates_description']); ?></p>
                        <ul>
                            <li><?php echo htmlspecialchars($page_data['update_point_1']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['update_point_2']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['update_point_3']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['update_point_4']); ?></li>
                        </ul>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3><?php echo htmlspecialchars($page_data['cta_title']); ?></h3>
                                <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                                <a href="<?php echo $url . htmlspecialchars($page_data['cta_button_link']); ?>" class="btn btn-primary btn-lg me-3"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
                                <a href="<?php echo $url . htmlspecialchars($page_data['cta_button_2_link']); ?>" class="btn btn-outline-primary btn-lg"><?php echo htmlspecialchars($page_data['cta_button_2_text']); ?></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html> 
