-- Création de la table pour la page Market Entry Strategy
CREATE TABLE IF NOT EXISTS `market_entry_strategy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(255) NOT NULL,
  `page_title` varchar(255) NOT NULL,
  `meta_description` text,
  `meta_keywords` text,
  `hero_title` varchar(255),
  `hero_subtitle` text,
  `hero_button_text` varchar(255),
  `hero_button_link` varchar(255),
  `pillars_title` varchar(255),
  `pillar_1_title` varchar(255),
  `pillar_1_description` text,
  `pillar_1_icon` varchar(255),
  `pillar_2_title` varchar(255),
  `pillar_2_description` text,
  `pillar_2_icon` varchar(255),
  `pillar_3_title` varchar(255),
  `pillar_3_description` text,
  `pillar_3_icon` varchar(255),
  `analysis_title` varchar(255),
  `step_1_title` varchar(255),
  `step_1_description` text,
  `step_2_title` varchar(255),
  `step_2_description` text,
  `step_3_title` varchar(255),
  `step_3_description` text,
  `step_4_title` varchar(255),
  `step_4_description` text,
  `modes_title` varchar(255),
  `mode_1_title` varchar(255),
  `mode_1_description` text,
  `mode_1_icon` varchar(255),
  `mode_2_title` varchar(255),
  `mode_2_description` text,
  `mode_2_icon` varchar(255),
  `mode_3_title` varchar(255),
  `mode_3_description` text,
  `mode_3_icon` varchar(255),
  `stories_title` varchar(255),
  `story_1_title` varchar(255),
  `story_1_subtitle` varchar(255),
  `story_1_description` text,
  `story_1_icon` varchar(255),
  `story_2_title` varchar(255),
  `story_2_subtitle` varchar(255),
  `story_2_description` text,
  `story_2_icon` varchar(255),
  `cta_title` varchar(255),
  `cta_subtitle` text,
  `cta_button_text` varchar(255),
  `cta_button_link` varchar(255),
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_name` (`page_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertion des données par défaut
INSERT INTO `market_entry_strategy` (
  `page_name`,
  `page_title`,
  `meta_description`,
  `meta_keywords`,
  `hero_title`,
  `hero_subtitle`,
  `hero_button_text`,
  `hero_button_link`,
  `pillars_title`,
  `pillar_1_title`,
  `pillar_1_description`,
  `pillar_1_icon`,
  `pillar_2_title`,
  `pillar_2_description`,
  `pillar_2_icon`,
  `pillar_3_title`,
  `pillar_3_description`,
  `pillar_3_icon`,
  `analysis_title`,
  `step_1_title`,
  `step_1_description`,
  `step_2_title`,
  `step_2_description`,
  `step_3_title`,
  `step_3_description`,
  `step_4_title`,
  `step_4_description`,
  `modes_title`,
  `mode_1_title`,
  `mode_1_description`,
  `mode_1_icon`,
  `mode_2_title`,
  `mode_2_description`,
  `mode_2_icon`,
  `mode_3_title`,
  `mode_3_description`,
  `mode_3_icon`,
  `stories_title`,
  `story_1_title`,
  `story_1_subtitle`,
  `story_1_description`,
  `story_1_icon`,
  `story_2_title`,
  `story_2_subtitle`,
  `story_2_description`,
  `story_2_icon`,
  `cta_title`,
  `cta_subtitle`,
  `cta_button_text`,
  `cta_button_link`
) VALUES (
  'Market Entry Strategy',
  'Market Entry Strategy',
  'Expertise in international market entry strategy. Develop your global presence with our personalized solutions.',
  'market strategy, market entry, international development, business expansion, GIFAM',
  'Market Entry Strategy',
  'Develop your international presence with our personalized market entry strategies and business expansion solutions.',
  'Explore markets',
  '#contact',
  'Pillars of Our Strategy',
  'Market Analysis',
  'In-depth study of opportunities, competition and market trends in the target market.',
  'icofont-search-1',
  'Positioning',
  'Definition of a unique value proposition and strategic positioning.',
  'icofont-target',
  'Execution',
  'Implementation of the strategy with continuous support and optimization.',
  'icofont-rocket',
  'Market Analysis Process',
  'Primary Research',
  'Interviews with local stakeholders, field studies and customer behavior analysis.',
  'Secondary Research',
  'Analysis of public data, sector reports and existing market studies.',
  'Competitive Analysis',
  'Assessment of competitors\' strengths and weaknesses and identification of opportunities.',
  'Validation',
  'Testing of the value proposition and validation of the entry strategy.',
  'Market Entry Modes',
  'Partnership',
  'Collaboration with local partners to accelerate entry and reduce risks.',
  'icofont-handshake',
  'Subsidiary',
  'Creation of a local entity for total control and permanent presence.',
  'icofont-building',
  'Export',
  'Distribution through local channels with logistics and marketing support.',
  'icofont-cart',
  'Success Stories',
  'Asia Expansion',
  'Technology - 2023',
  'Supporting a tech startup in its expansion to 3 Asian countries with 300% growth in 18 months.',
  'icofont-flag',
  'Europe Entry',
  'Manufacturing - 2022',
  'Successful entry strategy for an American manufacturer with establishment of 2 production sites in Europe.',
  'icofont-building',
  'Ready to conquer new markets?',
  'Our team of market entry strategy experts is here to support you.',
  'Start your expansion',
  '../contact-us/'
) ON DUPLICATE KEY UPDATE
  `page_title` = VALUES(`page_title`),
  `meta_description` = VALUES(`meta_description`),
  `meta_keywords` = VALUES(`meta_keywords`),
  `hero_title` = VALUES(`hero_title`),
  `hero_subtitle` = VALUES(`hero_subtitle`),
  `hero_button_text` = VALUES(`hero_button_text`),
  `hero_button_link` = VALUES(`hero_button_link`),
  `pillars_title` = VALUES(`pillars_title`),
  `pillar_1_title` = VALUES(`pillar_1_title`),
  `pillar_1_description` = VALUES(`pillar_1_description`),
  `pillar_1_icon` = VALUES(`pillar_1_icon`),
  `pillar_2_title` = VALUES(`pillar_2_title`),
  `pillar_2_description` = VALUES(`pillar_2_description`),
  `pillar_2_icon` = VALUES(`pillar_2_icon`),
  `pillar_3_title` = VALUES(`pillar_3_title`),
  `pillar_3_description` = VALUES(`pillar_3_description`),
  `pillar_3_icon` = VALUES(`pillar_3_icon`),
  `analysis_title` = VALUES(`analysis_title`),
  `step_1_title` = VALUES(`step_1_title`),
  `step_1_description` = VALUES(`step_1_description`),
  `step_2_title` = VALUES(`step_2_title`),
  `step_2_description` = VALUES(`step_2_description`),
  `step_3_title` = VALUES(`step_3_title`),
  `step_3_description` = VALUES(`step_3_description`),
  `step_4_title` = VALUES(`step_4_title`),
  `step_4_description` = VALUES(`step_4_description`),
  `modes_title` = VALUES(`modes_title`),
  `mode_1_title` = VALUES(`mode_1_title`),
  `mode_1_description` = VALUES(`mode_1_description`),
  `mode_1_icon` = VALUES(`mode_1_icon`),
  `mode_2_title` = VALUES(`mode_2_title`),
  `mode_2_description` = VALUES(`mode_2_description`),
  `mode_2_icon` = VALUES(`mode_2_icon`),
  `mode_3_title` = VALUES(`mode_3_title`),
  `mode_3_description` = VALUES(`mode_3_description`),
  `mode_3_icon` = VALUES(`mode_3_icon`),
  `stories_title` = VALUES(`stories_title`),
  `story_1_title` = VALUES(`story_1_title`),
  `story_1_subtitle` = VALUES(`story_1_subtitle`),
  `story_1_description` = VALUES(`story_1_description`),
  `story_1_icon` = VALUES(`story_1_icon`),
  `story_2_title` = VALUES(`story_2_title`),
  `story_2_subtitle` = VALUES(`story_2_subtitle`),
  `story_2_description` = VALUES(`story_2_description`),
  `story_2_icon` = VALUES(`story_2_icon`),
  `cta_title` = VALUES(`cta_title`),
  `cta_subtitle` = VALUES(`cta_subtitle`),
  `cta_button_text` = VALUES(`cta_button_text`),
  `cta_button_link` = VALUES(`cta_button_link`); 