<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Market Entry Strategy";
$query = "SELECT * FROM market_entry_strategy WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Market Entry Strategy',
        'meta_description' => 'Expertise in international market entry strategy. Develop your global presence with our personalized solutions.',
        'meta_keywords' => 'market strategy, market entry, international development, business expansion, GIFAM',
        'hero_title' => 'Market Entry Strategy',
        'hero_subtitle' => 'Develop your international presence with our personalized market entry strategies and business expansion solutions.',
        'hero_button_text' => 'Explore markets',
        'hero_button_link' => '#contact',
        'pillars_title' => 'Pillars of Our Strategy',
        'pillar_1_title' => 'Market Analysis',
        'pillar_1_description' => 'In-depth study of opportunities, competition and market trends in the target market.',
        'pillar_1_icon' => 'icofont-search-1',
        'pillar_2_title' => 'Positioning',
        'pillar_2_description' => 'Definition of a unique value proposition and strategic positioning.',
        'pillar_2_icon' => 'icofont-target',
        'pillar_3_title' => 'Execution',
        'pillar_3_description' => 'Implementation of the strategy with continuous support and optimization.',
        'pillar_3_icon' => 'icofont-rocket',
        'analysis_title' => 'Market Analysis Process',
        'step_1_title' => 'Primary Research',
        'step_1_description' => 'Interviews with local stakeholders, field studies and customer behavior analysis.',
        'step_2_title' => 'Secondary Research',
        'step_2_description' => 'Analysis of public data, sector reports and existing market studies.',
        'step_3_title' => 'Competitive Analysis',
        'step_3_description' => 'Assessment of competitors\' strengths and weaknesses and identification of opportunities.',
        'step_4_title' => 'Validation',
        'step_4_description' => 'Testing of the value proposition and validation of the entry strategy.',
        'modes_title' => 'Market Entry Modes',
        'mode_1_title' => 'Partnership',
        'mode_1_description' => 'Collaboration with local partners to accelerate entry and reduce risks.',
        'mode_1_icon' => 'icofont-handshake',
        'mode_2_title' => 'Subsidiary',
        'mode_2_description' => 'Creation of a local entity for total control and permanent presence.',
        'mode_2_icon' => 'icofont-building',
        'mode_3_title' => 'Export',
        'mode_3_description' => 'Distribution through local channels with logistics and marketing support.',
        'mode_3_icon' => 'icofont-cart',
        'stories_title' => 'Success Stories',
        'story_1_title' => 'Asia Expansion',
        'story_1_subtitle' => 'Technology - 2023',
        'story_1_description' => 'Supporting a tech startup in its expansion to 3 Asian countries with 300% growth in 18 months.',
        'story_1_icon' => 'icofont-flag',
        'story_2_title' => 'Europe Entry',
        'story_2_subtitle' => 'Manufacturing - 2022',
        'story_2_description' => 'Successful entry strategy for an American manufacturer with establishment of 2 production sites in Europe.',
        'story_2_icon' => 'icofont-building',
        'cta_title' => 'Ready to conquer new markets?',
        'cta_subtitle' => 'Our team of market entry strategy experts is here to support you.',
        'cta_button_text' => 'Start your expansion',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
<!-- Inject:css -->
<link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        :root {
            --primary-color: #dc3545;
            --secondary-color: #212529;
            --accent-color:rgb(0, 0, 0);
            --success-color:rgb(0, 0, 0);
            --info-color:rgb(0, 0, 0);
            --warning-color:rgb(0, 0, 0);
        }
        
        .market-hero {
            background: linear-gradient(135deg, var(--accent-color) 0%, var(--accent-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .market-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="world" width="30" height="30" patternUnits="userSpaceOnUse"><circle cx="15" cy="15" r="2" fill="rgba(255,255,255,0.1)"/><path d="M0 15 Q15 0 30 15 Q15 30 0 15" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23world)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .strategy-pillars {
            padding: 80px 0;
            background: white;
        }
        
        .pillar-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .pillar-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
        }
        
        .pillar-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .pillar-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .pillar-icon i {
            color: white;
            font-size: 32px;
        }
        
        .market-analysis {
            background: var(--secondary-color);
            color: white;
            padding: 80px 0;
        }
        
        .analysis-step {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .step-number {
            width: 50px;
            height: 50px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .entry-modes {
            padding: 80px 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .mode-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            margin-bottom: 30px;
            position: relative;
        }
        
        .mode-card::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .mode-card:hover::after {
            transform: scaleX(1);
        }
        
        .mode-card:hover {
            transform: translateY(-5px);
        }
        
        .mode-icon {
            width: 70px;
            height: 70px;
            background: var(--primary-color);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .mode-icon i {
            color: white;
            font-size: 28px;
        }
        
        .success-stories {
            padding: 80px 0;
            background: white;
        }
        
        .story-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 30px;
            border-left: 5px solid var(--primary-color);
        }
        
        .story-header {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .story-avatar {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 20px;
        }
        
        .story-avatar i {
            color: white;
            font-size: 24px;
        }
        
        .btn-market {
            background: linear-gradient(45deg, var(--primary-color), var(--primary-color));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        
        .btn-market:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(220, 53, 69, 0.3);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="market-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-light btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <i class="icofont-globe" style="font-size: 150px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Strategy Pillars -->
    <section class="strategy-pillars">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['pillars_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="pillar-card">
                        <div class="pillar-icon">
                            <i class="<?php echo htmlspecialchars($page_data['pillar_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['pillar_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['pillar_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="pillar-card">
                        <div class="pillar-icon">
                            <i class="<?php echo htmlspecialchars($page_data['pillar_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['pillar_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['pillar_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="pillar-card">
                        <div class="pillar-icon">
                            <i class="<?php echo htmlspecialchars($page_data['pillar_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['pillar_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['pillar_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Market Analysis -->
    <section class="market-analysis">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['analysis_title']); ?></h2>
            <div class="row">
                <div class="col-lg-6">
                    <div class="analysis-step">
                        <div class="step-number">1</div>
                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="analysis-step">
                        <div class="step-number">2</div>
                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="analysis-step">
                        <div class="step-number">3</div>
                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="analysis-step">
                        <div class="step-number">4</div>
                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Entry Modes -->
    <section class="entry-modes">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['modes_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="mode-card">
                        <div class="mode-icon">
                            <i class="<?php echo htmlspecialchars($page_data['mode_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['mode_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['mode_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="mode-card">
                        <div class="mode-icon">
                            <i class="<?php echo htmlspecialchars($page_data['mode_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['mode_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['mode_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="mode-card">
                        <div class="mode-icon">
                            <i class="<?php echo htmlspecialchars($page_data['mode_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['mode_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['mode_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Success Stories -->
    <section class="success-stories">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['stories_title']); ?></h2>
            <div class="row">
                <div class="col-lg-6">
                    <div class="story-card">
                        <div class="story-header">
                            <div class="story-avatar">
                                <i class="<?php echo htmlspecialchars($page_data['story_1_icon']); ?>"></i>
                            </div>
                            <div>
                                <h5><?php echo htmlspecialchars($page_data['story_1_title']); ?></h5>
                                <small><?php echo htmlspecialchars($page_data['story_1_subtitle']); ?></small>
                            </div>
                        </div>
                        <p><?php echo htmlspecialchars($page_data['story_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="story-card">
                        <div class="story-header">
                            <div class="story-avatar">
                                <i class="<?php echo htmlspecialchars($page_data['story_2_icon']); ?>"></i>
                            </div>
                            <div>
                                <h5><?php echo htmlspecialchars($page_data['story_2_title']); ?></h5>
                                <small><?php echo htmlspecialchars($page_data['story_2_subtitle']); ?></small>
                            </div>
                        </div>
                        <p><?php echo htmlspecialchars($page_data['story_2_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" style="background: linear-gradient(45deg, var(--accent-color), var(--accent-color)); color: white; padding: 80px 0; text-align: center;">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-market btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 