<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Mergers & Acquisitions";
$query = "SELECT * FROM mergers_acquisitions WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Mergers & Acquisitions',
        'meta_description' => 'Expertise in mergers and acquisitions. Complete support in your strategic transactions to create value.',
        'meta_keywords' => 'mergers acquisitions, M&A, strategic transactions, due diligence, valuation, GIFAM',
        'hero_title' => 'Mergers & Acquisitions',
        'hero_subtitle' => 'Complete support in your strategic transactions. From due diligence to finalization, we create value at every step.',
        'hero_button_text' => 'Start your transaction',
        'hero_button_link' => '#contact',
        'services_title' => 'Our M&A Services',
        'service_1_title' => 'Due Diligence',
        'service_1_description' => 'In-depth analysis of financial, legal, operational and strategic aspects of the target.',
        'service_1_icon' => 'icofont-search-1',
        'service_2_title' => 'Valuation',
        'service_2_description' => 'Accurate valuation of the target company with multiple valuation methods.',
        'service_2_icon' => 'icofont-calculator',
        'service_3_title' => 'Negotiation',
        'service_3_description' => 'Support in negotiations to optimize the terms of the transaction.',
        'service_3_icon' => 'icofont-file-text',
        'process_title' => 'M&A Process',
        'step_1_title' => 'Strategy & Targeting',
        'step_1_description' => 'Definition of acquisition strategy and identification of potential targets.',
        'step_2_title' => 'Due Diligence',
        'step_2_description' => 'Complete analysis of the target: financial, legal, operational and strategic.',
        'step_3_title' => 'Negotiation',
        'step_3_description' => 'Negotiation of transaction terms and agreement structuring.',
        'step_4_title' => 'Integration',
        'step_4_description' => 'Planning and execution of post-transaction integration.',
        'valuation_title' => 'Valuation Methods',
        'valuation_1_title' => 'Cash Flows',
        'valuation_1_description' => 'Valuation based on discounted future cash flows (DCF).',
        'valuation_1_icon' => 'icofont-chart-line',
        'valuation_2_title' => 'Multiples',
        'valuation_2_description' => 'Comparison with similar transactions and market multiples.',
        'valuation_2_icon' => 'icofont-chart-bar',
        'valuation_3_title' => 'Assets',
        'valuation_3_description' => 'Valuation based on adjusted net asset value.',
        'valuation_3_icon' => 'icofont-building',
        'metrics_title' => 'Our Performance',
        'metric_1_number' => '50+',
        'metric_1_label' => 'Completed Transactions',
        'metric_2_number' => '2.5M€',
        'metric_2_label' => 'Average Value',
        'metric_3_number' => '95%',
        'metric_3_label' => 'Success Rate',
        'metric_4_number' => '12',
        'metric_4_label' => 'Average Months',
        'stages_title' => 'Transaction Stages',
        'stage_1_title' => 'Preparation',
        'stage_1_description' => 'Strategy definition, target identification and document preparation.',
        'stage_1_icon' => 'icofont-target',
        'stage_2_title' => 'Due Diligence',
        'stage_2_description' => 'In-depth analysis of all aspects of the target to identify opportunities and risks.',
        'stage_2_icon' => 'icofont-search-1',
        'stage_3_title' => 'Negotiation',
        'stage_3_description' => 'Negotiation of terms and conditions of the transaction with stakeholders.',
        'stage_3_icon' => 'icofont-handshake',
        'stage_4_title' => 'Finalization',
        'stage_4_description' => 'Transaction closing and start of post-merger integration process.',
        'stage_4_icon' => 'icofont-check-circled',
        'cta_title' => 'Ready to realize your strategic transaction?',
        'cta_subtitle' => 'Our team of M&A experts is here to support you at every step.',
        'cta_button_text' => 'Start your project',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
<!-- Inject:css -->
<link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        :root {
            --primary-color: #dc3545;
            --secondary-color: #212529;
            --accent-color:rgb(0, 0, 0);
            --success-color:rgb(0, 0, 0);
            --info-color:rgb(0, 0, 0);
            --warning-color:rgb(0, 0, 0);
        }
        
        .ma-hero {
            background: linear-gradient(135deg, var(--accent-color) 0%, var(--accent-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .ma-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="merge" width="40" height="40" patternUnits="userSpaceOnUse"><circle cx="20" cy="20" r="3" fill="rgba(255,255,255,0.1)"/><path d="M0 20 Q20 0 40 20 Q20 40 0 20" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="1"/></pattern></defs><rect width="100" height="100" fill="url(%23merge)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .ma-services {
            padding: 80px 0;
            background: white;
        }
        
        .service-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .service-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
        }
        
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .service-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .service-icon i {
            color: white;
            font-size: 32px;
        }
        
        .process-section {
            background: var(--secondary-color);
            color: white;
            padding: 80px 0;
        }
        
        .process-step {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
            position: relative;
        }
        
        .process-step::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary-color), var(--primary-color));
        }
        
        .step-number {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .valuation-section {
            padding: 80px 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .valuation-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            margin-bottom: 30px;
        }
        
        .valuation-card:hover {
            transform: translateY(-5px);
        }
        
        .valuation-icon {
            width: 70px;
            height: 70px;
            background: var(--primary-color);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .valuation-icon i {
            color: white;
            font-size: 28px;
        }
        
        .success-metrics {
            padding: 80px 0;
            background: white;
        }
        
        .metric-item {
            text-align: center;
            padding: 30px;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            margin-bottom: 30px;
        }
        
        .metric-number {
            font-size: 3rem;
            font-weight: bold;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .metric-label {
            color: var(--secondary-color);
            font-weight: 600;
        }
        
        .deal-stages {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 80px 0;
        }
        
        .stage-card {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .stage-icon {
            width: 60px;
            height: 60px;
            background: rgba(255,255,255,0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .stage-icon i {
            color: white;
            font-size: 24px;
        }
        
        .btn-ma {
            background: linear-gradient(45deg, var(--primary-color), var(--primary-color));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        
        .btn-ma:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(220, 53, 69, 0.3);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="ma-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-light btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <i class="icofont-handshake" style="font-size: 150px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- MA Services -->
    <section class="ma-services">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['services_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="process-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
            <div class="row">
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">1</div>
                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">2</div>
                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">3</div>
                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">4</div>
                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Valuation Methods -->
    <section class="valuation-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['valuation_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="valuation-card">
                        <div class="valuation-icon">
                            <i class="<?php echo htmlspecialchars($page_data['valuation_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['valuation_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['valuation_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="valuation-card">
                        <div class="valuation-icon">
                            <i class="<?php echo htmlspecialchars($page_data['valuation_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['valuation_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['valuation_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="valuation-card">
                        <div class="valuation-icon">
                            <i class="<?php echo htmlspecialchars($page_data['valuation_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['valuation_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['valuation_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Success Metrics -->
    <section class="success-metrics">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['metrics_title']); ?></h2>
            <div class="row">
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_1_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_1_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_2_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_2_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_3_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_3_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_4_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_4_label']); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Deal Stages -->
    <section class="deal-stages">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['stages_title']); ?></h2>
            <div class="row">
                <div class="col-lg-6">
                    <div class="stage-card">
                        <div class="stage-icon">
                            <i class="<?php echo htmlspecialchars($page_data['stage_1_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['stage_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['stage_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="stage-card">
                        <div class="stage-icon">
                            <i class="<?php echo htmlspecialchars($page_data['stage_2_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['stage_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['stage_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="stage-card">
                        <div class="stage-icon">
                            <i class="<?php echo htmlspecialchars($page_data['stage_3_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['stage_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['stage_3_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="stage-card">
                        <div class="stage-icon">
                            <i class="<?php echo htmlspecialchars($page_data['stage_4_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['stage_4_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['stage_4_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" style="background: linear-gradient(45deg, var(--accent-color), var(--accent-color)); color: white; padding: 80px 0; text-align: center;">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-ma btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 