 <?php
// Script d'installation de la base de données pour la page Mergers & Acquisitions

// Inclusion des fichiers de configuration
include '../db.php';

// Lecture du fichier SQL
$sql_file = 'create_table.sql';
$sql_content = file_get_contents($sql_file);

if ($sql_content === false) {
    die("Erreur : Impossible de lire le fichier SQL");
}

// Exécution des requêtes SQL
$queries = explode(';', $sql_content);

foreach ($queries as $query) {
    $query = trim($query);
    if (!empty($query)) {
        try {
            if ($conn->query($query)) {
                echo "✓ Requête exécutée avec succès : " . substr($query, 0, 50) . "...<br>";
            } else {
                echo "✗ Erreur lors de l'exécution de la requête : " . $conn->error . "<br>";
            }
        } catch (Exception $e) {
            echo "✗ Exception lors de l'exécution : " . $e->getMessage() . "<br>";
        }
    }
}

// Vérification que les données ont été insérées
$check_query = "SELECT COUNT(*) as count FROM mergers_acquisitions WHERE page_name = 'Mergers & Acquisitions'";
$result = $conn->query($check_query);
$row = $result->fetch_assoc();

if ($row['count'] > 0) {
    echo "<br>✅ Installation terminée avec succès !<br>";
    echo "La table 'pages' a été créée et les données pour 'Mergers & Acquisitions' ont été insérées.<br>";
    echo "Vous pouvez maintenant accéder à la page : <a href='index.php'>Mergers & Acquisitions</a>";
} else {
    echo "<br>❌ Erreur : Les données n'ont pas été insérées correctement.<br>";
}

$conn->close();
?>