<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Mutual Funds";
$query = "SELECT * FROM mutual_funds WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Fonds Communs de Placement - GIFAM | Diversification et Performance',
        'meta_description' => 'Découvrez les avantages des fonds communs de placement avec GIFAM : diversification, gestion professionnelle, accessibilité et performance pour tous les profils d\'investisseurs.',
        'meta_keywords' => 'fonds communs de placement, mutual funds, diversification, gestion professionnelle, GIFAM, investissement collectif',
        'hero_title' => 'Fonds Communs de Placement',
        'hero_subtitle' => 'Accédez à une gestion collective performante et diversifiée, adaptée à tous les profils d\'investisseurs grâce à notre sélection de fonds mutualisés.',
        'hero_button_text' => 'Demander un Conseil',
        'hero_button_link' => '../contact-us/',
        'hero_image' => '../images/case-study/case-study-3.jpg',
        'advantages_title' => 'Pourquoi Choisir les Fonds Communs de Placement ?',
        'advantages_subtitle' => 'Les fonds mutualisés offrent une diversification instantanée, une gestion professionnelle et une accessibilité à tous les investisseurs, même avec un capital modeste.',
        'advantage_1_title' => 'Diversification',
        'advantage_1_icon' => 'icofont-chart-pie',
        'advantage_1_point_1' => 'Répartition sur de nombreux actifs',
        'advantage_1_point_2' => 'Réduction du risque spécifique',
        'advantage_1_point_3' => 'Accès à différents marchés',
        'advantage_2_title' => 'Gestion Professionnelle',
        'advantage_2_icon' => 'icofont-briefcase',
        'advantage_2_point_1' => 'Experts dédiés à la sélection des actifs',
        'advantage_2_point_2' => 'Suivi et ajustement permanents',
        'advantage_2_point_3' => 'Stratégies adaptées au marché',
        'advantage_3_title' => 'Performance Accessible',
        'advantage_3_icon' => 'icofont-money-bag',
        'advantage_3_point_1' => 'Investissement dès 100 €',
        'advantage_3_point_2' => 'Frais mutualisés réduits',
        'advantage_3_point_3' => 'Transparence et liquidité',
        'funds_types_title' => 'Types de Fonds Proposés',
        'funds_types_subtitle' => 'GIFAM sélectionne pour vous les meilleurs fonds selon votre profil et vos objectifs.',
        'fund_1_title' => 'Fonds Actions',
        'fund_1_icon' => 'icofont-globe',
        'fund_1_point_1' => 'Investissement en actions internationales',
        'fund_1_point_2' => 'Potentiel de croissance élevé',
        'fund_1_point_3' => 'Adapté aux profils dynamiques',
        'fund_2_title' => 'Fonds Obligataires',
        'fund_2_icon' => 'icofont-bank',
        'fund_2_point_1' => 'Investissement en obligations publiques et privées',
        'fund_2_point_2' => 'Stabilité et rendement régulier',
        'fund_2_point_3' => 'Idéal pour les profils prudents',
        'fund_3_title' => 'Fonds Diversifiés',
        'fund_3_icon' => 'icofont-pie-chart',
        'fund_3_point_1' => 'Mix d\'actions, obligations et autres actifs',
        'fund_3_point_2' => 'Équilibre entre risque et rendement',
        'fund_3_point_3' => 'Gestion flexible',
        'process_title' => 'Notre Processus d\'Investissement',
        'process_subtitle' => 'Un accompagnement personnalisé à chaque étape pour optimiser votre investissement collectif.',
        'step_1_title' => 'Analyse du Profil',
        'step_1_icon' => 'icofont-users-alt-3',
        'step_1_description' => 'Évaluation de vos objectifs, horizon de placement et tolérance au risque.',
        'step_2_title' => 'Sélection des Fonds',
        'step_2_icon' => 'icofont-handshake-deal',
        'step_2_description' => 'Choix des fonds adaptés à votre profil et au contexte de marché.',
        'step_3_title' => 'Gestion et Suivi',
        'step_3_icon' => 'icofont-chart-growth',
        'step_3_description' => 'Suivi régulier, rééquilibrage et reporting transparent de votre portefeuille.',
        'step_4_title' => 'Optimisation Fiscale',
        'step_4_icon' => 'icofont-certificate',
        'step_4_description' => 'Conseils pour maximiser le rendement net après impôts.',
        'cta_title' => 'Investissez Facilement et Sereinement',
        'cta_subtitle' => 'Contactez nos conseillers pour une stratégie de fonds communs personnalisée et bénéficiez d\'une gestion professionnelle.',
        'cta_button_text' => 'Prendre Rendez-vous',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $url; ?>mutual-funds/">
    <meta property="og:title" content="Fonds Communs de Placement - GIFAM">
    <meta property="og:description" content="Diversification, gestion professionnelle et performance avec les fonds communs de placement GIFAM.">
    <meta property="og:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo $url; ?>mutual-funds/">
    <meta property="twitter:title" content="Fonds Communs de Placement - GIFAM">
    <meta property="twitter:description" content="Diversification, gestion professionnelle et performance avec les fonds communs de placement GIFAM.">
    <meta property="twitter:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $url; ?>images/logos/fav.png">
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    <style>
        .funds-hero {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        .funds-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('<?php echo $url; ?>images/primary-blur-bg.png') center/cover;
            opacity: 0.1;
        }
        .funds-hero .container { position: relative; z-index: 2; }
        .funds-section { padding: 80px 0; }
        .funds-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #f0f0f0;
        }
        .funds-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
        }
        .funds-icon {
            width: 80px; height: 80px;
            background: #DB2913;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            margin-bottom: 25px; color: white; font-size: 2rem;
        }
        .funds-list li {
            padding-left: 25px; position: relative; margin-bottom: 10px;
        }
        .funds-list li::before {
            content: '✓'; position: absolute; left: 0; color: #ff6b35; font-weight: bold;
        }
        .cta-section {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white; padding: 80px 0; text-align: center;
        }
        .cta-button {
            background: #DB2913;
            color: white; padding: 15px 40px; border-radius: 50px;
            text-decoration: none; font-weight: 600; display: inline-block;
            margin-top: 30px; transition: all 0.3s ease; border: none;
        }
        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(219,41,19,0.4);
            color: white; text-decoration: none;
        }
        .btn-primary {
            background: #DB2913 !important;
            border-color: #DB2913 !important;
        }
        .btn-primary:hover, .btn-primary:focus {
            background: #a81f0f !important;
            border-color: #a81f0f !important;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>
<!-- Hero Section -->
<section class="funds-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                <div class="hero-buttons">
                    <a href="<?php echo $url . htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-primary btn-lg me-3"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    <a href="#funds-types" class="btn btn-outline-light btn-lg">Types de Fonds</a>
                </div>
            </div>
            <div class="col-lg-6">
                <img src="<?php echo $url . htmlspecialchars($page_data['hero_image']); ?>" alt="Fonds Communs de Placement" class="img-fluid rounded-3">
            </div>
        </div>
    </div>
</section>
<!-- Avantages des fonds communs -->
<section class="funds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['advantages_title']); ?></h2>
                <p class="lead"><?php echo htmlspecialchars($page_data['advantages_subtitle']); ?></p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['advantage_1_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['advantage_1_title']); ?></h4>
                    <ul class="funds-list">
                        <li><?php echo htmlspecialchars($page_data['advantage_1_point_1']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['advantage_1_point_2']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['advantage_1_point_3']); ?></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['advantage_2_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['advantage_2_title']); ?></h4>
                    <ul class="funds-list">
                        <li><?php echo htmlspecialchars($page_data['advantage_2_point_1']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['advantage_2_point_2']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['advantage_2_point_3']); ?></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['advantage_3_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['advantage_3_title']); ?></h4>
                    <ul class="funds-list">
                        <li><?php echo htmlspecialchars($page_data['advantage_3_point_1']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['advantage_3_point_2']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['advantage_3_point_3']); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Types de fonds -->
<section id="funds-types" class="funds-section">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['funds_types_title']); ?></h2>
                <p class="lead"><?php echo htmlspecialchars($page_data['funds_types_subtitle']); ?></p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['fund_1_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['fund_1_title']); ?></h4>
                    <ul class="funds-list">
                        <li><?php echo htmlspecialchars($page_data['fund_1_point_1']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['fund_1_point_2']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['fund_1_point_3']); ?></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['fund_2_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['fund_2_title']); ?></h4>
                    <ul class="funds-list">
                        <li><?php echo htmlspecialchars($page_data['fund_2_point_1']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['fund_2_point_2']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['fund_2_point_3']); ?></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['fund_3_icon']); ?>"></i></div>
                    <h4><?php echo htmlspecialchars($page_data['fund_3_title']); ?></h4>
                    <ul class="funds-list">
                        <li><?php echo htmlspecialchars($page_data['fund_3_point_1']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['fund_3_point_2']); ?></li>
                        <li><?php echo htmlspecialchars($page_data['fund_3_point_3']); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Processus d'investissement -->
<section class="funds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
                <p class="lead"><?php echo htmlspecialchars($page_data['process_subtitle']); ?></p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['step_1_icon']); ?>"></i></div>
                    <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['step_2_icon']); ?>"></i></div>
                    <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['step_3_icon']); ?>"></i></div>
                    <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="<?php echo htmlspecialchars($page_data['step_4_icon']); ?>"></i></div>
                    <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                    <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="display-5 fw-bold mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
                <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                <a href="<?php echo $url . htmlspecialchars($page_data['cta_button_link']); ?>" class="cta-button"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
            </div>
        </div>
    </div>
</section>
<?php include '../footer.php'; ?>
<!-- JavaScript Files -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>
<script>
    $(document).ready(function() {
        // Smooth scrolling for anchor links
        $('a[href^="#"]').on('click', function(event) {
            var target = $(this.getAttribute('href'));
            if (target.length) {
                event.preventDefault();
                $('html, body').stop().animate({
                    scrollTop: target.offset().top - 100
                }, 1000);
            }
        });
        // Hover effect
        $('.funds-card').hover(
            function() { $(this).find('.funds-icon').css('transform', 'scale(1.1)'); },
            function() { $(this).find('.funds-icon').css('transform', 'scale(1)'); }
        );
    });
</script>
</body>
</html> 
