<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Our Services";
$query = "SELECT * FROM our_services WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Our Services',
        'meta_description' => 'Comprehensive financial consulting services. From project financing to investment analysis, GIFAM offers expert solutions for all your business needs.',
        'meta_keywords' => 'financial consulting, project financing, investment analysis, risk management, GIFAM services',
        'page_subtitle' => 'As a consulting firm, GIFAM specializes in financial solutions and project financing, offering a diverse range of services to its clients.',
        'service_1_title' => 'Project Financing Consultation',
        'service_1_description' => 'GIFAM can offer expert advice on securing financing for large-scale projects. This includes evaluating project feasibility, assisting in the preparation of financial documents and proposals.',
        'service_1_link' => '../business-loan/',
        'service_1_image' => 'wp-content/uploads/2016/11/service-4.jpg',
        'service_2_title' => 'Investment Analysis and Advisory',
        'service_2_description' => 'Providing clients with comprehensive investment analysis and advice is crucial. This service would involve assessing investment opportunities, performing market analysis, and offering strategic recommendations.',
        'service_2_link' => '../insurance-consulting/',
        'service_2_image' => 'wp-content/uploads/2016/11/service-5.jpg',
        'service_3_title' => 'Risk Management Consulting',
        'service_3_description' => 'In any financial venture, managing risk is paramount. GIFAM can offer risk assessment and mitigation strategies, helping clients understand potential risks in their projects or investments and advising on how to manage or hedge these risks effectively.',
        'service_3_link' => '../financial-planning/',
        'service_3_image' => 'wp-content/uploads/2016/11/service-1.jpg',
        'service_4_title' => 'Asset Management and Portfolio Diversification',
        'service_4_description' => 'For clients with substantial assets, GIFAM can provide asset management services, including portfolio diversification advice.',
        'service_4_link' => '../retairement-planning/',
        'service_4_image' => 'wp-content/uploads/2016/11/service-6.jpg',
        'service_5_title' => 'Market Entry and Expansion Strategy',
        'service_5_description' => 'For clients looking to enter new markets or expand their operations, GIFAM can offer strategic consulting. This service includes market research.',
        'service_5_link' => '../taxes-planning/',
        'service_5_image' => 'wp-content/uploads/2016/11/service-3.jpg',
        'service_6_title' => 'Corporate Financial Strategy Development',
        'service_6_description' => 'GIFAM can assist clients in developing and refining their overall financial strategies. This includes advising on capital structure, investment strategies, financial planning, and long-term financial policy development.',
        'service_6_link' => '../business-growth/',
        'service_6_image' => '../wp-content/uploads/2016/11/service-8.jpg',
        'service_7_title' => 'Mergers and Acquisitions (M&A) Advisory',
        'service_7_description' => 'GIFAM can offer expertise in the area of mergers and acquisitions. This service includes conducting due diligence, valuation, structuring deals, negotiating terms, and providing post-merger integration advice.',
        'service_7_link' => '../investment-management/',
        'service_7_image' => 'wp-content/uploads/2016/11/service-2.jpg',
        'service_8_title' => 'Sustainability and Environmental',
        'service_8_description' => 'As sustainability becomes increasingly important, GIFAM can provide guidance on integrating ESG factors into business strategies. This includes advising on sustainable practices, ESG reporting, and how to align business operations with broader sustainability goals.',
        'service_8_link' => '../investment-in-bonds/',
        'service_8_image' => 'wp-content/uploads/2016/11/service-9.jpg',
        'service_9_title' => 'Regulatory Compliance and Governance Advisory',
        'service_9_description' => 'GIFAM can assist clients in navigating the complex regulatory environment. This service includes advising on compliance with local and international regulations, corporate governance practices, and risk governance frameworks.',
        'service_9_link' => '../mutual-funds/',
        'service_9_image' => 'wp-content/uploads/2016/11/service-7.jpg',
        'footer_text_1' => 'GIFAM\'S services are meant to cater to various aspects',
        'footer_text_2' => 'of corporate finance and business strategy.',
        'footer_text_3' => 'They position GIFAM as a versatile and capable consulting firm, able to address',
        'footer_text_4' => 'a wide range of client needs in the financial and business consulting domain.'
    ];
}
?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta name="author" content="thecodude">
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="../images/logos/fav.png">

    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="../css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="../css/animate.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css"> <!-- Template Stylesheet -->
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">		
		     <!-- Breadcrumb Start -->

             <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="./">Our Services</a></li>
                    </ul>
                    
                </div>
            </div>
        </div>
    </div>

    <!-- Breadcrumb End -->			
		<div class="page_title" style="background-image:url(<?php echo $url; ?>wp-content/uploads/2023/12/inner-banner4-1.jpg )">	

		</div>
							<div class="bread-cumb">
						<div class="container">
                            <br>
							<!-- Breadcrumb NavXT 7.4.1 -->
                            <p class="page-subtitle"><?php echo htmlspecialchars($page_data['page_subtitle']); ?></p>
</span>						</div>
					</div>
							<div class="container main-container">
			<div class="content-area">
						<div class="entry-content">
					<div class="wpb-content-wrapper"><div class="vc_row wpb_row vc_row-fluid awsm-creation-padings vc_custom_1487339918485 vc_row-has-fill"><div class="wpb_column vc_column_container vc_col-sm-12"><div class="vc_column-inner"><div class="wpb_wrapper"><div class="vc_empty_space" style="height: 20px"><span class="vc_empty_space_inner"></span></div>
		<div class="row">
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_1_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_1_title']); ?>"><img fetchpriority="high" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_1_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_1_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_1_image']); ?> 300w" sizes="(max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_1_link']); ?>"><?php echo htmlspecialchars($page_data['service_1_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
             </div>
             </div>
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_2_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_2_title']); ?>"><img decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_2_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_2_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_2_image']); ?> 300w" sizes="(max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_2_link']); ?>"><?php echo htmlspecialchars($page_data['service_2_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
             </div>
             </div>
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_3_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_3_title']); ?>"><img decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_3_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_3_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_3_image']); ?> 300w" sizes="(max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_3_link']); ?>"><?php echo htmlspecialchars($page_data['service_3_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
             </div>
             </div>
			
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_4_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_4_title']); ?>"><img loading="lazy" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_4_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_4_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_4_image']); ?> 300w" sizes="auto, (max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_4_link']); ?>"><?php echo htmlspecialchars($page_data['service_4_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_4_description']); ?></p>
             </div>
             </div>
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_5_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_5_title']); ?>"><img loading="lazy" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_5_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_5_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_5_image']); ?> 300w" sizes="auto, (max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_5_link']); ?>"><?php echo htmlspecialchars($page_data['service_5_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_5_description']); ?></p>
             </div>
             </div>
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_6_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_6_title']); ?>"><img loading="lazy" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_6_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_6_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_6_image']); ?> 300w" sizes="auto, (max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_6_link']); ?>"><?php echo htmlspecialchars($page_data['service_6_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_6_description']); ?></p>
             </div>
             </div>
			
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_7_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_7_title']); ?>"><img loading="lazy" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_7_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_7_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_7_image']); ?> 300w" sizes="auto, (max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_7_link']); ?>"><?php echo htmlspecialchars($page_data['service_7_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_7_description']); ?></p>
             </div>
             </div>
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_8_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_8_title']); ?>"><img loading="lazy" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_8_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_8_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_8_image']); ?> 300w" sizes="auto, (max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_8_link']); ?>"><?php echo htmlspecialchars($page_data['service_8_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_8_description']); ?></p>
             </div>
             </div>
			<div class="col-lg-4 col-md-6 mb-4">
                <div class="item">
                 <div class="post-image img-holder"><a href="<?php echo $url . htmlspecialchars($page_data['service_9_link']); ?>" title="<?php echo htmlspecialchars($page_data['service_9_title']); ?>"><img loading="lazy" decoding="async" width="370" height="243" src="<?php echo $url . htmlspecialchars($page_data['service_9_image']); ?>" class="attachment-medium-thumb size-medium-thumb wp-post-image" alt="" srcset="<?php echo $url . htmlspecialchars($page_data['service_9_image']); ?> 370w, <?php echo $url . htmlspecialchars($page_data['service_9_image']); ?> 300w" sizes="auto, (max-width: 370px) 100vw, 370px"></a>

                   <a href="#" class="four_arrow_hover_box"><span class="arrows"><span></span></span></a>
                 </div> 
                 
             
                 <h3><a href="<?php echo $url . htmlspecialchars($page_data['service_9_link']); ?>"><?php echo htmlspecialchars($page_data['service_9_title']); ?></a></h3>
                 <p><?php echo htmlspecialchars($page_data['service_9_description']); ?></p>
             </div>
             </div>
		</div></div></div></div></div><div class="vc_row wpb_row vc_row-fluid"><div class="wpb_column vc_column_container vc_col-sm-12"><div class="wpb_column-inner"><div class="wpb_wrapper">
	<div class="wpb_text_column wpb_content_element ">
		<div class="wpb_wrapper">
			<hr>
<p>&nbsp;</p>
<p style="text-align: center;"><strong><?php echo htmlspecialchars($page_data['footer_text_1']); ?></strong></p>
<p style="text-align: center;"><strong><?php echo htmlspecialchars($page_data['footer_text_2']); ?></strong></p>
<p style="text-align: center;"><strong><?php echo htmlspecialchars($page_data['footer_text_3']); ?></strong></p>
<p style="text-align: center;"><strong><?php echo htmlspecialchars($page_data['footer_text_4']); ?></strong></p>

		</div>
	</div>
</div></div></div></div>
</div>				</div>
					</div>
		</div> <!--.container-->
		</div>

<?php include '../footer.php'; ?>

</body>
</html>
