<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Project Financing Consultation";
$query = "SELECT * FROM project_financing_consultation WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Project Financing Consultation',
        'meta_description' => 'Expertise in international project financing. Tailored solutions for your investment and development projects.',
        'meta_keywords' => 'project financing, financial consulting, investment, project development, GIFAM',
        'hero_title' => 'Project Financing Consultation',
        'hero_subtitle' => 'Transform your ideas into reality with our international project financing expertise. Tailored solutions for your ambitions.',
        'hero_button_text' => 'Start your project',
        'hero_button_link' => '#contact',
        'services_title' => 'Our Financing Solutions',
        'service_1_title' => 'Bank Financing',
        'service_1_description' => 'Privileged access to international banking networks for optimal conditions.',
        'service_1_icon' => 'icofont-bank',
        'service_2_title' => 'Private Investment',
        'service_2_description' => 'Connections with private investors and specialized investment funds.',
        'service_2_icon' => 'icofont-chart-line',
        'service_3_title' => 'International Financing',
        'service_3_description' => 'Financing solutions adapted to cross-border and international projects.',
        'service_3_icon' => 'icofont-globe',
        'process_title' => 'Our Process',
        'step_1_title' => 'Project Analysis',
        'step_1_description' => 'In-depth analysis of your project\'s financial needs and viability.',
        'step_2_title' => 'Financing Strategy',
        'step_2_description' => 'Development of a personalized financing strategy with optimal conditions.',
        'step_3_title' => 'Partner Selection',
        'step_3_description' => 'Identification and connection with the best financing partners.',
        'step_4_title' => 'Implementation',
        'step_4_description' => 'Support throughout the financing process until project completion.',
        'benefits_title' => 'Why Choose Us',
        'benefit_1_title' => 'Global Network',
        'benefit_1_description' => 'Access to international financing networks and specialized partners.',
        'benefit_1_icon' => 'icofont-network',
        'benefit_2_title' => 'Expertise',
        'benefit_2_description' => 'Deep knowledge of financing mechanisms and market conditions.',
        'benefit_2_icon' => 'icofont-graduate',
        'benefit_3_title' => 'Personalized Approach',
        'benefit_3_description' => 'Tailored solutions adapted to the specific needs of your project.',
        'benefit_3_icon' => 'icofont-users',
        'sectors_title' => 'Sectors We Serve',
        'sector_1_title' => 'Infrastructure',
        'sector_1_description' => 'Financing for roads, bridges, energy and telecommunications projects.',
        'sector_1_icon' => 'icofont-building',
        'sector_2_title' => 'Real Estate',
        'sector_2_description' => 'Financing for commercial, residential and industrial real estate projects.',
        'sector_2_icon' => 'icofont-home',
        'sector_3_title' => 'Technology',
        'sector_3_description' => 'Financing for innovative technology projects and digital transformation.',
        'sector_3_icon' => 'icofont-laptop',
        'cta_title' => 'Ready to finance your project?',
        'cta_subtitle' => 'Our team of financing experts is here to support you.',
        'cta_button_text' => 'Start your project',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        :root {
            --primary-color: #dc3545;
            --secondary-color: #212529;
            --accent-color: #ff6b6b;
            --light-bg: #f8f9fa;
        }
        
        .project-financing-hero {
            background: linear-gradient(135deg, var(--secondary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .project-financing-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .service-features {
            background: var(--light-bg);
            padding: 80px 0;
        }
        
        .feature-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
            border-left: 5px solid var(--primary-color);
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
        }
        
        .feature-icon {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .feature-icon i {
            color: white;
            font-size: 24px;
        }
        
        .process-section {
            padding: 80px 0;
            background: white;
        }
        
        .process-step {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .process-number {
            width: 80px;
            height: 80px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            font-weight: bold;
            margin: 0 auto 20px;
        }
        
        .benefits-section {
            background: var(--light-bg);
            padding: 80px 0;
        }
        
        .benefit-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        
        .benefit-card:hover {
            transform: translateY(-5px);
        }
        
        .benefit-icon {
            width: 70px;
            height: 70px;
            background: var(--primary-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .benefit-icon i {
            color: white;
            font-size: 28px;
        }
        
        .sectors-section {
            padding: 80px 0;
            background: white;
        }
        
        .sector-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .sector-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
        }
        
        .sector-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .sector-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .sector-icon i {
            color: white;
            font-size: 32px;
        }
        
        .cta-section {
            background: linear-gradient(45deg, var(--secondary-color), var(--secondary-color));
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .btn-custom {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 30px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        
        .btn-custom:hover {
            background: var(--primary-color);
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="project-financing-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-light btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <i class="icofont-coins" style="font-size: 120px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Features -->
    <section class="service-features">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['services_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="process-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
            <div class="row">
                <div class="col-lg-3">
                    <div class="process-step">
                        <div class="process-number">1</div>
                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="process-step">
                        <div class="process-number">2</div>
                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="process-step">
                        <div class="process-number">3</div>
                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="process-step">
                        <div class="process-number">4</div>
                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section class="benefits-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['benefits_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon">
                            <i class="<?php echo htmlspecialchars($page_data['benefit_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['benefit_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['benefit_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon">
                            <i class="<?php echo htmlspecialchars($page_data['benefit_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['benefit_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['benefit_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon">
                            <i class="<?php echo htmlspecialchars($page_data['benefit_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['benefit_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['benefit_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sectors Section -->
    <section class="sectors-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['sectors_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="sector-card">
                        <div class="sector-icon">
                            <i class="<?php echo htmlspecialchars($page_data['sector_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['sector_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['sector_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="sector-card">
                        <div class="sector-icon">
                            <i class="<?php echo htmlspecialchars($page_data['sector_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['sector_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['sector_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="sector-card">
                        <div class="sector-icon">
                            <i class="<?php echo htmlspecialchars($page_data['sector_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['sector_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['sector_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-custom btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 
