<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Retirement Planning";
$query = "SELECT * FROM retirement_planning WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Retirement Planning',
        'meta_description' => 'Comprehensive retirement planning services to help you secure your financial future. Expert guidance for retirement strategies and wealth preservation.',
        'meta_keywords' => 'retirement planning, financial planning, retirement strategies, wealth preservation, GIFAM',
        'hero_title' => 'Retirement Planning',
        'hero_subtitle' => 'Secure your financial future with our comprehensive retirement planning services. Expert guidance to help you build and preserve wealth for a comfortable retirement.',
        'services_title' => 'Our Retirement Planning Services',
        'service_1_title' => 'Retirement Analysis',
        'service_1_description' => 'Comprehensive analysis of your current retirement readiness and identification of funding gaps.',
        'service_1_icon' => 'icofont-chart-flow-alt-1',
        'service_1_feature_1' => 'Retirement readiness assessment',
        'service_1_feature_2' => 'Funding gap analysis',
        'service_1_feature_3' => 'Lifestyle planning',
        'service_2_title' => 'Retirement Strategy',
        'service_2_description' => 'Development of personalized retirement strategies aligned with your goals and timeline.',
        'service_2_icon' => 'icofont-chart-pie',
        'service_2_feature_1' => 'Goal-based planning',
        'service_2_feature_2' => 'Timeline optimization',
        'service_2_feature_3' => 'Risk management',
        'service_3_title' => 'Wealth Preservation',
        'service_3_description' => 'Strategies to protect and grow your retirement assets throughout your golden years.',
        'service_3_icon' => 'icofont-dashboard-web',
        'service_3_feature_1' => 'Asset protection',
        'service_3_feature_2' => 'Estate planning',
        'service_3_feature_3' => 'Tax optimization',
        'strategies_title' => 'Retirement Planning Strategies',
        'strategy_1_title' => 'Early Planning',
        'strategy_1_description' => 'Starting retirement planning early to maximize compound growth and savings potential.',
        'strategy_1_icon' => 'icofont-calendar',
        'strategy_2_title' => 'Diversified Savings',
        'strategy_2_description' => 'Utilizing multiple retirement vehicles for optimal tax efficiency and flexibility.',
        'strategy_2_icon' => 'icofont-piggy-bank',
        'strategy_3_title' => 'Income Planning',
        'strategy_3_description' => 'Creating reliable income streams for retirement through various investment strategies.',
        'strategy_3_icon' => 'icofont-chart-line',
        'strategy_4_title' => 'Healthcare Planning',
        'strategy_4_description' => 'Addressing healthcare costs and long-term care needs in retirement planning.',
        'strategy_4_icon' => 'icofont-heart-beat',
        'vehicles_title' => 'Retirement Vehicles',
        'vehicle_1_title' => '401(k) Plans',
        'vehicle_1_description' => 'Employer-sponsored retirement plans with tax advantages and potential employer matching.',
        'vehicle_1_icon' => 'icofont-building',
        'vehicle_2_title' => 'IRAs',
        'vehicle_2_description' => 'Individual retirement accounts offering tax-deferred or tax-free growth opportunities.',
        'vehicle_2_icon' => 'icofont-user',
        'vehicle_3_title' => 'Pension Plans',
        'vehicle_3_description' => 'Traditional defined benefit plans providing guaranteed income in retirement.',
        'vehicle_3_icon' => 'icofont-shield',
        'vehicle_4_title' => 'Annuities',
        'vehicle_4_description' => 'Insurance products providing guaranteed income streams for retirement.',
        'vehicle_4_icon' => 'icofont-coins',
        'process_title' => 'Our Retirement Planning Process',
        'step_1_title' => 'Assessment',
        'step_1_description' => 'Comprehensive analysis of your current financial situation and retirement goals.',
        'step_2_title' => 'Goal Setting',
        'step_2_description' => 'Defining clear retirement objectives and timeline based on your lifestyle preferences.',
        'step_3_title' => 'Strategy Development',
        'step_3_description' => 'Creating a personalized retirement strategy with optimal savings and investment plans.',
        'step_4_title' => 'Implementation & Monitoring',
        'step_4_description' => 'Executing the retirement plan with ongoing monitoring and adjustments.',
        'benefits_title' => 'Benefits of Professional Retirement Planning',
        'benefit_1_title' => 'Peace of Mind',
        'benefit_1_description' => 'Confidence knowing your retirement is properly planned and on track.',
        'benefit_1_icon' => 'icofont-heart',
        'benefit_2_title' => 'Tax Efficiency',
        'benefit_2_description' => 'Optimized strategies to minimize taxes and maximize retirement savings.',
        'benefit_2_icon' => 'icofont-calculator',
        'benefit_3_title' => 'Risk Management',
        'benefit_3_description' => 'Protection against market volatility and unexpected life events.',
        'benefit_3_icon' => 'icofont-shield-alt',
        'cta_title' => 'Ready to secure your retirement future?',
        'cta_subtitle' => 'Our team of retirement planning experts is here to help you build a secure financial future.',
        'cta_button_text' => 'Start planning',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="../images/logos/fav.png">

    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="../css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="../css/animate.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        .retirement-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #28a745;
        }
        
        .service-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
            height: 100%;
        }
        
        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        
        .service-card h4 {
            color: #28a745;
            margin-bottom: 15px;
        }
        
        .strategy-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            text-align: center;
        }
        
        .strategy-card:hover {
            transform: translateY(-5px);
        }
        
        .strategy-icon {
            width: 70px;
            height: 70px;
            background: #28a745;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .strategy-icon i {
            color: white;
            font-size: 28px;
        }
        
        .vehicle-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .vehicle-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, #28a745, #28a745);
        }
        
        .vehicle-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .vehicle-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #28a745, #28a745);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .vehicle-icon i {
            color: white;
            font-size: 32px;
        }
        
        .process-section {
            background: #f8f9fa;
            padding: 80px 0;
        }
        
        .process-step {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .process-number {
            width: 80px;
            height: 80px;
            background: #28a745;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            font-weight: bold;
            margin: 0 auto 20px;
        }
        
        .benefits-section {
            padding: 80px 0;
            background: white;
        }
        
        .benefit-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        
        .benefit-card:hover {
            transform: translateY(-5px);
        }
        
        .benefit-icon {
            width: 70px;
            height: 70px;
            background: #28a745;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .benefit-icon i {
            color: white;
            font-size: 28px;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>our-services/">Our Services</a></li>
                        <li class="breadcrumb-item"><a href="./"><?php echo htmlspecialchars($page_data['page_title']); ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Page Title -->
    <br><br>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>wp-content/uploads/2016/11/service-6.jpg" alt="Retirement Planning" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Services Grid -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['services_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>" style="font-size: 3rem; color: #007bff;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_feature_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_feature_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_feature_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_feature_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_feature_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_feature_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>" style="font-size: 3rem; color: #ffc107;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_feature_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_feature_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_feature_3']); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Retirement Strategies -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['strategies_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_1_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_1_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_2_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_2_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_3_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_3_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_4_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_4_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_4_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Retirement Vehicles -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['vehicles_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="vehicle-card">
                                <div class="vehicle-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['vehicle_1_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['vehicle_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['vehicle_1_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="vehicle-card">
                                <div class="vehicle-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['vehicle_2_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['vehicle_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['vehicle_2_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="vehicle-card">
                                <div class="vehicle-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['vehicle_3_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['vehicle_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['vehicle_3_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="vehicle-card">
                                <div class="vehicle-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['vehicle_4_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['vehicle_4_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['vehicle_4_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Process Section -->
                    <div class="process-section">
                        <div class="container">
                            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
                            <div class="row">
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">1</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">2</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">3</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">4</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Benefits Section -->
                    <div class="benefits-section">
                        <div class="container">
                            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['benefits_title']); ?></h2>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="benefit-card">
                                        <div class="benefit-icon">
                                            <i class="<?php echo htmlspecialchars($page_data['benefit_1_icon']); ?>"></i>
                                        </div>
                                        <h4><?php echo htmlspecialchars($page_data['benefit_1_title']); ?></h4>
                                        <p><?php echo htmlspecialchars($page_data['benefit_1_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="benefit-card">
                                        <div class="benefit-icon">
                                            <i class="<?php echo htmlspecialchars($page_data['benefit_2_icon']); ?>"></i>
                                        </div>
                                        <h4><?php echo htmlspecialchars($page_data['benefit_2_title']); ?></h4>
                                        <p><?php echo htmlspecialchars($page_data['benefit_2_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="benefit-card">
                                        <div class="benefit-icon">
                                            <i class="<?php echo htmlspecialchars($page_data['benefit_3_icon']); ?>"></i>
                                        </div>
                                        <h4><?php echo htmlspecialchars($page_data['benefit_3_title']); ?></h4>
                                        <p><?php echo htmlspecialchars($page_data['benefit_3_description']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="retirement-section text-center">
                        <h2><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
                        <p class="lead"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn btn-success btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 
