<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Risk Management Consulting";
$query = "SELECT * FROM risk_management_consulting WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Risk Management Consulting',
        'meta_description' => 'Expertise in financial and operational risk management. Protect your investments with our advanced mitigation strategies.',
        'meta_keywords' => 'risk management, financial consulting, risk mitigation, risk analysis, GIFAM',
        'hero_title' => 'Risk Management Consulting',
        'hero_subtitle' => 'Protect your investments with our expertise in identifying, assessing and mitigating financial and operational risks.',
        'hero_button_text' => 'Assess your risks',
        'hero_button_link' => '#contact',
        'matrix_title' => 'Risk Assessment Matrix',
        'risk_1_title' => 'Low Risk',
        'risk_1_description' => 'Limited impact, reduced probability. Continuous monitoring recommended.',
        'risk_1_icon' => 'icofont-check-circled',
        'risk_2_title' => 'Moderate Risk',
        'risk_2_description' => 'Medium impact, moderate probability. Mitigation actions required.',
        'risk_2_icon' => 'icofont-warning',
        'risk_3_title' => 'High Risk',
        'risk_3_description' => 'High impact, significant probability. Immediate actions necessary.',
        'risk_3_icon' => 'icofont-error',
        'types_title' => 'Types of Risks',
        'type_1_title' => 'Market Risks',
        'type_1_description' => 'Price fluctuations, exchange rates, volatility of financial markets.',
        'type_1_icon' => 'icofont-chart-line',
        'type_2_title' => 'Credit Risks',
        'type_2_description' => 'Payment default, counterparty insolvency, credit quality deterioration.',
        'type_2_icon' => 'icofont-bank',
        'type_3_title' => 'Operational Risks',
        'type_3_description' => 'Human errors, technological failures, internal processes.',
        'type_3_icon' => 'icofont-gear',
        'methodology_title' => 'Our Methodology',
        'step_1_title' => 'Identification',
        'step_1_description' => 'Complete inventory of potential risks in your environment.',
        'step_2_title' => 'Assessment',
        'step_2_description' => 'Quantitative and qualitative analysis of impact and probability.',
        'step_3_title' => 'Mitigation',
        'step_3_description' => 'Development of risk reduction and transfer strategies.',
        'step_4_title' => 'Monitoring',
        'step_4_description' => 'Continuous monitoring and adjustment of protection strategies.',
        'protection_title' => 'Protection Solutions',
        'solution_1_title' => 'Hedging',
        'solution_1_description' => 'Coverage strategies to protect against market fluctuations.',
        'solution_1_icon' => 'icofont-shield-alt',
        'solution_2_title' => 'Diversification',
        'solution_2_description' => 'Optimized allocation to reduce risk concentration.',
        'solution_2_icon' => 'icofont-diversify',
        'solution_3_title' => 'Insurance',
        'solution_3_description' => 'Risk transfer to specialized insurers.',
        'solution_3_icon' => 'icofont-insurance',
        'cta_title' => 'Protect your investments now',
        'cta_subtitle' => 'Our team of risk management experts is here to support you.',
        'cta_button_text' => 'Assess your risks',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
  <!-- Inject:css -->
  <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        :root {
            --primary-color: #dc3545;
            --secondary-color: #212529;
            --accent-color:rgb(0, 0, 0);
            --success-color:rgb(0, 0, 0);
            --info-color:rgb(0, 0, 0);
            --warning-color:rgb(0, 0, 0);
        }
        
        .risk-hero {
            background: linear-gradient(135deg, var(--accent-color) 0%, var(--accent-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .risk-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="shield" width="20" height="20" patternUnits="userSpaceOnUse"><path d="M10 0 L20 5 L20 15 L10 20 L0 15 L0 5 Z" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23shield)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .risk-matrix {
            background: var(--light-bg);
            padding: 80px 0;
        }
        
        .matrix-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 40px;
        }
        
        .matrix-item {
            background: white;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .matrix-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
        }
        
        .matrix-item.low::before { background: var(--success-color); }
        .matrix-item.medium::before { background: var(--warning-color); }
        .matrix-item.high::before { background: var(--danger-color); }
        
        .matrix-item:hover {
            transform: translateY(-5px);
        }
        
        .risk-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .risk-icon i {
            color: white;
            font-size: 28px;
        }
        
        .risk-types {
            padding: 80px 0;
            background: white;
        }
        
        .risk-type-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            border-left: 5px solid var(--primary-color);
            transition: all 0.3s ease;
        }
        
        .risk-type-card:hover {
            transform: translateX(10px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
        }
        
        .risk-type-icon {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .risk-type-icon i {
            color: white;
            font-size: 24px;
        }
        
        .methodology-section {
            background: var(--secondary-color);
            color: white;
            padding: 80px 0;
        }
        
        .methodology-step {
            text-align: center;
            margin-bottom: 40px;
            padding: 30px;
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            backdrop-filter: blur(10px);
        }
        
        .step-number {
            width: 60px;
            height: 60px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            font-weight: bold;
            margin: 0 auto 20px;
        }
        
        .protection-section {
            padding: 80px 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .protection-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            margin-bottom: 30px;
        }
        
        .protection-card:hover {
            transform: translateY(-10px);
        }
        
        .protection-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--success-color), var(--success-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .protection-icon i {
            color: white;
            font-size: 32px;
        }
        
        .btn-risk {
            background: linear-gradient(45deg, var(--primary-color), var(--primary-color));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        
        .btn-risk:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(220, 53, 69, 0.3);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="risk-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-light btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <i class="icofont-shield" style="font-size: 150px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Risk Matrix -->
    <section class="risk-matrix">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['matrix_title']); ?></h2>
            <div class="matrix-grid">
                <div class="matrix-item low">
                    <div class="risk-icon">
                        <i class="<?php echo htmlspecialchars($page_data['risk_1_icon']); ?>"></i>
                    </div>
                    <h4><?php echo htmlspecialchars($page_data['risk_1_title']); ?></h4>
                    <p><?php echo htmlspecialchars($page_data['risk_1_description']); ?></p>
                </div>
                <div class="matrix-item medium">
                    <div class="risk-icon">
                        <i class="<?php echo htmlspecialchars($page_data['risk_2_icon']); ?>"></i>
                    </div>
                    <h4><?php echo htmlspecialchars($page_data['risk_2_title']); ?></h4>
                    <p><?php echo htmlspecialchars($page_data['risk_2_description']); ?></p>
                </div>
                <div class="matrix-item high">
                    <div class="risk-icon">
                        <i class="<?php echo htmlspecialchars($page_data['risk_3_icon']); ?>"></i>
                    </div>
                    <h4><?php echo htmlspecialchars($page_data['risk_3_title']); ?></h4>
                    <p><?php echo htmlspecialchars($page_data['risk_3_description']); ?></p>
                </div>
            </div>
        </div>
    </section>

    <!-- Risk Types -->
    <section class="risk-types">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['types_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="risk-type-card">
                        <div class="risk-type-icon">
                            <i class="<?php echo htmlspecialchars($page_data['type_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['type_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['type_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="risk-type-card">
                        <div class="risk-type-icon">
                            <i class="<?php echo htmlspecialchars($page_data['type_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['type_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['type_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="risk-type-card">
                        <div class="risk-type-icon">
                            <i class="<?php echo htmlspecialchars($page_data['type_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['type_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['type_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Methodology -->
    <section class="methodology-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['methodology_title']); ?></h2>
            <div class="row">
                <div class="col-lg-3">
                    <div class="methodology-step">
                        <div class="step-number">1</div>
                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="methodology-step">
                        <div class="step-number">2</div>
                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="methodology-step">
                        <div class="step-number">3</div>
                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="methodology-step">
                        <div class="step-number">4</div>
                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Protection Solutions -->
    <section class="protection-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['protection_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="protection-card">
                        <div class="protection-icon">
                            <i class="<?php echo htmlspecialchars($page_data['solution_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['solution_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['solution_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="protection-card">
                        <div class="protection-icon">
                            <i class="<?php echo htmlspecialchars($page_data['solution_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['solution_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['solution_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="protection-card">
                        <div class="protection-icon">
                            <i class="<?php echo htmlspecialchars($page_data['solution_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['solution_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['solution_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" style="background: linear-gradient(45deg, var(--accent-color), var(--accent-color)); color: white; padding: 80px 0; text-align: center;">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-risk btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 