<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Tax Planning Services";
$query = "SELECT * FROM taxes_planning WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Tax Planning Services',
        'meta_description' => 'GIFAM provides comprehensive tax planning services to help individuals and businesses optimize their tax position while ensuring full compliance with international tax regulations.',
        'meta_keywords' => 'tax planning, tax optimization, tax compliance, international tax, GIFAM tax services',
        'hero_title' => 'Tax Planning Services',
        'hero_subtitle' => 'GIFAM provides comprehensive tax planning services to help individuals and businesses optimize their tax position while ensuring full compliance with international tax regulations and maximizing legitimate tax savings.',
        'compliance_badge_1' => 'IRS Compliant',
        'compliance_badge_2' => 'International Tax Expert',
        'overview_title' => 'Strategic Tax Planning',
        'overview_text' => 'Our tax planning services are designed to help you navigate complex tax landscapes while maximizing your financial efficiency. We work with individuals, businesses, and multinational corporations to develop comprehensive tax strategies that align with your financial goals.',
        'approach_title' => 'Our Approach',
        'approach_1' => 'Comprehensive Analysis: Deep dive into your financial situation',
        'approach_2' => 'Strategic Planning: Long-term tax optimization strategies',
        'approach_3' => 'Compliance Focus: Ensuring all strategies are legally sound',
        'approach_4' => 'Regular Reviews: Ongoing monitoring and adjustments',
        'benefits_title' => 'Key Benefits',
        'benefit_1' => 'Tax Savings: Legitimate reduction in tax liability',
        'benefit_2' => 'Risk Management: Minimizing audit and compliance risks',
        'benefit_3' => 'Cash Flow Optimization: Better timing of tax payments',
        'benefit_4' => 'Peace of Mind: Expert guidance and support',
        'services_title' => 'Our Tax Planning Services',
        'service_1_title' => 'Individual Tax Planning',
        'service_1_description' => 'Comprehensive tax planning for individuals, including income tax optimization, retirement planning, and estate tax strategies.',
        'service_1_icon' => 'icofont-calculator-alt-1',
        'service_1_feature_1' => 'Income tax optimization',
        'service_1_feature_2' => 'Retirement account strategies',
        'service_1_feature_3' => 'Estate tax planning',
        'service_2_title' => 'Business Tax Planning',
        'service_2_description' => 'Strategic tax planning for businesses of all sizes, from startups to multinational corporations.',
        'service_2_icon' => 'icofont-building',
        'service_2_feature_1' => 'Corporate tax optimization',
        'service_2_feature_2' => 'International tax strategies',
        'service_2_feature_3' => 'Transfer pricing',
        'service_3_title' => 'International Tax',
        'service_3_description' => 'Expert guidance on cross-border tax issues, including expatriate taxation and international business structures.',
        'service_3_icon' => 'icofont-globe',
        'service_3_feature_1' => 'Expatriate tax planning',
        'service_3_feature_2' => 'Cross-border transactions',
        'service_3_feature_3' => 'Tax treaty optimization',
        'strategies_title' => 'Tax Planning Strategies',
        'strategy_1_title' => 'Income Deferral',
        'strategy_1_description' => 'Strategically timing income recognition to minimize tax liability in high-tax years.',
        'strategy_1_icon' => 'icofont-calendar',
        'strategy_2_title' => 'Deduction Optimization',
        'strategy_2_description' => 'Maximizing legitimate deductions and credits to reduce taxable income.',
        'strategy_2_icon' => 'icofont-calculator',
        'strategy_3_title' => 'Entity Structure',
        'strategy_3_description' => 'Optimizing business entity structure for maximum tax efficiency.',
        'strategy_3_icon' => 'icofont-building',
        'strategy_4_title' => 'Investment Planning',
        'strategy_4_description' => 'Tax-efficient investment strategies and portfolio management.',
        'strategy_4_icon' => 'icofont-chart-line',
        'compliance_title' => 'Compliance & Risk Management',
        'compliance_text' => 'We ensure all tax planning strategies are fully compliant with applicable laws and regulations.',
        'compliance_1' => 'Regular compliance reviews and updates',
        'compliance_2' => 'Audit support and representation',
        'compliance_3' => 'Risk assessment and mitigation',
        'compliance_4' => 'Documentation and record keeping',
        'process_title' => 'Our Tax Planning Process',
        'step_1_title' => 'Assessment',
        'step_1_description' => 'Comprehensive analysis of your current tax situation and financial goals.',
        'step_2_title' => 'Strategy Development',
        'step_2_description' => 'Development of personalized tax planning strategies aligned with your objectives.',
        'step_3_title' => 'Implementation',
        'step_3_description' => 'Execution of tax planning strategies with ongoing support and guidance.',
        'step_4_title' => 'Monitoring',
        'step_4_description' => 'Regular review and adjustment of strategies to ensure continued optimization.',
        'cta_title' => 'Ready to optimize your tax position?',
        'cta_subtitle' => 'Our team of tax planning experts is here to help you maximize your tax efficiency.',
        'cta_button_text' => 'Start tax planning',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM | Strategic Tax Optimization & Compliance</title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .tax-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .tax-benefit {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }
        
        .tax-benefit:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        
        .tax-benefit h5 {
            color: #d12907;
            margin-bottom: 15px;
        }
        
        .compliance-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .tax-strategy {
            background: #e3f2fd;
            border: 1px solid #2196f3;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .tax-table {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .tax-table table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .tax-table th,
        .tax-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        
        .tax-table th {
            background: #d12907;
            color: white;
            font-weight: 600;
        }
        
        .strategy-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            text-align: center;
        }
        
        .strategy-card:hover {
            transform: translateY(-5px);
        }
        
        .strategy-icon {
            width: 70px;
            height: 70px;
            background: #d12907;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .strategy-icon i {
            color: white;
            font-size: 28px;
        }
        
        .process-section {
            background: #f8f9fa;
            padding: 80px 0;
        }
        
        .process-step {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .process-number {
            width: 80px;
            height: 80px;
            background: #d12907;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            font-weight: bold;
            margin: 0 auto 20px;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>our-services/">Our Services</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>taxes-planning/">Tax Planning</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                            <div class="compliance-badge"><?php echo htmlspecialchars($page_data['compliance_badge_1']); ?></div>
                            <div class="compliance-badge"><?php echo htmlspecialchars($page_data['compliance_badge_2']); ?></div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-1.jpg" alt="Tax Planning Services" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Tax Planning Overview -->
                    <div class="tax-section">
                        <h2><?php echo htmlspecialchars($page_data['overview_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['overview_text']); ?></p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4><?php echo htmlspecialchars($page_data['approach_title']); ?></h4>
                                <ul>
                                    <li><strong><?php echo htmlspecialchars($page_data['approach_1']); ?></strong></li>
                                    <li><strong><?php echo htmlspecialchars($page_data['approach_2']); ?></strong></li>
                                    <li><strong><?php echo htmlspecialchars($page_data['approach_3']); ?></strong></li>
                                    <li><strong><?php echo htmlspecialchars($page_data['approach_4']); ?></strong></li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4><?php echo htmlspecialchars($page_data['benefits_title']); ?></h4>
                                <ul>
                                    <li><strong><?php echo htmlspecialchars($page_data['benefit_1']); ?></strong></li>
                                    <li><strong><?php echo htmlspecialchars($page_data['benefit_2']); ?></strong></li>
                                    <li><strong><?php echo htmlspecialchars($page_data['benefit_3']); ?></strong></li>
                                    <li><strong><?php echo htmlspecialchars($page_data['benefit_4']); ?></strong></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Services -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['services_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="tax-benefit">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>" style="font-size: 3rem; color: #d12907;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['service_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_feature_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_feature_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_feature_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="tax-benefit">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['service_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_feature_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_feature_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_feature_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="tax-benefit">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>" style="font-size: 3rem; color: #007bff;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['service_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_feature_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_feature_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_feature_3']); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Strategies -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['strategies_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_1_icon']); ?>"></i>
                            </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_1_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_2_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_2_description']); ?></p>
                    </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_3_icon']); ?>"></i>
                                        </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_3_description']); ?></p>
                                        </div>
                                    </div>
                                    
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="strategy-card">
                                <div class="strategy-icon">
                                    <i class="<?php echo htmlspecialchars($page_data['strategy_4_icon']); ?>"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['strategy_4_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['strategy_4_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Compliance Section -->
                    <div class="tax-section">
                        <h2><?php echo htmlspecialchars($page_data['compliance_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['compliance_text']); ?></p>
                        <ul>
                            <li><?php echo htmlspecialchars($page_data['compliance_1']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['compliance_2']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['compliance_3']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['compliance_4']); ?></li>
                                </ul>
                    </div>

                    <!-- Process Section -->
                    <div class="process-section">
                        <div class="container">
                            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
                        <div class="row">
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">1</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">2</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">3</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                            </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="process-step">
                                        <div class="process-number">4</div>
                                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                            </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="tax-section text-center">
                        <h2><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
                        <p class="lead"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn btn-primary btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 
