<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Terms and Conditions";
$query = "SELECT * FROM terms_and_conditions WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Terms and Conditions',
        'meta_description' => 'GIFAM\'s comprehensive terms and conditions outline the rules, rights, and responsibilities for using our services, website, and business operations.',
        'meta_keywords' => 'terms and conditions, service agreement, user terms, GIFAM terms, legal agreement',
        'hero_title' => 'Terms and Conditions',
        'hero_subtitle' => 'These Terms and Conditions govern your use of GIFAM\'s website, services, and business operations. By accessing or using our services, you agree to be bound by these terms and all applicable laws and regulations.',
        'last_updated' => '11, 07, 2025',
        'agreement_title' => 'Agreement to Terms',
        'agreement_text' => 'By accessing and using GIFAM\'s website or services, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions. If you do not agree to these terms, please do not use our services.',
        'intro_title' => '1. Introduction and Acceptance',
        'service_desc_title' => '1.1 Service Description',
        'service_desc_text' => 'GIFAM provides comprehensive investment and consulting services, including but not limited to:',
        'service_1_category' => 'Investment Services',
        'service_1_description' => 'Portfolio management, investment analysis, and financial advisory',
        'service_1_scope' => 'Global markets and asset classes',
        'service_2_category' => 'Consulting Services',
        'service_2_description' => 'Business strategy, feasibility studies, and project management',
        'service_2_scope' => 'Multiple industries and sectors',
        'service_3_category' => 'Digital Services',
        'service_3_description' => 'Website access, online tools, and digital platforms',
        'service_3_scope' => '24/7 online availability',
        'service_4_category' => 'Support Services',
        'service_4_description' => 'Client support, technical assistance, and account management',
        'service_4_scope' => 'Dedicated client service',
        'eligibility_title' => '1.2 Eligibility',
        'eligibility_text' => 'To use our services, you must:',
        'eligibility_1' => 'Be at least 18 years old or have parental consent',
        'eligibility_2' => 'Have the legal capacity to enter into binding agreements',
        'eligibility_3' => 'Provide accurate and complete information',
        'eligibility_4' => 'Comply with all applicable laws and regulations',
        'account_title' => '1.3 Account Registration',
        'account_text' => 'When creating an account with GIFAM, you agree to:',
        'account_1' => 'Provide accurate, current, and complete information',
        'account_2' => 'Maintain and update your account information',
        'account_3' => 'Protect your account credentials and security',
        'account_4' => 'Notify us immediately of any unauthorized access',
        'services_title' => '2. Services and Use',
        'services_desc' => 'Our services are provided "as is" and may be modified, suspended, or discontinued at any time.',
        'prohibited_title' => '2.1 Prohibited Activities',
        'prohibited_text' => 'You agree not to:',
        'prohibited_1' => 'Use our services for any illegal or unauthorized purpose',
        'prohibited_2' => 'Attempt to gain unauthorized access to our systems',
        'prohibited_3' => 'Interfere with or disrupt our services',
        'prohibited_4' => 'Violate any applicable laws or regulations',
        'liability_title' => '3. Limitation of Liability',
        'liability_text' => 'GIFAM shall not be liable for any indirect, incidental, special, consequential, or punitive damages.',
        'privacy_title' => '4. Privacy and Data Protection',
        'privacy_text' => 'Your privacy is important to us. Please review our Privacy Policy for information on how we collect, use, and protect your data.',
        'termination_title' => '5. Termination',
        'termination_text' => 'We may terminate or suspend your access to our services at any time, with or without cause.',
        'changes_title' => '6. Changes to Terms',
        'changes_text' => 'We reserve the right to modify these terms at any time. Continued use of our services constitutes acceptance of any changes.',
        'contact_title' => '7. Contact Information',
        'contact_text' => 'If you have any questions about these Terms and Conditions, please contact us.',
        'contact_email' => 'legal@gifam.eu',
        'contact_phone' => '+1 (555) 123-4567'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM | Service Agreement & User Terms</title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .terms-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .agreement-box {
            background: #fff;
            border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .important-notice {
            background: #dc354521;
    border: 1px solid #dc354570;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .prohibited-activities {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .update-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .terms-highlight {
            background: #f8f9fa;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 15px 0;
        }
        
        .legal-notice {
                        background: #dc354521;
    border: 1px solid #dc354570;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .service-table {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .service-table table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .service-table th,
        .service-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        
        .service-table th {
            background: #d12907;
            color: white;
            font-weight: 600;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>terms-and-conditions/">Terms and Conditions</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                            <div class="update-badge">Last Updated: <?php echo htmlspecialchars($page_data['last_updated']); ?></div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-5.jpg" alt="Terms and Conditions" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Agreement Notice -->
                    <div class="agreement-box">
                        <h4><i class="icofont-handshake-deal text-primary"></i> <?php echo htmlspecialchars($page_data['agreement_title']); ?></h4>
                        <p class="mb-0"><strong><?php echo htmlspecialchars($page_data['agreement_text']); ?></strong></p>
                    </div>

                    <!-- Introduction -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['intro_title']); ?></h2>
                        
                        <h4><?php echo htmlspecialchars($page_data['service_desc_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_desc_text']); ?></p>
                        
                        <div class="service-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Service Category</th>
                                        <th>Description</th>
                                        <th>Scope</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($page_data['service_1_category']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($page_data['service_1_description']); ?></td>
                                        <td><?php echo htmlspecialchars($page_data['service_1_scope']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($page_data['service_2_category']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($page_data['service_2_description']); ?></td>
                                        <td><?php echo htmlspecialchars($page_data['service_2_scope']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($page_data['service_3_category']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($page_data['service_3_description']); ?></td>
                                        <td><?php echo htmlspecialchars($page_data['service_3_scope']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($page_data['service_4_category']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($page_data['service_4_description']); ?></td>
                                        <td><?php echo htmlspecialchars($page_data['service_4_scope']); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4><?php echo htmlspecialchars($page_data['eligibility_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['eligibility_text']); ?></p>
                        <ul>
                            <li><?php echo htmlspecialchars($page_data['eligibility_1']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['eligibility_2']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['eligibility_3']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['eligibility_4']); ?></li>
                        </ul>

                        <h4><?php echo htmlspecialchars($page_data['account_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['account_text']); ?></p>
                        <ul>
                            <li><?php echo htmlspecialchars($page_data['account_1']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['account_2']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['account_3']); ?></li>
                            <li><?php echo htmlspecialchars($page_data['account_4']); ?></li>
                        </ul>
                    </div>

                    <!-- Services and Use -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['services_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['services_desc']); ?></p>
                        
                        <div class="prohibited-activities">
                            <h4><?php echo htmlspecialchars($page_data['prohibited_title']); ?></h4>
                            <p><?php echo htmlspecialchars($page_data['prohibited_text']); ?></p>
                            <ul>
                                <li><?php echo htmlspecialchars($page_data['prohibited_1']); ?></li>
                                <li><?php echo htmlspecialchars($page_data['prohibited_2']); ?></li>
                                <li><?php echo htmlspecialchars($page_data['prohibited_3']); ?></li>
                                <li><?php echo htmlspecialchars($page_data['prohibited_4']); ?></li>
                            </ul>
                        </div>
                    </div>

                    <!-- Liability -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['liability_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['liability_text']); ?></p>
                    </div>

                    <!-- Privacy -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['privacy_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['privacy_text']); ?></p>
                    </div>

                    <!-- Termination -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['termination_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['termination_text']); ?></p>
                    </div>

                    <!-- Changes -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['changes_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['changes_text']); ?></p>
                    </div>

                    <!-- Contact -->
                    <div class="terms-section">
                        <h2><?php echo htmlspecialchars($page_data['contact_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['contact_text']); ?></p>
                        <div class="contact-info">
                            <p><strong>Email:</strong> <?php echo htmlspecialchars($page_data['contact_email']); ?></p>
                            <p><strong>Phone:</strong> <?php echo htmlspecialchars($page_data['contact_phone']); ?></p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 