<?php
if (!isset($_FILES['image']) || !isset($_POST['folder'])) {
    http_response_code(400);
    echo "Paramètres manquants.";
    exit;
}

$folder = trim($_POST['folder']);
$folder = rtrim($folder, '/'); // supprime le slash final

// Sécurise le chemin
$folder = preg_replace('/[^a-zA-Z0-9\/_-]/', '', $folder);
$uploadDir = __DIR__ . '/' . $folder;

if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$originalName = basename($_FILES['image']['name']);
$extension = pathinfo($originalName, PATHINFO_EXTENSION);
$newName = uniqid('img_', true) . '.' . $extension;
$targetFile = "$uploadDir/$newName";

if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)) {
    // Renvoie le chemin relatif pour mise à jour dans le champ url
    echo $folder . '/' . $newName;
} else {
    http_response_code(500);
    echo "Erreur de téléchargement.";
}
?>
